/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ActivitiTimerExecutionTest
extends BaseSpringTest {
    private static final String USER1 = "User1" + GUID.generate();
    private RetryingTransactionHelper transactionHelper;
    private WorkflowService workflowService;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private ProcessEngine activitiProcessEngine;
    private TestPersonManager personManager;

    @Test
    public void testTimerExecutionAuthentication() throws Exception {
        try {
            WorkflowInstance taskAssigneeWorkflowInstance = (WorkflowInstance)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<WorkflowInstance>(){

                public WorkflowInstance execute() throws Throwable {
                    ActivitiTimerExecutionTest.this.personManager.createPerson(USER1);
                    WorkflowDefinition definition = ActivitiTimerExecutionTest.this.deployDefinition("activiti/testTimerTransaction.bpmn20.xml");
                    HashMap<QName, Object> params = new HashMap<QName, Object>();
                    params.put(QName.createQName((String)"error"), Boolean.FALSE);
                    params.put(QName.createQName((String)"theTaskAssignee"), USER1);
                    WorkflowPath path = ActivitiTimerExecutionTest.this.workflowService.startWorkflow(definition.getId(), params);
                    ActivitiTimerExecutionTest.this.workflowService.endTask(ActivitiTimerExecutionTest.this.workflowService.getStartTask(path.getInstance().getId()).getId(), null);
                    return path.getInstance();
                }
            }, false, true);
            this.waitForTimersToBeExecuted(taskAssigneeWorkflowInstance.getId());
            WorkflowPath path = (WorkflowPath)this.workflowService.getWorkflowPaths(taskAssigneeWorkflowInstance.getId()).get(0);
            List tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
            ActivitiTimerExecutionTest.assertNotNull((Object)tasks);
            ActivitiTimerExecutionTest.assertEquals((int)1, (int)tasks.size());
            ActivitiTimerExecutionTest.assertEquals((String)"waitTask", (String)((WorkflowTask)tasks.get(0)).getDefinition().getNode().getName());
            Map pathProps = this.workflowService.getPathProperties(path.getId());
            ActivitiTimerExecutionTest.assertEquals((Object)USER1, pathProps.get(QName.createQName((String)"timerExecutedAs")));
        }
        finally {
            this.cleanUp();
        }
    }

    @Test
    public void testTimerExecutionTransactionRollback() throws Exception {
        try {
            WorkflowInstance workflowInstance = (WorkflowInstance)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<WorkflowInstance>(){

                public WorkflowInstance execute() throws Throwable {
                    NodeRef person = ActivitiTimerExecutionTest.this.personManager.createPerson(USER1);
                    ActivitiTimerExecutionTest.assertNotNull((Object)person);
                    WorkflowDefinition definition = ActivitiTimerExecutionTest.this.deployDefinition("activiti/testTimerTransaction.bpmn20.xml");
                    HashMap<QName, Object> params = new HashMap<QName, Object>();
                    params.put(QName.createQName((String)"error"), Boolean.TRUE);
                    params.put(QName.createQName((String)"theTaskAssignee"), USER1);
                    WorkflowPath path = ActivitiTimerExecutionTest.this.workflowService.startWorkflow(definition.getId(), params);
                    ActivitiTimerExecutionTest.this.workflowService.endTask(ActivitiTimerExecutionTest.this.workflowService.getStartTask(path.getInstance().getId()).getId(), null);
                    return path.getInstance();
                }
            }, false, true);
            String processInstanceId = BPMEngineRegistry.getLocalId((String)workflowInstance.getId());
            TimerEntity timer = (TimerEntity)this.activitiProcessEngine.getManagementService().createJobQuery().timers().processInstanceId(processInstanceId).singleResult();
            int numberOfRetries = 5;
            int i = 0;
            while (i < numberOfRetries) {
                if (timer.getExceptionMessage() != null && timer.getRetries() == 0) break;
                Thread.sleep(1000L);
                timer = (TimerEntity)this.activitiProcessEngine.getManagementService().createJobQuery().timers().processInstanceId(processInstanceId).singleResult();
                ++i;
            }
            ActivitiTimerExecutionTest.assertNotNull((String)"Job should have exception message set", (Object)timer.getExceptionMessage());
            String fullExceptionStacktrace = this.activitiProcessEngine.getManagementService().getJobExceptionStacktrace(timer.getId());
            ActivitiTimerExecutionTest.assertTrue((boolean)fullExceptionStacktrace.contains("Activiti engine rocks!"));
            this.transactionHelper.doInTransaction(() -> {
                AuthenticationUtil.runAsSystem(() -> {
                    NodeRef personNode = this.personManager.get(USER1);
                    NodeRef userHomeNode = (NodeRef)this.nodeService.getProperty(personNode, ContentModel.PROP_HOMEFOLDER);
                    String homeFolderName = (String)((Object)this.nodeService.getProperty(userHomeNode, ContentModel.PROP_NAME));
                    ActivitiTimerExecutionTest.assertNotSame((Object)"User home changed", (Object)homeFolderName);
                    return null;
                });
                return null;
            }, false, true);
        }
        finally {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    ActivitiTimerExecutionTest.this.personManager.clearPeople();
                }
                finally {
                    ProcessDefinition procDef = (ProcessDefinition)ActivitiTimerExecutionTest.this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("testTimerTransaction").latestVersion().singleResult();
                    if (procDef != null) {
                        ActivitiTimerExecutionTest.this.activitiProcessEngine.getRepositoryService().deleteDeployment(procDef.getDeploymentId(), true);
                    }
                }
                return null;
            }
        });
    }

    @Before
    public void before() throws Exception {
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.workflowService = registry.getWorkflowService();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.nodeService = registry.getNodeService();
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.activitiProcessEngine = (ProcessEngine)this.applicationContext.getBean("activitiProcessEngine");
        MutableAuthenticationService authenticationService = registry.getAuthenticationService();
        PersonService personService = registry.getPersonService();
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    private void waitForTimersToBeExecuted(String workflowInstanceId) throws Exception {
        String processInstanceId = BPMEngineRegistry.getLocalId((String)workflowInstanceId);
        List timers = null;
        int numberOfRetries = 5;
        int i = 0;
        while (i < numberOfRetries) {
            Thread.sleep(1500L);
            timers = this.activitiProcessEngine.getManagementService().createJobQuery().timers().processInstanceId(processInstanceId).list();
            if (timers.size() == 0) break;
            ++i;
        }
        if (timers.size() > 0) {
            ActivitiTimerExecutionTest.fail((String)("There are still timers available for the process: " + processInstanceId));
        }
    }

    protected WorkflowDefinition deployDefinition(String resource) {
        InputStream input = this.getInputStream(resource);
        WorkflowDeployment deployment = this.workflowService.deployDefinition("activiti", input, "text/xml");
        WorkflowDefinition definition = deployment.getDefinition();
        return definition;
    }

    private InputStream getInputStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream(resource);
        return input;
    }
}

