/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.activities.feed.FeedNotifier;
import org.alfresco.repo.activities.feed.UserNotifier;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.UrlUtil;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;

public class FeedNotifierImpl
implements FeedNotifier,
ApplicationContextAware {
    protected static Log logger = LogFactory.getLog(FeedNotifier.class);
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ActivityFeedNotifier");
    private static final long LOCK_TTL = 30000L;
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(FeedNotifierImpl.class.getName());
    private static final String MSG_EMAIL_SUBJECT = "activities.feed.notifier.email.subject";
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private SearchService searchService;
    private PersonService personService;
    private NodeService nodeService;
    private JobLockService jobLockService;
    private TransactionService transactionService;
    private SysAdminParams sysAdminParams;
    private RepoAdminService repoAdminService;
    private UserNotifier userNotifier;
    private ApplicationContext applicationContext;
    private RepositoryLocation feedEmailTemplateLocation;
    private int numThreads = 4;
    private int batchSize = 200;

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setUserNotifier(UserNotifier userNotifier) {
        this.userNotifier = userNotifier;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"sysAdminParams", (Object)this.sysAdminParams);
    }

    @Override
    public void execute(int repeatIntervalMins) {
        this.checkProperties();
        if (this.transactionService.isReadOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Activities email notification bypassed; the system is read-only");
            }
            return;
        }
        String lockToken = null;
        final AtomicBoolean running = new AtomicBoolean(true);
        try {
            lockToken = this.jobLockService.getLock(LOCK_QNAME, 30000L);
            if (lockToken == null) {
                logger.info((Object)"Can't get lock. Assume multiple feed notifiers...");
                return;
            }
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Activities email notification started");
                }
                this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 30000L, new JobLockService.JobLockRefreshCallback(){

                    @Override
                    public boolean isActive() {
                        return running.get();
                    }

                    @Override
                    public void lockReleased() {
                        running.set(false);
                    }
                });
                this.executeInternal(repeatIntervalMins);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Activities email notification completed");
                }
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Activities email notification already underway");
                }
            }
            catch (VmShutdownListener.VmShutdownException vmShutdownException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Activities email notification aborted");
                }
            }
        }
        finally {
            running.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    public void setFeedEmailTemplateLocation(RepositoryLocation feedEmailTemplateLocation) {
        this.feedEmailTemplateLocation = feedEmailTemplateLocation;
    }

    protected String getEmailTemplateRef() {
        String locationType = this.feedEmailTemplateLocation.getQueryLanguage();
        if (locationType.equals("xpath")) {
            List nodeRefs;
            block7: {
                String xpath;
                StoreRef store;
                block6: {
                    store = this.feedEmailTemplateLocation.getStoreRef();
                    xpath = this.feedEmailTemplateLocation.getPath();
                    try {
                        if (this.feedEmailTemplateLocation.getQueryLanguage().equals("xpath")) break block6;
                        logger.error((Object)("Cannot find the activities email template - repository location query language is not 'xpath': " + this.feedEmailTemplateLocation.getQueryLanguage()));
                        return null;
                    }
                    catch (SearcherException e) {
                        logger.error((Object)"Cannot find the email template!", (Throwable)e);
                        return null;
                    }
                }
                nodeRefs = this.searchService.selectNodes(this.nodeService.getRootNode(store), xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
                if (nodeRefs.size() == 1) break block7;
                logger.error((Object)("Cannot find the activities email template: " + xpath));
                return null;
            }
            return this.fileFolderService.getLocalizedSibling((NodeRef)nodeRefs.get(0)).toString();
        }
        if (locationType.equals("classpath")) {
            return this.feedEmailTemplateLocation.getPath();
        }
        logger.error((Object)("Unsupported location type: " + locationType));
        return null;
    }

    private void executeInternal(final int repeatIntervalMins) {
        block20: {
            final String emailTemplateRef = this.getEmailTemplateRef();
            if (emailTemplateRef == null) {
                return;
            }
            final String shareUrl = UrlUtil.getShareUrl(this.sysAdminParams);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Share URL configured as: " + shareUrl));
            }
            final AtomicInteger userCnt = new AtomicInteger(0);
            final AtomicInteger feedEntryCnt = new AtomicInteger(0);
            long startTime = System.currentTimeMillis();
            final ConcurrentHashMap siteNames = new ConcurrentHashMap(10);
            try {
                try {
                    final String currentUser = AuthenticationUtil.getRunAsUser();
                    final String tenantDomain = TenantUtil.getCurrentDomain();
                    BatchProcessor.BatchProcessWorker<PersonService.PersonInfo> worker = new BatchProcessor.BatchProcessWorker<PersonService.PersonInfo>(){

                        @Override
                        public String getIdentifier(PersonService.PersonInfo person) {
                            StringBuilder sb = new StringBuilder("Person ");
                            sb.append(person.getUserName());
                            return sb.toString();
                        }

                        @Override
                        public void beforeProcess() throws Throwable {
                            AuthenticationUtil.pushAuthentication();
                            AuthenticationUtil.setFullyAuthenticatedUser((String)currentUser);
                        }

                        @Override
                        public void afterProcess() throws Throwable {
                            AuthenticationUtil.popAuthentication();
                        }

                        @Override
                        public void process(final PersonService.PersonInfo person) throws Throwable {
                            final RetryingTransactionHelper txHelper = FeedNotifierImpl.this.transactionService.getRetryingTransactionHelper();
                            txHelper.setMaxRetries(0);
                            TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                                public Void doWork() throws Exception {
                                    txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                                        @Override
                                        public Void execute() throws Throwable {
                                            this.processInternal(person);
                                            return null;
                                        }
                                    }, false, true);
                                    return null;
                                }
                            }, (String)tenantDomain);
                        }

                        private void processInternal(PersonService.PersonInfo person) throws Exception {
                            NodeRef personNodeRef = person.getNodeRef();
                            try {
                                Pair<Integer, Long> result = FeedNotifierImpl.this.userNotifier.notifyUser(personNodeRef, FeedNotifierImpl.MSG_EMAIL_SUBJECT, new Object[]{ModelUtil.getProductName(FeedNotifierImpl.this.repoAdminService)}, siteNames, shareUrl, repeatIntervalMins, emailTemplateRef);
                                if (result != null) {
                                    int entryCnt = (Integer)result.getFirst();
                                    long maxFeedId = (Long)result.getSecond();
                                    Long currentMaxFeedId = (Long)FeedNotifierImpl.this.nodeService.getProperty(personNodeRef, ContentModel.PROP_EMAIL_FEED_ID);
                                    if (currentMaxFeedId == null || currentMaxFeedId < maxFeedId) {
                                        FeedNotifierImpl.this.nodeService.setProperty(personNodeRef, ContentModel.PROP_EMAIL_FEED_ID, (Serializable)Long.valueOf(maxFeedId));
                                    }
                                    userCnt.incrementAndGet();
                                    feedEntryCnt.addAndGet(entryCnt);
                                }
                            }
                            catch (InvalidNodeRefException inre) {
                                logger.warn((Object)("Skip feed notification for user (" + String.valueOf(personNodeRef) + "): " + inre.getMessage()));
                            }
                        }
                    };
                    BatchProcessWorkProvider<PersonService.PersonInfo> provider = new BatchProcessWorkProvider<PersonService.PersonInfo>(){
                        private int skip = 0;
                        private int maxItems;
                        private boolean hasMore;
                        {
                            this.maxItems = FeedNotifierImpl.this.batchSize;
                            this.hasMore = true;
                        }

                        @Override
                        public int getTotalEstimatedWorkSize() {
                            return FeedNotifierImpl.this.personService.countPeople();
                        }

                        @Override
                        public long getTotalEstimatedWorkSizeLong() {
                            return FeedNotifierImpl.this.personService.countPeople();
                        }

                        @Override
                        public Collection<PersonService.PersonInfo> getNextWork() {
                            if (!this.hasMore) {
                                return Collections.emptyList();
                            }
                            PagingResults<PersonService.PersonInfo> people = FeedNotifierImpl.this.personService.getPeople(null, null, null, new PagingRequest(this.skip, this.maxItems));
                            List page = people.getPage();
                            this.skip += page.size();
                            this.hasMore = people.hasMoreItems();
                            return page;
                        }
                    };
                    RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
                    txHelper.setMaxRetries(0);
                    new BatchProcessor<PersonService.PersonInfo>("FeedNotifier", txHelper, provider, this.numThreads, this.batchSize, (ApplicationEventPublisher)this.applicationContext, logger, 100).process(worker, true);
                }
                catch (Throwable e) {
                    if (!vmShutdownListener.isVmShuttingDown()) {
                        logger.error((Object)"Exception during notification of feeds", e);
                    }
                    int count = userCnt.get();
                    int entryCount = feedEntryCnt.get();
                    if (count > 0) {
                        if (logger.isInfoEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Notified ").append(userCnt).append(" user").append(count != 1 ? "s" : "");
                            sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(entryCount != 1 ? "ies" : "y");
                            sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                            logger.info((Object)sb.toString());
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Nothing to send since no new user activities found");
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                int count = userCnt.get();
                int entryCount = feedEntryCnt.get();
                if (count > 0) {
                    if (logger.isInfoEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Notified ").append(userCnt).append(" user").append(count != 1 ? "s" : "");
                        sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(entryCount != 1 ? "ies" : "y");
                        sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                        logger.info((Object)sb.toString());
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Nothing to send since no new user activities found");
                }
                throw throwable;
            }
            int count = userCnt.get();
            int entryCount = feedEntryCnt.get();
            if (count > 0) {
                if (logger.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Notified ").append(userCnt).append(" user").append(count != 1 ? "s" : "");
                    sb.append(" of ").append(feedEntryCnt).append(" activity feed entr").append(entryCount != 1 ? "ies" : "y");
                    sb.append(" (in ").append(System.currentTimeMillis() - startTime).append(" msecs)");
                    logger.info((Object)sb.toString());
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)"Nothing to send since no new user activities found");
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

