/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.audit.AuditRecord;
import org.alfresco.service.cmr.repository.NodeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditRecordUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditRecordUtils.class);

    private AuditRecordUtils() {
    }

    public static AuditRecord.Builder generateAuditRecordBuilder(Map<?, Serializable> data, int keyRootLength) {
        AuditRecord.Builder auditRecordBuilder = AuditRecord.builder();
        HashMap<String, Serializable> rootNode = AuditRecordUtils.createRootNode(data, keyRootLength);
        auditRecordBuilder.setAuditRecordData(rootNode);
        return auditRecordBuilder;
    }

    private static HashMap<String, Serializable> createRootNode(Map<?, Serializable> data, int keyRootLength) {
        HashMap<String, Serializable> rootNode = new HashMap<String, Serializable>();
        data.forEach((k, v) -> {
            String[] keys = AuditRecordUtils.decodeKeys(k, keyRootLength);
            Serializable value = AuditRecordUtils.decodeValueByInstance(v);
            HashMap current = rootNode;
            int i = 0;
            while (i < keys.length - 1) {
                current = (HashMap)current.computeIfAbsent(keys[i], newMap -> new HashMap());
                ++i;
            }
            current.put(keys[keys.length - 1], value);
        });
        return rootNode;
    }

    private static String[] decodeKeys(Object key, int keyRootLength) {
        if (key instanceof String) {
            String s = (String)key;
            return s.substring(keyRootLength).split("/");
        }
        return new String[]{key.toString()};
    }

    private static Serializable decodeValueByInstance(Serializable value) {
        LOGGER.debug("Decoding value by instance of {}", value.getClass());
        LOGGER.trace("String value of the object: {}", (Object)value);
        if (value instanceof HashMap) {
            return AuditRecordUtils.createRootNode((HashMap)value, 0);
        }
        if (value instanceof NodeRef) {
            NodeRef nodeRef = (NodeRef)value;
            return nodeRef.getId();
        }
        return value;
    }
}

