/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.processor.FieldProcessor;
import org.alfresco.repo.forms.processor.FormCreationData;

public class FieldProcessorRegistry {
    private final Map<String, FieldProcessor> processors = new HashMap<String, FieldProcessor>();
    private FieldProcessor defaultProcessor;

    public void register(String key, FieldProcessor processor) {
        this.processors.put(key, processor);
    }

    public FieldProcessor get(String key) {
        return this.processors.get(key);
    }

    public Field buildField(String fieldName, FormCreationData data) {
        FieldProcessor fieldProcessor = this.getFieldProcessor(fieldName);
        if (fieldProcessor == null) {
            return null;
        }
        return fieldProcessor.generateField(fieldName, data);
    }

    protected FieldProcessor getFieldProcessor(String fieldName) {
        FieldProcessor fieldProcessor = this.get(this.getKey(fieldName));
        if (fieldProcessor == null && this.useDefaultProcessor(fieldName)) {
            fieldProcessor = this.defaultProcessor;
        }
        return fieldProcessor;
    }

    protected boolean useDefaultProcessor(String fieldName) {
        return true;
    }

    protected String getKey(String fieldName) {
        return fieldName;
    }

    public void setDefaultProcessor(FieldProcessor defaultProcessor) {
        this.defaultProcessor = defaultProcessor;
    }
}

