/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.ErrorProneActionExecutor;
import org.alfresco.repo.activities.feed.ErrorProneUserNotifier;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.FeedNotifierImpl;
import org.alfresco.repo.activities.feed.UserNotifier;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:alfresco/feednotifier-tests/test-action-services-context.xml"})
public class FeedNotifierTest
extends BaseSpringTest {
    private PersonService personService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private SiteService siteService;
    private ActivityService activityService;
    private RepoAdminService repoAdminService;
    private FeedNotifierImpl feedNotifier;
    private TransactionService transactionService;
    private PostLookup postLookup;
    private FeedGenerator feedGenerator;
    private FileFolderService fileFolderService;
    private SubscriptionService subscriptionService;
    private ErrorProneActionExecutor errorProneActionExecutor;
    private ActivityPostDAO postDAO;
    private ActionService actionService;
    private ErrorProneUserNotifier userNotifier;
    private NodeRef failingPersonNodeRef;
    private NodeRef personNodeRef;
    private String userName1 = "user1." + GUID.generate();
    private String userName2 = "user2." + GUID.generate();
    private String userName3 = "user3." + GUID.generate();

    @BeforeClass
    public static void init() {
        ApplicationContextHelper.setUseLazyLoading((boolean)false);
        ApplicationContextHelper.setNoAutoStart((boolean)true);
    }

    @Before
    public void before() throws Exception {
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)this.applicationContext.getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.feedNotifier = (FeedNotifierImpl)activitiesFeedCtx.getBean("feedNotifier");
        this.activityService = (ActivityService)activitiesFeedCtx.getBean("activityService");
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        ObjectFactory feedModelBuilderFactory = (ObjectFactory)activitiesFeedCtx.getBean("feedModelBuilderFactory");
        Scheduler scheduler = (Scheduler)this.applicationContext.getBean("schedulerFactory");
        JobDetail feedGeneratorJobDetail = (JobDetail)activitiesFeedCtx.getBean("feedGeneratorJobDetail");
        JobDetail postLookupJobDetail = (JobDetail)activitiesFeedCtx.getBean("postLookupJobDetail");
        JobDetail feedCleanerJobDetail = (JobDetail)activitiesFeedCtx.getBean("feedCleanerJobDetail");
        JobDetail postCleanerJobDetail = (JobDetail)activitiesFeedCtx.getBean("postCleanerJobDetail");
        JobDetail feedNotifierJobDetail = (JobDetail)activitiesFeedCtx.getBean("feedNotifierJobDetail");
        scheduler.pauseJob(feedGeneratorJobDetail.getKey());
        scheduler.pauseJob(postLookupJobDetail.getKey());
        scheduler.pauseJob(feedCleanerJobDetail.getKey());
        scheduler.pauseJob(postCleanerJobDetail.getKey());
        scheduler.pauseJob(feedNotifierJobDetail.getKey());
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.siteService = (SiteService)this.applicationContext.getBean("siteService");
        this.repoAdminService = (RepoAdminService)this.applicationContext.getBean("repoAdminService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.postDAO = (ActivityPostDAO)this.applicationContext.getBean("postDAO");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.subscriptionService = (SubscriptionService)this.applicationContext.getBean("SubscriptionService");
        this.errorProneActionExecutor = (ErrorProneActionExecutor)((Object)this.applicationContext.getBean("errorProneActionExecutor"));
        this.actionService = (ActionService)this.applicationContext.getBean("ActionService");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                PropertyMap personProps = new PropertyMap();
                personProps.put((Object)ContentModel.PROP_USERNAME, (Object)FeedNotifierTest.this.userName1);
                personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)FeedNotifierTest.this.userName1);
                personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)FeedNotifierTest.this.userName1);
                personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(FeedNotifierTest.this.userName1 + "@email.com"));
                FeedNotifierTest.this.personNodeRef = FeedNotifierTest.this.personService.createPerson((Map)personProps);
                personProps = new PropertyMap();
                personProps.put((Object)ContentModel.PROP_USERNAME, (Object)FeedNotifierTest.this.userName2);
                personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)FeedNotifierTest.this.userName2);
                personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)FeedNotifierTest.this.userName2);
                personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(FeedNotifierTest.this.userName2 + "@email.com"));
                FeedNotifierTest.this.failingPersonNodeRef = FeedNotifierTest.this.personService.createPerson((Map)personProps);
                personProps = new PropertyMap();
                personProps.put((Object)ContentModel.PROP_USERNAME, (Object)FeedNotifierTest.this.userName3);
                personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)FeedNotifierTest.this.userName3);
                personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)FeedNotifierTest.this.userName3);
                personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(FeedNotifierTest.this.userName3 + "@email.com"));
                FeedNotifierTest.this.personService.createPerson((Map)personProps);
                AuthenticationUtil.popAuthentication();
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)FeedNotifierTest.this.userName1);
                NodeRef rootNodeRef = FeedNotifierTest.this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                NodeRef workingRootNodeRef = FeedNotifierTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
                FileInfo file1 = FeedNotifierTest.this.fileFolderService.create(workingRootNodeRef, GUID.generate(), ContentModel.TYPE_CONTENT);
                JSONObject activityData = new JSONObject();
                activityData.put("title", (Object)GUID.generate());
                activityData.put("nodeRef", (Object)file1.getNodeRef());
                FeedNotifierTest.this.activityService.postActivity("org.alfresco.documentlibrary.file-added", null, "documentlibrary", activityData.toString(), FeedNotifierTest.this.userName1);
                AuthenticationUtil.popAuthentication();
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)FeedNotifierTest.this.userName2);
                FeedNotifierTest.this.subscriptionService.follow(FeedNotifierTest.this.userName2, FeedNotifierTest.this.userName1);
                AuthenticationUtil.popAuthentication();
                return null;
            }
        }, false, true);
        this.generateActivities();
        this.userNotifier = new ErrorProneUserNotifier(this.failingPersonNodeRef);
        this.userNotifier.setNodeService(this.nodeService);
        this.userNotifier.setNamespaceService(this.namespaceService);
        this.userNotifier.setSiteService(this.siteService);
        this.userNotifier.setActivityService(this.activityService);
        this.userNotifier.setRepoAdminService(this.repoAdminService);
        this.userNotifier.setActionService(this.actionService);
        this.userNotifier.setActivitiesFeedModelBuilderFactory(feedModelBuilderFactory);
        this.feedNotifier.setUserNotifier((UserNotifier)this.userNotifier);
    }

    private void generateActivities() throws Exception {
        this.postLookup.execute();
        Long maxSequence = this.postDAO.getMaxActivitySeq();
        while (maxSequence != null) {
            this.feedGenerator.execute();
            maxSequence = this.postDAO.getMaxActivitySeq();
        }
    }

    @Test
    public void testNumThread() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.generateActivities();
        this.feedNotifier.setNumThreads(1);
        this.feedNotifier.execute(1);
        FeedNotifierTest.assertTrue((this.errorProneActionExecutor.getNumSuccess() > 0 ? 1 : 0) != 0);
        this.feedNotifier.setNumThreads(4);
        this.feedNotifier.execute(1);
        FeedNotifierTest.assertTrue((this.errorProneActionExecutor.getNumSuccess() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFailedNotifications() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        FeedNotifierTest.assertEquals((int)0, (int)this.errorProneActionExecutor.getNumSuccess());
        FeedNotifierTest.assertEquals((int)0, (int)this.errorProneActionExecutor.getNumFailed());
        this.feedNotifier.execute(1);
        FeedNotifierTest.assertEquals((int)1, (int)this.errorProneActionExecutor.getNumFailed());
        FeedNotifierTest.assertTrue((this.errorProneActionExecutor.getNumSuccess() > 0 ? 1 : 0) != 0);
        int numSuccessfulNotifications = this.errorProneActionExecutor.getNumSuccess();
        this.feedNotifier.execute(1);
        FeedNotifierTest.assertEquals((int)2, (int)this.errorProneActionExecutor.getNumFailed());
        FeedNotifierTest.assertEquals((int)numSuccessfulNotifications, (int)this.errorProneActionExecutor.getNumSuccess());
    }

    @Test
    public void testNullSiteNetworkStatus() throws Exception {
        final String siteId = null;
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)FeedNotifierTest.this.userName3);
                FeedNotifierTest.this.activityService.postActivity("org.alfresco.profile.status-changed", siteId, "profile", "{\"status\":\"test\"}");
                AuthenticationUtil.popAuthentication();
                return null;
            }
        }, false, true);
        this.generateActivities();
        List feeds = Collections.emptyList();
        try {
            feeds = this.activityService.getUserFeedEntries(this.userName3, null, false, false, null, null, -1L);
        }
        catch (Exception exception) {
            FeedNotifierTest.fail((String)"Failed to get user's posts.");
        }
        boolean found = false;
        for (ActivityFeedEntity feed : feeds) {
            if (!feed.getActivityType().equals("org.alfresco.profile.status-changed") || !"@@NULL@@".equals(feed.getSiteNetwork())) continue;
            found = true;
        }
        FeedNotifierTest.assertTrue((String)"The post should be found.", (boolean)found);
    }

    @Test
    public void testSetup() {
    }
}

