/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.policy.AssociationPolicy;
import org.alfresco.repo.policy.AssociationPolicyDelegate;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyComponentImpl;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.repo.policy.PolicyType;
import org.alfresco.repo.policy.PropertyPolicy;
import org.alfresco.repo.policy.PropertyPolicyDelegate;
import org.alfresco.repo.tenant.SingleTServiceImpl;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ThreadPoolExecutorFactoryBean;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;

public class PolicyComponentTest
extends TestCase {
    private static final String TEST_MODEL = "org/alfresco/repo/policy/policycomponenttest_model.xml";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
    private static QName BASE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base");
    private static QName BASE_PROP_A = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base_a");
    private static QName BASE_ASSOC_A = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base_assoc_a");
    private static QName FILE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"file");
    private static QName FILE_PROP_B = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"file_b");
    private static QName FOLDER_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"folder");
    private static QName FOLDER_PROP_D = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"folder_d");
    private static QName TEST_ASPECT = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"aspect");
    private static QName ASPECT_PROP_A = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"aspect_a");
    private static QName INVALID_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"classdoesnotexist");
    private PolicyComponent policyComponent = null;

    protected void setUp() throws Exception {
        SingleTServiceImpl tenantService = new SingleTServiceImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl();
        dictionaryDAO.setTenantService((TenantService)tenantService);
        this.initDictionaryCaches(dictionaryDAO, (TenantService)tenantService);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add(TEST_MODEL);
        bootstrapModels.add(TEST_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        bootstrap.setTenantService((TenantService)new SingleTServiceImpl());
        bootstrap.bootstrap();
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO((DictionaryDAO)dictionaryDAO);
        this.policyComponent = new PolicyComponentImpl((DictionaryService)dictionary);
    }

    private void initDictionaryCaches(DictionaryDAOImpl dictionaryDAO, TenantService tenantService) throws Exception {
        CompiledModelsCache compiledModelsCache = new CompiledModelsCache();
        compiledModelsCache.setDictionaryDAO(dictionaryDAO);
        compiledModelsCache.setTenantService(tenantService);
        compiledModelsCache.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
        ThreadPoolExecutorFactoryBean threadPoolfactory = new ThreadPoolExecutorFactoryBean();
        threadPoolfactory.afterPropertiesSet();
        compiledModelsCache.setThreadPoolExecutor((ThreadPoolExecutor)threadPoolfactory.getObject());
        dictionaryDAO.setDictionaryRegistryCache(compiledModelsCache);
        dictionaryDAO.init();
    }

    public void testJavaBehaviour() {
        JavaBehaviour validBehaviour = new JavaBehaviour((Object)this, "validTest");
        TestClassPolicy policy = (TestClassPolicy)validBehaviour.getInterface(TestClassPolicy.class);
        PolicyComponentTest.assertNotNull((Object)policy);
        String result = policy.test("argument");
        PolicyComponentTest.assertEquals((String)"ValidTest: argument", (String)result);
    }

    public void testRegisterDefinitions() {
        try {
            this.policyComponent.registerClassPolicy(InvalidMetaDataPolicy.class);
            PolicyComponentTest.fail((String)"Failed to catch hidden metadata");
        }
        catch (PolicyException policyException) {}
        try {
            this.policyComponent.registerClassPolicy(NoMethodPolicy.class);
            PolicyComponentTest.fail((String)"Failed to catch no methods defined in policy");
        }
        catch (PolicyException policyException) {}
        try {
            this.policyComponent.registerClassPolicy(MultiMethodPolicy.class);
            PolicyComponentTest.fail((String)"Failed to catch multiple methods defined in policy");
        }
        catch (PolicyException policyException) {}
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        boolean isRegistered = this.policyComponent.isRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTest.assertFalse((boolean)isRegistered);
        ClassPolicyDelegate delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        PolicyComponentTest.assertNotNull((Object)delegate);
        isRegistered = this.policyComponent.isRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTest.assertTrue((boolean)isRegistered);
        PolicyDefinition definition = this.policyComponent.getRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTest.assertNotNull((Object)definition);
        PolicyComponentTest.assertEquals((Object)policyName, (Object)definition.getName());
        PolicyComponentTest.assertEquals((Object)PolicyType.Class, (Object)definition.getType());
        PolicyComponentTest.assertEquals(TestClassPolicy.class, (Object)definition.getPolicyInterface());
    }

    public void testBindBehaviour() {
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour validBehaviour = new JavaBehaviour((Object)this, "validTest");
        try {
            this.policyComponent.bindClassBehaviour(null, FILE_TYPE, (Behaviour)validBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch null policy whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.policyComponent.bindClassBehaviour(policyName, null, (Behaviour)validBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch null class reference whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.policyComponent.bindClassBehaviour(policyName, INVALID_TYPE, (Behaviour)validBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch invalid class reference whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, null);
            PolicyComponentTest.fail((String)"Failed to catch null behaviour whilst binding behaviour");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        JavaBehaviour invalidBehaviour = new JavaBehaviour((Object)this, "methoddoesnotexist");
        this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        try {
            this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)invalidBehaviour);
            PolicyComponentTest.fail((String)"Failed to catch invalid behaviour whilst binding behaviour");
        }
        catch (PolicyException policyException) {}
        try {
            BehaviourDefinition definition = this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)validBehaviour);
            PolicyComponentTest.assertNotNull((Object)definition);
            PolicyComponentTest.assertEquals((Object)policyName, (Object)definition.getPolicy());
            PolicyComponentTest.assertEquals((Object)FILE_TYPE, (Object)((ClassBehaviourBinding)definition.getBinding()).getClassQName());
        }
        catch (PolicyException policyException) {
            PolicyComponentTest.fail((String)"Policy exception thrown for valid behaviour");
        }
    }

    public void testClassDelegate() {
        ClassPolicyDelegate delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour fileBehaviour = new JavaBehaviour((Object)this, "fileTest");
        this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)fileBehaviour);
        Collection basePolicies = delegate.getList(BASE_TYPE);
        PolicyComponentTest.assertNotNull((Object)basePolicies);
        PolicyComponentTest.assertEquals((int)0, (int)basePolicies.size());
        TestClassPolicy basePolicy = (TestClassPolicy)delegate.get(BASE_TYPE);
        PolicyComponentTest.assertNotNull((Object)basePolicy);
        Collection filePolicies = delegate.getList(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)filePolicies);
        PolicyComponentTest.assertEquals((int)1, (int)filePolicies.size());
        TestClassPolicy filePolicy = (TestClassPolicy)delegate.get(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)filePolicy);
        JavaBehaviour serviceBehaviour = new JavaBehaviour((Object)this, "serviceTest");
        this.policyComponent.bindClassBehaviour(policyName, (Object)this, (Behaviour)serviceBehaviour);
        Collection file2Policies = delegate.getList(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)file2Policies);
        PolicyComponentTest.assertEquals((int)2, (int)file2Policies.size());
        TestClassPolicy filePolicy2 = (TestClassPolicy)delegate.get(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)filePolicy2);
        JavaBehaviour file2Behaviour = new JavaBehaviour((Object)this, "fileTest2");
        this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)file2Behaviour);
        Collection file3Policies = delegate.getList(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)file3Policies);
        PolicyComponentTest.assertEquals((int)3, (int)file3Policies.size());
        TestClassPolicy filePolicy3 = (TestClassPolicy)delegate.get(FILE_TYPE);
        PolicyComponentTest.assertNotNull((Object)filePolicy3);
    }

    public void testClassOverride() {
        ClassPolicyDelegate delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindClassBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        TestClassPolicy basePolicy = (TestClassPolicy)delegate.get(BASE_TYPE);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestClassPolicy filePolicy = (TestClassPolicy)delegate.get(FILE_TYPE);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestClassPolicy folderPolicy = (TestClassPolicy)delegate.get(FOLDER_TYPE);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
    }

    public void testClassCache() {
        ClassPolicyDelegate delegate = this.policyComponent.registerClassPolicy(TestClassPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindClassBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        TestClassPolicy basePolicy = (TestClassPolicy)delegate.get(BASE_TYPE);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestClassPolicy filePolicy = (TestClassPolicy)delegate.get(FILE_TYPE);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestClassPolicy folderPolicy = (TestClassPolicy)delegate.get(FOLDER_TYPE);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
        TestClassPolicy basePolicy2 = (TestClassPolicy)delegate.get(BASE_TYPE);
        PolicyComponentTest.assertTrue((basePolicy == basePolicy2 ? 1 : 0) != 0);
        TestClassPolicy filePolicy2 = (TestClassPolicy)delegate.get(FILE_TYPE);
        PolicyComponentTest.assertTrue((filePolicy == filePolicy2 ? 1 : 0) != 0);
        TestClassPolicy folderPolicy2 = (TestClassPolicy)delegate.get(FOLDER_TYPE);
        PolicyComponentTest.assertTrue((folderPolicy == folderPolicy2 ? 1 : 0) != 0);
        JavaBehaviour newBaseBehaviour = new JavaBehaviour((Object)this, "newBaseTest");
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)newBaseBehaviour);
        TestClassPolicy basePolicy3 = (TestClassPolicy)delegate.get(BASE_TYPE);
        PolicyComponentTest.assertTrue((basePolicy3 != basePolicy2 ? 1 : 0) != 0);
        String baseResult3 = basePolicy3.test("base");
        PolicyComponentTest.assertEquals((String)"NewBase: base", (String)baseResult3);
        TestClassPolicy filePolicy3 = (TestClassPolicy)delegate.get(FILE_TYPE);
        PolicyComponentTest.assertTrue((filePolicy3 != filePolicy2 ? 1 : 0) != 0);
        String fileResult3 = filePolicy3.test("file");
        PolicyComponentTest.assertEquals((String)"NewBase: file", (String)fileResult3);
        TestClassPolicy folderPolicy3 = (TestClassPolicy)delegate.get(FOLDER_TYPE);
        PolicyComponentTest.assertTrue((folderPolicy3 != folderPolicy2 ? 1 : 0) != 0);
        String folderResult3 = folderPolicy3.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult3);
        JavaBehaviour fileBehaviour = new JavaBehaviour((Object)this, "fileTest");
        this.policyComponent.bindClassBehaviour(policyName, FILE_TYPE, (Behaviour)fileBehaviour);
        TestClassPolicy basePolicy4 = (TestClassPolicy)delegate.get(BASE_TYPE);
        PolicyComponentTest.assertTrue((basePolicy4 == basePolicy3 ? 1 : 0) != 0);
        String baseResult4 = basePolicy4.test("base");
        PolicyComponentTest.assertEquals((String)"NewBase: base", (String)baseResult4);
        TestClassPolicy filePolicy4 = (TestClassPolicy)delegate.get(FILE_TYPE);
        PolicyComponentTest.assertTrue((filePolicy4 != filePolicy3 ? 1 : 0) != 0);
        String fileResult4 = filePolicy4.test("file");
        PolicyComponentTest.assertEquals((String)"File: file", (String)fileResult4);
        TestClassPolicy folderPolicy4 = (TestClassPolicy)delegate.get(FOLDER_TYPE);
        PolicyComponentTest.assertTrue((folderPolicy4 == folderPolicy3 ? 1 : 0) != 0);
        String folderResult4 = folderPolicy4.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult4);
    }

    public void testPropertyDelegate() {
        PropertyPolicyDelegate delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour fileBehaviour = new JavaBehaviour((Object)this, "fileTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FILE_TYPE, FILE_PROP_B, (Behaviour)fileBehaviour);
        Collection basePolicies = delegate.getList(BASE_TYPE, BASE_PROP_A);
        PolicyComponentTest.assertNotNull((Object)basePolicies);
        PolicyComponentTest.assertEquals((int)0, (int)basePolicies.size());
        TestPropertyPolicy basePolicy = (TestPropertyPolicy)delegate.get(BASE_TYPE, BASE_PROP_A);
        PolicyComponentTest.assertNotNull((Object)basePolicy);
        Collection filePolicies = delegate.getList(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull((Object)filePolicies);
        PolicyComponentTest.assertEquals((int)1, (int)filePolicies.size());
        TestPropertyPolicy filePolicy = (TestPropertyPolicy)delegate.get(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull((Object)filePolicy);
        JavaBehaviour serviceBehaviour = new JavaBehaviour((Object)this, "serviceTest");
        this.policyComponent.bindPropertyBehaviour(policyName, (Object)this, (Behaviour)serviceBehaviour);
        Collection file2Policies = delegate.getList(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull((Object)file2Policies);
        PolicyComponentTest.assertEquals((int)2, (int)file2Policies.size());
        TestPropertyPolicy filePolicy2 = (TestPropertyPolicy)delegate.get(FILE_TYPE, FILE_PROP_B);
        PolicyComponentTest.assertNotNull((Object)filePolicy2);
    }

    public void testPropertyOverride() {
        PropertyPolicyDelegate delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, BASE_PROP_A, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, BASE_PROP_A, (Behaviour)folderBehaviour);
        JavaBehaviour folderBehaviourD = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, FOLDER_PROP_D, (Behaviour)folderBehaviourD);
        TestPropertyPolicy basePolicy = (TestPropertyPolicy)delegate.get(BASE_TYPE, BASE_PROP_A);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestPropertyPolicy filePolicy = (TestPropertyPolicy)delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestPropertyPolicy folderPolicy = (TestPropertyPolicy)delegate.get(FOLDER_TYPE, BASE_PROP_A);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
        TestPropertyPolicy folderPolicy2 = (TestPropertyPolicy)delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult2 = folderPolicy2.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult2);
    }

    public void testPropertyWildcard() {
        PropertyPolicyDelegate delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        JavaBehaviour aspectBehaviour = new JavaBehaviour((Object)this, "aspectTest");
        this.policyComponent.bindPropertyBehaviour(policyName, TEST_ASPECT, (Behaviour)aspectBehaviour);
        TestPropertyPolicy basePolicy = (TestPropertyPolicy)delegate.get(BASE_TYPE, BASE_PROP_A);
        String baseResult = basePolicy.test("base");
        PolicyComponentTest.assertEquals((String)"Base: base", (String)baseResult);
        TestPropertyPolicy filePolicy = (TestPropertyPolicy)delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestPropertyPolicy folderPolicy = (TestPropertyPolicy)delegate.get(FOLDER_TYPE, BASE_PROP_A);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult);
        TestPropertyPolicy folderPolicy2 = (TestPropertyPolicy)delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult2 = folderPolicy2.test("folder");
        PolicyComponentTest.assertEquals((String)"Folder: folder", (String)folderResult2);
        TestPropertyPolicy aspectPolicy = (TestPropertyPolicy)delegate.get(TEST_ASPECT, ASPECT_PROP_A);
        String aspectResult = aspectPolicy.test("aspect_prop_a");
        PolicyComponentTest.assertEquals((String)"Aspect: aspect_prop_a", (String)aspectResult);
        TestPropertyPolicy aspectPolicy2 = (TestPropertyPolicy)delegate.get(TEST_ASPECT, FOLDER_PROP_D);
        String aspectResult2 = aspectPolicy2.test("aspect_folder_d");
        PolicyComponentTest.assertEquals((String)"Aspect: aspect_folder_d", (String)aspectResult2);
        JavaBehaviour folderDBehaviour = new JavaBehaviour((Object)this, "folderDTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, FOLDER_PROP_D, (Behaviour)folderDBehaviour);
        TestPropertyPolicy folderPolicy3 = (TestPropertyPolicy)delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult3 = folderPolicy3.test("folder");
        PolicyComponentTest.assertEquals((String)"FolderD: folder", (String)folderResult3);
    }

    public void testPropertyCache() {
        PropertyPolicyDelegate delegate = this.policyComponent.registerPropertyPolicy(TestPropertyPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        JavaBehaviour folderBehaviour = new JavaBehaviour((Object)this, "folderTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, (Behaviour)folderBehaviour);
        JavaBehaviour folderDBehaviour = new JavaBehaviour((Object)this, "folderDTest");
        this.policyComponent.bindPropertyBehaviour(policyName, FOLDER_TYPE, FOLDER_PROP_D, (Behaviour)folderDBehaviour);
        JavaBehaviour aspectBehaviour = new JavaBehaviour((Object)this, "aspectTest");
        this.policyComponent.bindPropertyBehaviour(policyName, TEST_ASPECT, (Behaviour)aspectBehaviour);
        TestPropertyPolicy filePolicy = (TestPropertyPolicy)delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        TestPropertyPolicy folderPolicy = (TestPropertyPolicy)delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult = folderPolicy.test("folder");
        PolicyComponentTest.assertEquals((String)"FolderD: folder", (String)folderResult);
        JavaBehaviour newBaseBehaviour = new JavaBehaviour((Object)this, "newBaseTest");
        this.policyComponent.bindPropertyBehaviour(policyName, BASE_TYPE, (Behaviour)newBaseBehaviour);
        TestPropertyPolicy filePolicy2 = (TestPropertyPolicy)delegate.get(FILE_TYPE, BASE_PROP_A);
        String fileResult2 = filePolicy2.test("file");
        PolicyComponentTest.assertEquals((String)"NewBase: file", (String)fileResult2);
        TestPropertyPolicy folderPolicy2 = (TestPropertyPolicy)delegate.get(FOLDER_TYPE, FOLDER_PROP_D);
        String folderResult2 = folderPolicy2.test("folder");
        PolicyComponentTest.assertEquals((String)"FolderD: folder", (String)folderResult2);
    }

    public void testAssociationDelegate() {
        AssociationPolicyDelegate delegate = this.policyComponent.registerAssociationPolicy(TestAssociationPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"test");
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "baseTest");
        this.policyComponent.bindAssociationBehaviour(policyName, BASE_TYPE, BASE_ASSOC_A, (Behaviour)baseBehaviour);
        Collection filePolicies = delegate.getList(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull((Object)filePolicies);
        PolicyComponentTest.assertEquals((int)1, (int)filePolicies.size());
        TestAssociationPolicy filePolicy = (TestAssociationPolicy)delegate.get(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull((Object)filePolicy);
        String fileResult = filePolicy.test("file");
        PolicyComponentTest.assertEquals((String)"Base: file", (String)fileResult);
        JavaBehaviour serviceBehaviour = new JavaBehaviour((Object)this, "serviceTest");
        this.policyComponent.bindAssociationBehaviour(policyName, (Object)this, (Behaviour)serviceBehaviour);
        Collection file2Policies = delegate.getList(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull((Object)file2Policies);
        PolicyComponentTest.assertEquals((int)2, (int)file2Policies.size());
        TestAssociationPolicy filePolicy2 = (TestAssociationPolicy)delegate.get(FILE_TYPE, BASE_ASSOC_A);
        PolicyComponentTest.assertNotNull((Object)filePolicy2);
    }

    public String validTest(String argument) {
        return "ValidTest: " + argument;
    }

    public String baseTest(String argument) {
        return "Base: " + argument;
    }

    public String newBaseTest(String argument) {
        return "NewBase: " + argument;
    }

    public String fileTest(String argument) {
        return "File: " + argument;
    }

    public String fileTest2(String argument) {
        return "File2: " + argument;
    }

    public String folderTest(String argument) {
        return "Folder: " + argument;
    }

    public String aspectTest(String argument) {
        return "Aspect: " + argument;
    }

    public String folderDTest(String argument) {
        return "FolderD: " + argument;
    }

    public String serviceTest(String argument) {
        return "Service: " + argument;
    }

    public static interface InvalidMetaDataPolicy
    extends ClassPolicy {
        public static final int NAMESPACE = 0;

        public String test(String var1);
    }

    public static interface MultiMethodPolicy
    extends ClassPolicy {
        public void a();

        public void b();
    }

    public static interface NoMethodPolicy
    extends ClassPolicy {
    }

    public static interface TestAssociationPolicy
    extends AssociationPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }

    public static interface TestClassPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }

    public static interface TestPropertyPolicy
    extends PropertyPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";

        public String test(String var1);
    }
}

