/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.subsystems;

import java.util.List;
import org.alfresco.jlan.ftp.FTPSrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.subsystems.SubsystemChainingFtpAuthenticator;
import org.alfresco.util.BaseSpringTest;
import org.junit.Test;
import org.mockito.Mock;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@ContextConfiguration(value={"classpath:test-ftp-auth-context.xml"})
public class SubsystemChainingFtpAuthenticatorTest
extends BaseSpringTest {
    private static String SOURCE_BEAN_NAME = "testFtpAuthenticator";
    private SubsystemChainingFtpAuthenticator chainingAuthenticator;
    @Mock
    private ClientInfo info;
    @Mock
    private FTPSrvSession session;

    @Test
    public void testNumberOfAuthenticatorsInChain() {
        this.setContextForSubsystem("testFtpAuthentication");
        List authenticators = this.chainingAuthenticator.getUsableFtpAuthenticators();
        SubsystemChainingFtpAuthenticatorTest.assertTrue((String)"The context configuration was created for 3 test FTP authenticators with 1 disabled.", (authenticators.size() == 2 ? 1 : 0) != 0);
        this.setContextForSubsystem("testFtpAuthenticationAllDisabled");
        authenticators = this.chainingAuthenticator.getUsableFtpAuthenticators();
        SubsystemChainingFtpAuthenticatorTest.assertTrue((String)"The context configuration was created for 2 test FTP authenticators - all disabled.", (boolean)authenticators.isEmpty());
    }

    @Test
    public void testAuthenticatorChain() {
        this.setContextForSubsystem("testFtpAuthentication");
        SubsystemChainingFtpAuthenticatorTest.assertTrue((String)"The user should be authenticated", (boolean)this.chainingAuthenticator.authenticateUser(this.info, this.session));
        this.setContextForSubsystem("testFtpAuthenticationAllFailing");
        SubsystemChainingFtpAuthenticatorTest.assertFalse((String)"The user should be authenticated", (boolean)this.chainingAuthenticator.authenticateUser(this.info, this.session));
    }

    private void setContextForSubsystem(String beanName) {
        this.chainingAuthenticator = new SubsystemChainingFtpAuthenticator();
        ChildApplicationContextManager applicationContextManager = (ChildApplicationContextManager)this.applicationContext.getBean(beanName);
        this.chainingAuthenticator.setApplicationContextManager(applicationContextManager);
        this.chainingAuthenticator.setSourceBeanName(SOURCE_BEAN_NAME);
    }
}

