/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import org.alfresco.repo.cache.AsynchronouslyRefreshedCache;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.cache.AbstractAsynchronouslyRefreshedCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractMTAsynchronouslyRefreshedCache<T>
extends AbstractAsynchronouslyRefreshedCache<T>
implements AsynchronouslyRefreshedCache<T>,
InitializingBean {
    private static Log logger = LogFactory.getLog(AbstractMTAsynchronouslyRefreshedCache.class);
    private TenantService tenantService;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public T get() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        return (T)this.get(tenantId);
    }

    public void forceInChangesForThisUncommittedTransaction() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        this.forceInChangesForThisUncommittedTransaction(tenantId);
    }

    @Override
    public void refresh() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        this.refresh(tenantId);
    }

    @Override
    public boolean isUpToDate() {
        String tenantId = this.tenantService.getCurrentUserDomain();
        return this.isUpToDate(tenantId);
    }

    protected abstract T buildCache(String var1);

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        super.afterPropertiesSet();
    }
}

