/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.qname;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.qname.NamespaceEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.qname.QNameEntity;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class AbstractQNameDAOImpl
implements QNameDAO {
    private static final String CACHE_REGION_NAMESPACE = "Namespace";
    private static final String CACHE_REGION_QNAME = "QName";
    private EntityLookupCache<Long, String, String> namespaceCache = new EntityLookupCache<Long, String, String>(new NamespaceCallbackDAO());
    private EntityLookupCache<Long, QName, QName> qnameCache = new EntityLookupCache<Long, QName, QName>(new QNameCallbackDAO());

    protected AbstractQNameDAOImpl() {
    }

    public void setNamespaceCache(SimpleCache<Long, String> namespaceCache) {
        this.namespaceCache = new EntityLookupCache<Long, String, String>(namespaceCache, CACHE_REGION_NAMESPACE, new NamespaceCallbackDAO());
    }

    public void setQnameCache(SimpleCache<Long, QName> qnameCache) {
        this.qnameCache = new EntityLookupCache<Long, QName, QName>(qnameCache, CACHE_REGION_QNAME, new QNameCallbackDAO());
    }

    @Override
    public Pair<Long, String> getNamespace(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, String> entityPair = this.namespaceCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No namespace exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, String> getNamespace(String namespaceUri) {
        if (namespaceUri == null) {
            throw new IllegalArgumentException("Namespace URI cannot be null");
        }
        Pair<Long, String> entityPair = this.namespaceCache.getByValue(namespaceUri);
        return entityPair;
    }

    @Override
    public Pair<Long, String> getOrCreateNamespace(String namespaceUri) {
        if (namespaceUri == null) {
            throw new IllegalArgumentException("Namespace URI cannot be null");
        }
        Pair<Long, String> entityPair = this.namespaceCache.getOrCreateByValue(namespaceUri);
        return entityPair;
    }

    @Override
    public void updateNamespace(String oldNamespaceUri, String newNamespaceUri) {
        ParameterCheck.mandatory((String)"newNamespaceUri", (Object)newNamespaceUri);
        Pair<Long, String> oldEntityPair = this.getNamespace(oldNamespaceUri);
        if (oldEntityPair == null) {
            throw new DataIntegrityViolationException("Cannot update namespace as it doesn't exist: " + oldNamespaceUri);
        }
        int updated = this.namespaceCache.updateValue((Long)oldEntityPair.getFirst(), newNamespaceUri);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Incorrect update count: \n   Namespace:    " + oldNamespaceUri + "\n   Rows Updated: " + updated);
        }
        this.qnameCache.clear();
    }

    protected abstract NamespaceEntity findNamespaceEntityById(Long var1);

    protected abstract NamespaceEntity findNamespaceEntityByUri(String var1);

    protected abstract NamespaceEntity createNamespaceEntity(String var1);

    protected abstract int updateNamespaceEntity(NamespaceEntity var1, String var2);

    @Override
    public Pair<Long, QName> getQName(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, QName> entityPair = this.qnameCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No qname exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, QName> getQName(QName qname) {
        if (qname == null) {
            throw new IllegalArgumentException("QName cannot be null");
        }
        Pair<Long, QName> entityPair = this.qnameCache.getByValue(qname);
        return entityPair;
    }

    @Override
    public Pair<Long, QName> getOrCreateQName(QName qname) {
        if (qname == null) {
            throw new IllegalArgumentException("QName cannot be null");
        }
        Pair<Long, QName> entityPair = this.qnameCache.getOrCreateByValue(qname);
        return entityPair;
    }

    @Override
    public Pair<Long, QName> updateQName(QName qnameOld, QName qnameNew) {
        if (qnameOld == null || qnameNew == null) {
            throw new IllegalArgumentException("QName cannot be null");
        }
        if (qnameOld.equals((Object)qnameNew)) {
            throw new IllegalArgumentException("Cannot update QNames: they are the same");
        }
        Pair<Long, QName> qnameOldPair = this.qnameCache.getByValue(qnameOld);
        if (qnameOldPair == null) {
            throw new IllegalArgumentException("Cannot rename QName.  QName " + String.valueOf(qnameOld) + " does not exist");
        }
        if (this.qnameCache.getByValue(qnameNew) != null) {
            throw new IllegalArgumentException("Cannot rename QName.  QName " + String.valueOf(qnameNew) + " already exists");
        }
        Long qnameId = (Long)qnameOldPair.getFirst();
        int updated = this.qnameCache.updateValue(qnameId, qnameNew);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Failed to update QName entity " + String.valueOf(qnameId));
        }
        return new Pair((Object)qnameId, (Object)qnameNew);
    }

    @Override
    public void deleteQName(QName qname) {
        if (qname == null) {
            throw new IllegalArgumentException("QName cannot be null");
        }
        Pair<Long, QName> qnamePair = this.qnameCache.getByValue(qname);
        if (qnamePair == null) {
            throw new IllegalArgumentException("Cannot delete QName.  QName " + String.valueOf(qname) + " does not exist");
        }
        Long qnameId = (Long)qnamePair.getFirst();
        int deleted = this.qnameCache.deleteByKey(qnameId);
        if (deleted != 1) {
            throw new ConcurrencyFailureException("Failed to delete QName entity " + String.valueOf(qnameId));
        }
    }

    protected abstract QNameEntity findQNameEntityById(Long var1);

    protected abstract QNameEntity findQNameEntityByNamespaceAndLocalName(Long var1, String var2);

    protected abstract QNameEntity createQNameEntity(Long var1, String var2);

    protected abstract int updateQNameEntity(QNameEntity var1, Long var2, String var3);

    protected abstract int deleteQNameEntity(QNameEntity var1);

    @Override
    public Set<QName> convertIdsToQNames(Set<Long> ids) {
        HashSet<QName> qnames = new HashSet<QName>(ids.size() * 2 + 1);
        for (Long id : ids) {
            QName qname = (QName)this.getQName(id).getSecond();
            qnames.add(qname);
        }
        return qnames;
    }

    @Override
    public Map<QName, ? extends Object> convertIdMapToQNameMap(Map<Long, ? extends Object> idMap) {
        HashMap<QName, Object> qnameMap = new HashMap<QName, Object>(idMap.size() + 3);
        for (Map.Entry<Long, ? extends Object> entry : idMap.entrySet()) {
            QName qname = (QName)this.getQName(entry.getKey()).getSecond();
            qnameMap.put(qname, entry.getValue());
        }
        return qnameMap;
    }

    @Override
    public Set<Long> convertQNamesToIds(Set<QName> qnames, boolean create) {
        HashSet<Long> qnameIds = new HashSet<Long>(qnames.size(), 1.0f);
        for (QName qname : qnames) {
            Long qnameEntityId = null;
            if (create) {
                qnameEntityId = (Long)this.getOrCreateQName(qname).getFirst();
            } else {
                Pair<Long, QName> qnamePair = this.getQName(qname);
                if (qnamePair == null) continue;
                qnameEntityId = (Long)qnamePair.getFirst();
            }
            if (qnameEntityId == null) continue;
            qnameIds.add(qnameEntityId);
        }
        return qnameIds;
    }

    private class NamespaceCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, String, String> {
        private NamespaceCallbackDAO() {
        }

        @Override
        public String getValueKey(String value) {
            return value;
        }

        @Override
        public Pair<Long, String> findByKey(Long id) {
            NamespaceEntity entity = AbstractQNameDAOImpl.this.findNamespaceEntityById(id);
            if (entity == null) {
                return null;
            }
            return new Pair((Object)id, (Object)entity.getUriSafe());
        }

        @Override
        public Pair<Long, String> findByValue(String uri) {
            NamespaceEntity entity = AbstractQNameDAOImpl.this.findNamespaceEntityByUri(uri);
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getId(), (Object)uri);
        }

        @Override
        public Pair<Long, String> createValue(String uri) {
            NamespaceEntity entity = AbstractQNameDAOImpl.this.createNamespaceEntity(uri);
            return new Pair((Object)entity.getId(), (Object)uri);
        }

        @Override
        public int updateValue(Long id, String uri) {
            NamespaceEntity entity = AbstractQNameDAOImpl.this.findNamespaceEntityById(id);
            if (entity == null) {
                return 0;
            }
            return AbstractQNameDAOImpl.this.updateNamespaceEntity(entity, uri);
        }
    }

    private class QNameCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, QName, QName> {
        private QNameCallbackDAO() {
        }

        @Override
        public QName getValueKey(QName value) {
            return value;
        }

        @Override
        public Pair<Long, QName> findByKey(Long id) {
            QNameEntity entity = AbstractQNameDAOImpl.this.findQNameEntityById(id);
            if (entity == null) {
                return null;
            }
            Long namespaceId = entity.getNamespaceId();
            String uri = (String)AbstractQNameDAOImpl.this.getNamespace(namespaceId).getSecond();
            String localName = entity.getLocalNameSafe();
            QName qname = QName.createQName((String)uri, (String)localName);
            return new Pair((Object)id, (Object)qname);
        }

        @Override
        public Pair<Long, QName> findByValue(QName qname) {
            String uri = qname.getNamespaceURI();
            String localName = qname.getLocalName();
            Pair<Long, String> namespaceEntity = AbstractQNameDAOImpl.this.getNamespace(uri);
            if (namespaceEntity == null) {
                return null;
            }
            Long nsId = (Long)namespaceEntity.getFirst();
            QNameEntity entity = AbstractQNameDAOImpl.this.findQNameEntityByNamespaceAndLocalName(nsId, localName);
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getId(), (Object)qname);
        }

        @Override
        public Pair<Long, QName> createValue(QName qname) {
            String uri = qname.getNamespaceURI();
            String localName = qname.getLocalName();
            Pair<Long, String> namespaceEntity = AbstractQNameDAOImpl.this.getOrCreateNamespace(uri);
            Long nsId = (Long)namespaceEntity.getFirst();
            QNameEntity entity = AbstractQNameDAOImpl.this.createQNameEntity(nsId, localName);
            return new Pair((Object)entity.getId(), (Object)qname);
        }

        @Override
        public int updateValue(Long id, QName qname) {
            String uri = qname.getNamespaceURI();
            String localName = qname.getLocalName();
            QNameEntity entity = AbstractQNameDAOImpl.this.findQNameEntityById(id);
            if (entity == null) {
                return 0;
            }
            Pair<Long, String> namespaceEntity = AbstractQNameDAOImpl.this.getOrCreateNamespace(uri);
            Long nsId = (Long)namespaceEntity.getFirst();
            return AbstractQNameDAOImpl.this.updateQNameEntity(entity, nsId, localName);
        }

        @Override
        public int deleteByKey(Long id) {
            QNameEntity entity = AbstractQNameDAOImpl.this.findQNameEntityById(id);
            if (entity == null) {
                return 0;
            }
            return AbstractQNameDAOImpl.this.deleteQNameEntity(entity);
        }
    }
}

