/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.notification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.notification.EMailNotificationProvider;
import org.alfresco.service.cmr.notification.NotificationContext;
import org.alfresco.service.cmr.notification.NotificationProvider;
import org.alfresco.service.cmr.notification.NotificationService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class NotificationServiceImpl
implements NotificationService {
    private static final String MSG_NP_DOES_NOT_EXIST = "np-does-not-exist";
    private static Log logger = LogFactory.getLog(EMailNotificationProvider.class);
    private Map<String, NotificationProvider> providers = new HashMap<String, NotificationProvider>(3);

    @Override
    public void register(NotificationProvider notificationProvider) {
        ParameterCheck.mandatory((String)"notificationProvider", (Object)notificationProvider);
        this.providers.put(notificationProvider.getName(), notificationProvider);
    }

    @Override
    public boolean exists(String notificationProvider) {
        ParameterCheck.mandatory((String)"notificationProvider", (Object)notificationProvider);
        return this.providers.containsKey(notificationProvider);
    }

    @Override
    public List<String> getNotificationProviders() {
        return new ArrayList<String>(this.providers.keySet());
    }

    @Override
    public void sendNotification(String notificationProvider, NotificationContext notificationContext) {
        ParameterCheck.mandatory((String)"notificationProvider", (Object)notificationProvider);
        ParameterCheck.mandatory((String)"notificationContext", (Object)notificationContext);
        if (!this.exists(notificationProvider)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_NP_DOES_NOT_EXIST, (Object[])new Object[]{notificationProvider}));
        }
        NotificationProvider provider = this.providers.get(notificationProvider);
        provider.sendNotification(notificationContext);
    }
}

