/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.QueryParserException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class AbstractSolrAdminHTTPClient {
    protected JSONObject getOperation(HttpClient httpClient, String url) throws UnsupportedEncodingException {
        GetMethod get = new GetMethod(url);
        try {
            JSONObject json;
            Header locationHeader;
            httpClient.executeMethod((HttpMethod)get);
            if ((get.getStatusCode() == 301 || get.getStatusCode() == 302) && (locationHeader = get.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                get.setURI(new URI(redirectLocation, true));
                httpClient.executeMethod((HttpMethod)get);
            }
            if (get.getStatusCode() != 200) {
                throw new QueryParserException("Request failed " + get.getStatusCode() + " " + url.toString());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), get.getResponseCharSet()));
            JSONObject jSONObject = json = new JSONObject(new JSONTokener((Reader)reader));
            return jSONObject;
        }
        catch (IOException | JSONException e) {
            throw new AlfrescoRuntimeException(e.getMessage(), e);
        }
        finally {
            get.releaseConnection();
        }
    }
}

