/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.store.AspectVirtualizationMethod;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class CustomVirtualizationMethod
extends AspectVirtualizationMethod {
    private QName associationQName;
    private String associationName;

    @Override
    public void init() {
        super.init();
        if (this.associationName != null) {
            this.associationQName = QName.createQName((String)this.associationName, (NamespacePrefixResolver)this.namespacePrefixResolver);
        }
    }

    public void setAssociationName(String associationName) {
        this.associationName = associationName;
    }

    @Override
    public Reference virtualize(ActualEnvironment env, NodeRef nodeRef) throws VirtualizationException {
        NodeRef templateNode = env.getTargetAssocs(nodeRef, this.associationQName);
        if (templateNode != null) {
            return this.newVirtualReference(env, nodeRef, templateNode);
        }
        throw new VirtualizationException("Invalid virtualization : missing template association.");
    }

    @Override
    public boolean canVirtualize(ActualEnvironment env, NodeRef nodeRef) throws ActualEnvironmentException {
        boolean canVirtualize = super.canVirtualize(env, nodeRef);
        if (canVirtualize) {
            NodeRef templateNode = env.getTargetAssocs(nodeRef, this.associationQName);
            canVirtualize = templateNode != null;
        }
        return canVirtualize;
    }
}

