/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.activities.ActivityServiceImpl;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.activities.ActivityPostService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.events.types.ActivityEvent;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.repo.Client;
import org.alfresco.sync.repo.events.EventPreparator;
import org.alfresco.sync.repo.events.EventPublisher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ActivityPostServiceImpl
implements ActivityPostService {
    private static final Log logger = LogFactory.getLog(ActivityServiceImpl.class);
    private ActivityPostDAO postDAO;
    private TenantService tenantService;
    private EventPublisher eventPublisher;
    private int estGridSize = 1;
    private boolean userNamesAreCaseSensitive = false;
    private List<String> ignoredActivityTypes = new ArrayList<String>();

    public void setIgnoredActivityTypes(String ignoredActivityTypes) {
        if (ignoredActivityTypes != null && ignoredActivityTypes.length() > 0) {
            this.ignoredActivityTypes = Arrays.asList(ignoredActivityTypes.split(","));
        }
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setEstimatedGridSize(int estGridSize) {
        this.estGridSize = estGridSize;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData) {
        this.postActivity(activityType, siteId, appTool, activityData, ActivityPostEntity.STATUS.PENDING, this.getCurrentUser(), null, null);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData, Client client) {
        this.postActivity(activityType, siteId, appTool, activityData, ActivityPostEntity.STATUS.PENDING, this.getCurrentUser(), client, null);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String jsonActivityData, Client client, FileInfo contentNodeInfo) {
        this.postActivity(activityType, siteId, appTool, jsonActivityData, ActivityPostEntity.STATUS.PENDING, this.getCurrentUser(), client, contentNodeInfo);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData, String userId) {
        this.postActivity(activityType, siteId, appTool, activityData, ActivityPostEntity.STATUS.PENDING, userId, null, null);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"nodeRefL\":\"").append(nodeRef.toString()).append("\"").append("}");
        this.postActivity(activityType, siteId, appTool, sb.toString(), ActivityPostEntity.STATUS.PENDING, this.getCurrentUser(), null, null);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"nodeRefL\":\"").append(nodeRef.toString()).append("\"").append(",").append("\"name\":\"").append(name).append("\"").append("}");
        this.postActivity(activityType, siteId, appTool, sb.toString(), ActivityPostEntity.STATUS.PENDING, this.getCurrentUser(), null, null);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name, QName typeQName, NodeRef parentNodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"typeQName", (Object)typeQName);
        ParameterCheck.mandatory((String)"parentNodeRef", (Object)parentNodeRef);
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"nodeRefL\":\"").append(nodeRef.toString()).append("\"").append(",").append("\"name\":\"").append(name).append("\"").append(",").append("\"typeQName\":\"").append(typeQName.toPrefixString()).append("\"").append(",").append("\"parentNodeRef\":\"").append(parentNodeRef.toString()).append("\"").append("}");
        this.postActivity(activityType, siteId, appTool, sb.toString(), ActivityPostEntity.STATUS.PENDING, this.getCurrentUser(), null, null);
    }

    private void postActivity(final String activityType, String siteId, String appTool, String activityData, ActivityPostEntity.STATUS status, String userId, final Client client, final FileInfo contentNodeInfo) {
        NodeRef nodeRef = null;
        try {
            if (siteId == null) {
                siteId = "";
            } else if (siteId.length() > 255) {
                throw new IllegalArgumentException("Invalid siteId - exceeds 255 chars: " + siteId);
            }
            if (appTool == null) {
                appTool = "";
            } else if (appTool.length() > 36) {
                throw new IllegalArgumentException("Invalid app tool - exceeds 36 chars: " + appTool);
            }
            ParameterCheck.mandatoryString((String)"activityType", (String)activityType);
            if (activityType.length() > 255) {
                throw new IllegalArgumentException("Invalid activity type - exceeds 255 chars: " + activityType);
            }
            if (this.ignoredActivityTypes != null && this.ignoredActivityTypes.contains(activityType)) {
                logger.debug((Object)("Ignoring activity type for posting: " + activityType));
                return;
            }
            if (activityData == null) {
                activityData = "";
            }
            try {
                if (activityData.length() > 0) {
                    String title;
                    JSONObject jo = new JSONObject(new JSONTokener(activityData));
                    if (AuthenticationUtil.isMtEnabled()) {
                        jo.put("tenantDomain", (Object)this.tenantService.getCurrentUserDomain());
                        activityData = jo.toString();
                    }
                    nodeRef = this.checkNodeRef(jo);
                    if (jo.has("title") && (title = jo.getString("title")).length() > 255) {
                        jo.put("title", (Object)title.substring(0, 255));
                        activityData = jo.toString();
                    }
                }
            }
            catch (JSONException jSONException) {}
            if (activityData.length() > 1024) {
                throw new IllegalArgumentException("Invalid activity data - exceeds 1024 chars: " + activityData);
            }
            ParameterCheck.mandatoryString((String)"userId", (String)userId);
            if (userId.length() > 255) {
                throw new IllegalArgumentException("Invalid user - exceeds 255 chars: " + userId);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            throw new IllegalArgumentException("Failed to post activity: " + String.valueOf(e), e);
        }
        try {
            Date postDate = new Date();
            final ActivityPostEntity activityPost = new ActivityPostEntity();
            String network = this.tenantService.getName(siteId);
            final String site = siteId;
            final NodeRef finalNodeRef = nodeRef;
            if (!this.userNamesAreCaseSensitive) {
                userId = userId.toLowerCase();
            }
            activityPost.setUserId(userId);
            activityPost.setSiteNetwork(network);
            activityPost.setAppTool(appTool);
            activityPost.setActivityData(activityData);
            activityPost.setActivityType(activityType);
            activityPost.setPostDate(postDate);
            activityPost.setStatus(status.toString());
            activityPost.setLastModified(postDate);
            this.eventPublisher.publishEvent(new EventPreparator(){

                public Event prepareEvent(String user, String networkId, String transactionId) {
                    String filename = null;
                    String nodeType = null;
                    String mime = null;
                    String encoding = null;
                    long size = 0L;
                    String nodeId = finalNodeRef != null ? finalNodeRef.getId() : null;
                    FileInfo fileInfo = contentNodeInfo;
                    if (fileInfo != null) {
                        ContentData contentData;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Enhancing the Activity Event with fileInfo provided for node " + nodeId));
                        }
                        if (nodeId == null) {
                            nodeId = fileInfo.getNodeRef().getId();
                        }
                        filename = fileInfo.getName();
                        nodeType = fileInfo.getType().toString();
                        if (!fileInfo.isFolder() && (contentData = fileInfo.getContentData()) != null) {
                            mime = contentData.getMimetype();
                            size = contentData.getSize();
                            encoding = contentData.getEncoding();
                        }
                    }
                    return new ActivityEvent(activityType, transactionId, networkId, user, nodeId, site, nodeType, client, activityPost.getActivityData(), filename, mime, size, encoding);
                }
            });
            int nodeCount = this.estGridSize;
            int userHashCode = userId.hashCode();
            int nodeHash = userHashCode % nodeCount + 1;
            activityPost.setJobTaskNode(nodeHash);
            try {
                long postId = this.postDAO.insertPost(activityPost);
                if (logger.isDebugEnabled()) {
                    activityPost.setId(postId);
                    logger.debug((Object)("Posted: " + String.valueOf(activityPost)));
                }
            }
            catch (SQLException e) {
                throw new AlfrescoRuntimeException("Failed to post activity: " + String.valueOf(e), (Throwable)e);
            }
            catch (Throwable t) {
                throw new AlfrescoRuntimeException("Failed to post activity: " + String.valueOf(t), t);
            }
        }
        catch (AlfrescoRuntimeException e) {
            logger.error((Object)e);
        }
    }

    private String getCurrentUser() {
        String userId = AuthenticationUtil.getRunAsUser();
        if (userId != null && !userId.equals("System") && !this.userNamesAreCaseSensitive) {
            userId = userId.toLowerCase();
        }
        return userId;
    }

    private NodeRef checkNodeRef(JSONObject jo) throws JSONException {
        String nodeRefStr = null;
        try {
            if (jo.has("nodeRef")) {
                nodeRefStr = jo.getString("nodeRef");
                return new NodeRef(nodeRefStr);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid node ref: " + nodeRefStr);
        }
        return null;
    }
}

