/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.registry.RegistryKey;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.repo.module.ModuleComponent;
import org.alfresco.repo.module.ModuleServiceImpl;
import org.alfresco.repo.module.ModuleVersionNumber;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VersionNumber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ModuleComponentHelper {
    public static final String URI_MODULES_1_0 = "http://www.alfresco.org/system/modules/1.0";
    private static final String REGISTRY_PATH_MODULES = "modules";
    private static final String REGISTRY_PROPERTY_INSTALLED_VERSION = "installedVersion";
    private static final String REGISTRY_PROPERTY_CURRENT_VERSION = "currentVersion";
    private static final String REGISTRY_PATH_COMPONENTS = "components";
    private static final String REGISTRY_PROPERTY_EXECUTION_DATE = "executionDate";
    private static final String MSG_FOUND_MODULES = "module.msg.found_modules";
    private static final String MSG_STARTING = "module.msg.starting";
    private static final String MSG_INSTALLING = "module.msg.installing";
    private static final String MSG_UPGRADING = "module.msg.upgrading";
    private static final String MSG_DEPENDENCIES = "module.msg.dependencies";
    private static final String MSG_MISSING = "module.msg.missing";
    private static final String WARN_NO_INSTALL_VERSION = "module.warn.no_install_version";
    private static final String ERR_MISSING_DEPENDENCY = "module.err.missing_dependency";
    private static final String ERR_UNSUPPORTED_REPO_VERSION = "module.err.unsupported_repo_version";
    private static final String ERR_NO_DOWNGRADE = "module.err.downgrading_not_supported";
    private static final String ERR_COMPONENT_ALREADY_REGISTERED = "module.err.component_already_registered";
    private static final String ERR_COMPONENT_IN_MISSING_MODULE = "module.err.component_in_missing_module";
    private static final String ERR_ORPHANED_COMPONENTS = "module.err.orphaned_components";
    private static Log logger = LogFactory.getLog(ModuleComponentHelper.class);
    private static Log loggerService = LogFactory.getLog(ModuleServiceImpl.class);
    private ServiceRegistry serviceRegistry;
    private DescriptorService descriptorService;
    private RegistryService registryService;
    private ModuleService moduleService;
    private TenantAdminService tenantAdminService;
    private boolean applyToTenants;
    private Map<String, Map<String, ModuleComponent>> componentsByNameByModule = new HashMap<String, Map<String, ModuleComponent>>(7);

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setApplyToTenants(boolean applyToTenants) {
        throw new UnsupportedOperationException("Applying modules to individual tenants is unsupported. See ALF-19207: MT module startup does not work");
    }

    public synchronized void registerComponent(ModuleComponent component) {
        String moduleId = component.getModuleId();
        String name = component.getName();
        Map<String, ModuleComponent> componentsByName = this.componentsByNameByModule.get(moduleId);
        if (componentsByName == null) {
            componentsByName = new HashMap<String, ModuleComponent>(11);
            this.componentsByNameByModule.put(moduleId, componentsByName);
        }
        if (componentsByName.containsKey(name)) {
            throw AlfrescoRuntimeException.create((String)ERR_COMPONENT_ALREADY_REGISTERED, (Object[])new Object[]{name, moduleId});
        }
        componentsByName.put(name, component);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered component: " + String.valueOf(component)));
        }
    }

    private synchronized Map<String, ModuleComponent> getComponents(String moduleId) {
        Map<String, ModuleComponent> componentsByName = this.componentsByNameByModule.get(moduleId);
        if (componentsByName != null) {
            return componentsByName;
        }
        return Collections.emptyMap();
    }

    public synchronized void startModules() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"registryService", (Object)this.registryService);
        PropertyCheck.mandatory((Object)this, (String)"moduleService", (Object)this.moduleService);
        PropertyCheck.mandatory((Object)this, (String)"tenantAdminService", (Object)this.tenantAdminService);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String tenantDomainCtx;
                TransactionService transactionService;
                block10: {
                    transactionService = ModuleComponentHelper.this.serviceRegistry.getTransactionService();
                    tenantDomainCtx = ModuleComponentHelper.this.tenantAdminService.getCurrentUserDomain();
                    if (!ModuleComponentHelper.this.tenantAdminService.isEnabled() || tenantDomainCtx.equals("") || ModuleComponentHelper.this.applyToTenants) break block10;
                    return null;
                }
                try {
                    List<ModuleDetails> modules = ModuleComponentHelper.this.moduleService.getAllModules();
                    loggerService.info((Object)I18NUtil.getMessage((String)ModuleComponentHelper.MSG_FOUND_MODULES, (Object[])new Object[]{modules.size()}));
                    final HashMap mapExecutedComponents = new HashMap(1);
                    final HashMap mapStartedModules = new HashMap(1);
                    mapExecutedComponents.put(tenantDomainCtx, new HashSet(10));
                    mapStartedModules.put(tenantDomainCtx, new HashSet(2));
                    List<Tenant> tenantsNonFinal = null;
                    if (ModuleComponentHelper.this.tenantAdminService.isEnabled() && tenantDomainCtx.equals("") && ModuleComponentHelper.this.applyToTenants) {
                        tenantsNonFinal = ModuleComponentHelper.this.tenantAdminService.getTenants(false);
                        for (Tenant tenant : tenantsNonFinal) {
                            mapExecutedComponents.put(tenant.getTenantDomain(), new HashSet(10));
                            mapStartedModules.put(tenant.getTenantDomain(), new HashSet(2));
                        }
                    }
                    final List<Tenant> tenants = tenantsNonFinal;
                    for (final ModuleDetails module : modules) {
                        RetryingTransactionHelper.RetryingTransactionCallback<Object> startModuleWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Exception {
                                ModuleComponentHelper.this.startModule(module, (Set)mapStartedModules.get(tenantDomainCtx), (Set)mapExecutedComponents.get(tenantDomainCtx));
                                if (tenants != null) {
                                    for (Tenant tenant : tenants) {
                                        final String tenantDomain = tenant.getTenantDomain();
                                        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                                            public Object doWork() throws Exception {
                                                ModuleComponentHelper.this.startModule(module, (Set)mapStartedModules.get(tenantDomain), (Set)mapExecutedComponents.get(tenantDomain));
                                                return null;
                                            }
                                        }, (String)tenantDomain);
                                    }
                                }
                                return null;
                            }
                        };
                        transactionService.getRetryingTransactionHelper().doInTransaction(startModuleWork, transactionService.isReadOnly());
                    }
                    ModuleComponentHelper.this.checkForMissingModules();
                    if (tenants != null) {
                        for (Tenant tenant : tenants) {
                            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                                public Object doWork() throws Exception {
                                    ModuleComponentHelper.this.checkForMissingModules();
                                    return null;
                                }
                            }, (String)tenant.getTenantDomain());
                        }
                    }
                    ModuleComponentHelper.this.checkForOrphanComponents((Set)mapExecutedComponents.get(tenantDomainCtx));
                    if (tenants != null) {
                        for (Tenant tenant : tenants) {
                            final String tenantDomain = tenant.getTenantDomain();
                            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                                public Object doWork() throws Exception {
                                    ModuleComponentHelper.this.checkForOrphanComponents((Set)mapExecutedComponents.get(tenantDomain));
                                    return null;
                                }
                            }, (String)tenantDomain);
                        }
                    }
                }
                catch (Throwable e) {
                    throw new AlfrescoRuntimeException("Failed to start modules", e);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public synchronized void shutdownModules() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"registryService", (Object)this.registryService);
        PropertyCheck.mandatory((Object)this, (String)"moduleService", (Object)this.moduleService);
        PropertyCheck.mandatory((Object)this, (String)"tenantAdminService", (Object)this.tenantAdminService);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                List<ModuleDetails> modules = ModuleComponentHelper.this.moduleService.getAllModules();
                loggerService.info((Object)I18NUtil.getMessage((String)ModuleComponentHelper.MSG_FOUND_MODULES, (Object[])new Object[]{modules.size()}));
                for (ModuleDetails module : modules) {
                    Map<String, ModuleComponent> components = ModuleComponentHelper.this.getComponents(module.getId());
                    for (ModuleComponent component : components.values()) {
                        component.shutdown();
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void checkForOrphanComponents(Set<ModuleComponent> executedComponents) {
        HashSet<ModuleComponent> missedComponents = new HashSet<ModuleComponent>(executedComponents);
        for (Map.Entry<String, Map<String, ModuleComponent>> entry : this.componentsByNameByModule.entrySet()) {
            String moduleId = entry.getKey();
            Map<String, ModuleComponent> componentsByName = entry.getValue();
            for (Map.Entry<String, ModuleComponent> entryInner : componentsByName.entrySet()) {
                String componentName = entryInner.getKey();
                ModuleComponent component = entryInner.getValue();
                if (executedComponents.contains(component)) {
                    missedComponents.remove(component);
                    continue;
                }
                String msg = I18NUtil.getMessage((String)ERR_COMPONENT_IN_MISSING_MODULE, (Object[])new Object[]{componentName, moduleId});
                logger.error((Object)msg);
            }
        }
        if (missedComponents.size() > 0) {
            throw AlfrescoRuntimeException.create((String)ERR_ORPHANED_COMPONENTS, (Object[])new Object[]{missedComponents.size()});
        }
    }

    Collection<String> getRegistryModuleIDs() {
        RegistryKey moduleKeyAllIds = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, null);
        return this.registryService.getChildElements(moduleKeyAllIds);
    }

    ModuleVersionNumber getVersion(String moduleId) {
        RegistryKey moduleKeyCurrentVersion = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, moduleId, REGISTRY_PROPERTY_CURRENT_VERSION);
        Serializable versionCurrent = this.registryService.getProperty(moduleKeyCurrentVersion);
        return this.getModuleVersionNumber(versionCurrent);
    }

    private void checkForMissingModules() {
        Collection<String> moduleIds = this.getRegistryModuleIDs();
        for (String moduleId : moduleIds) {
            ModuleDetails moduleDetails = this.moduleService.getModule(moduleId);
            if (moduleDetails != null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Installed module found in distribution: " + moduleId));
                continue;
            }
            ModuleVersionNumber versionCurrent = this.getVersion(moduleId);
            loggerService.warn((Object)I18NUtil.getMessage((String)MSG_MISSING, (Object[])new Object[]{moduleId, versionCurrent}));
        }
    }

    private void renameModule(ModuleDetails module) {
        String moduleId = module.getId();
        List<String> moduleAliases = module.getAliases();
        RegistryKey moduleKeyAllIds = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, null);
        Collection<String> registeredModuleIds = this.registryService.getChildElements(moduleKeyAllIds);
        if (registeredModuleIds.contains(moduleId)) {
            return;
        }
        for (String moduleAlias : moduleAliases) {
            if (!registeredModuleIds.contains(moduleAlias)) continue;
            RegistryKey moduleKeyNew = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, moduleId, null);
            RegistryKey moduleKeyOld = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, moduleAlias, null);
            this.registryService.copy(moduleKeyOld, moduleKeyNew);
            this.registryService.delete(moduleKeyOld);
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("Moved old module alias to new module ID: \n   Alias:  " + moduleAlias + "\n   Module: " + moduleId));
            break;
        }
    }

    private void startModule(ModuleDetails module, Set<String> startedModules, Set<ModuleComponent> executedComponents) {
        String moduleId = module.getId();
        ModuleVersionNumber moduleNewVersion = module.getModuleVersionNumber();
        if (startedModules.contains(moduleId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Module '" + String.valueOf(module) + "' already started"));
            }
            return;
        }
        List<ModuleDependency> moduleDependencies = module.getDependencies();
        for (ModuleDependency moduleDependency : moduleDependencies) {
            String moduleDependencyId;
            ModuleDetails moduleDependencyDetails;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Module '" + String.valueOf(module) + "' depends on: " + String.valueOf(moduleDependency)));
            }
            if ((moduleDependencyDetails = this.moduleService.getModule(moduleDependencyId = moduleDependency.getDependencyId())) == null) {
                StringBuilder sb = new StringBuilder(128);
                for (ModuleDependency dependency : moduleDependencies) {
                    sb.append("\n").append(dependency);
                }
                String msg = I18NUtil.getMessage((String)MSG_DEPENDENCIES, (Object[])new Object[]{moduleId, moduleNewVersion, sb.toString()});
                logger.info((Object)msg);
                throw AlfrescoRuntimeException.create((String)ERR_MISSING_DEPENDENCY, (Object[])new Object[]{moduleId, moduleNewVersion, moduleDependency});
            }
            this.startModule(moduleDependencyDetails, startedModules, executedComponents);
        }
        this.renameModule(module);
        VersionNumber repoVersionNumber = this.descriptorService.getServerDescriptor().getVersionNumber();
        VersionNumber minRepoVersionNumber = module.getRepoVersionMin();
        VersionNumber maxRepoVersionNumber = module.getRepoVersionMax();
        if (minRepoVersionNumber != null && repoVersionNumber.compareTo(minRepoVersionNumber) < 0 || maxRepoVersionNumber != null && repoVersionNumber.compareTo(maxRepoVersionNumber) > 0) {
            throw AlfrescoRuntimeException.create((String)ERR_UNSUPPORTED_REPO_VERSION, (Object[])new Object[]{moduleId, moduleNewVersion, repoVersionNumber, minRepoVersionNumber, maxRepoVersionNumber});
        }
        RegistryKey moduleKeyInstalledVersion = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, moduleId, REGISTRY_PROPERTY_INSTALLED_VERSION);
        RegistryKey moduleKeyCurrentVersion = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, moduleId, REGISTRY_PROPERTY_CURRENT_VERSION);
        Serializable moduleInstallVersion = this.registryService.getProperty(moduleKeyInstalledVersion);
        Serializable moduleCurrentVersion = this.registryService.getProperty(moduleKeyCurrentVersion);
        String msg = null;
        if (moduleCurrentVersion == null) {
            msg = I18NUtil.getMessage((String)MSG_INSTALLING, (Object[])new Object[]{moduleId, moduleNewVersion});
            this.registryService.addProperty(moduleKeyInstalledVersion, moduleNewVersion);
            moduleInstallVersion = moduleNewVersion;
            moduleCurrentVersion = moduleNewVersion;
        } else {
            ModuleVersionNumber currentModuleVersion = this.getModuleVersionNumber(moduleCurrentVersion);
            if (moduleInstallVersion == null) {
                logger.warn((Object)I18NUtil.getMessage((String)WARN_NO_INSTALL_VERSION, (Object[])new Object[]{moduleId, moduleCurrentVersion}));
                this.registryService.addProperty(moduleKeyInstalledVersion, currentModuleVersion);
                moduleInstallVersion = moduleCurrentVersion;
            }
            if (currentModuleVersion.compareTo(moduleNewVersion) == 0) {
                msg = I18NUtil.getMessage((String)MSG_STARTING, (Object[])new Object[]{moduleId, moduleNewVersion});
            } else {
                if (currentModuleVersion.compareTo(moduleNewVersion) > 0) {
                    throw AlfrescoRuntimeException.create((String)ERR_NO_DOWNGRADE, (Object[])new Object[]{moduleId, moduleCurrentVersion, moduleNewVersion});
                }
                msg = I18NUtil.getMessage((String)MSG_UPGRADING, (Object[])new Object[]{moduleId, moduleNewVersion, moduleCurrentVersion});
            }
        }
        loggerService.info((Object)msg);
        this.registryService.addProperty(moduleKeyCurrentVersion, moduleNewVersion);
        Map<String, ModuleComponent> componentsByName = this.getComponents(moduleId);
        for (ModuleComponent component : componentsByName.values()) {
            this.executeComponent(moduleId, moduleNewVersion, component, executedComponents);
        }
        startedModules.add(moduleId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started module '" + String.valueOf(module) + "' including " + executedComponents.size() + "components."));
        }
    }

    protected ModuleVersionNumber getModuleVersionNumber(Serializable moduleVersion) {
        if (moduleVersion instanceof ModuleVersionNumber) {
            return (ModuleVersionNumber)moduleVersion;
        }
        if (moduleVersion instanceof VersionNumber) {
            return new ModuleVersionNumber((VersionNumber)moduleVersion);
        }
        if (moduleVersion instanceof String) {
            return new ModuleVersionNumber((String)((Object)moduleVersion));
        }
        throw new ModuleManagementToolException("Invalid moduleVersion");
    }

    private void executeComponent(String moduleId, ModuleVersionNumber currentVersion, ModuleComponent component, Set<ModuleComponent> executedComponents) {
        if (executedComponents.contains(component)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping component already executed in this run: \n   Component:      " + String.valueOf(component)));
            }
            return;
        }
        executedComponents.add(component);
        ModuleVersionNumber minVersion = component.getAppliesFromVersionNumber();
        ModuleVersionNumber maxVersion = component.getAppliesToVersionNumber();
        if (currentVersion.compareTo(minVersion) < 0 || currentVersion.compareTo(maxVersion) > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping component that doesn't apply to the module installation version: \n   Component:       " + String.valueOf(component) + "\n   Module:          " + moduleId + "\n   Current Version: " + String.valueOf(currentVersion) + "\n   Applies From :   " + String.valueOf(minVersion) + "\n   Applies To   :   " + String.valueOf(maxVersion)));
            }
            return;
        }
        String name = component.getName();
        RegistryKey executionDateKey = new RegistryKey(URI_MODULES_1_0, REGISTRY_PATH_MODULES, moduleId, REGISTRY_PATH_COMPONENTS, name, REGISTRY_PROPERTY_EXECUTION_DATE);
        Date executionDate = (Date)this.registryService.getProperty(executionDateKey);
        if (executionDate != null && component.isExecuteOnceOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping already-executed module component: \n   Component:      " + String.valueOf(component) + "\n   Execution Time: " + String.valueOf(executionDate)));
            }
            return;
        }
        List<ModuleComponent> dependencies = component.getDependsOn();
        for (ModuleComponent dependency : dependencies) {
            this.executeComponent(moduleId, currentVersion, dependency, executedComponents);
        }
        component.execute();
        this.registryService.addProperty(executionDateKey, new Date());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executed module component: \n   Component:      " + String.valueOf(component)));
        }
    }
}

