/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.alfresco.repo.virtual.ref.NodeIdHasher;

class NotUuidNodeIdRadixHasher
implements NodeIdHasher {
    private final int radix;

    public NotUuidNodeIdRadixHasher(int radix) {
        this.radix = radix;
    }

    @Override
    public String lookup(String hashId) {
        BigInteger hashIdBigInt = new BigInteger(hashId, this.radix);
        byte[] hashIdBytes = hashIdBigInt.toByteArray();
        return new String(hashIdBytes);
    }

    @Override
    public String hash(String id) {
        byte[] bytes = id.getBytes(StandardCharsets.UTF_8);
        BigInteger bigIntegerBytes = new BigInteger(bytes);
        return bigIntegerBytes.toString(this.radix);
    }
}

