/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.poi.util.IOUtils;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class MimetypeMapContentTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private MimetypeService mimetypeService;

    public void setUp() throws Exception {
        this.mimetypeService = (MimetypeService)ctx.getBean("mimetypeService");
    }

    public void testGuessPdfMimetype() throws Exception {
        MimetypeMapContentTest.assertEquals((String)"application/pdf", (String)this.mimetypeService.guessMimetype("something.doc", this.openQuickTestFile("quick.pdf")));
        MimetypeMapContentTest.assertEquals((String)"application/pdf", (String)this.mimetypeService.guessMimetype(null, this.openQuickTestFile("quick.pdf")));
    }

    public void testGuessAppleIconsMimetype() throws Exception {
        MimetypeMapContentTest.assertEquals((String)"image/icns", (String)this.mimetypeService.guessMimetype("something.icns", this.openQuickTestFile("quick.icns")));
    }

    public void testGuessMimetypeForFile() throws Exception {
        MimetypeMapContentTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.doc", this.openQuickTestFile("quick.doc")));
        MimetypeMapContentTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("SOMETHING.DOC", this.openQuickTestFile("quick.doc")));
        MimetypeMapContentTest.assertEquals((String)"application/msword", (String)this.mimetypeService.guessMimetype("something.pdf", this.openQuickTestFile("quick.doc")));
        MimetypeMapContentTest.assertEquals((String)"image/bmp", (String)this.mimetypeService.guessMimetype("image.bmp", this.openQuickTestFile("quick.bmp")));
        MimetypeMapContentTest.assertEquals((String)"application/dita+xml", (String)this.mimetypeService.guessMimetype("concept.dita", this.openQuickTestFile("quickConcept.dita")));
        File tmp = File.createTempFile("alfresco", ".tmp");
        ContentReader reader = this.openQuickTestFile("quick.doc");
        InputStream inp = reader.getContentInputStream();
        byte[] trunc = new byte[768];
        IOUtils.readFully((InputStream)inp, (byte[])trunc);
        inp.close();
        FileOutputStream out = new FileOutputStream(tmp);
        out.write(trunc);
        out.close();
        FileContentReader truncReader = new FileContentReader(tmp);
        MimetypeMapContentTest.assertEquals((String)"application/x-tika-msoffice", (String)this.mimetypeService.guessMimetype(null, (ContentReader)truncReader));
        MimetypeMapContentTest.assertEquals((String)"message/rfc822", (String)this.mimetypeService.guessMimetype("something.eml", this.openQuickTestFile("quickLotus.eml")));
    }

    private ContentReader openQuickTestFile(String filename) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("quick/" + filename);
        if (url == null) {
            MimetypeMapContentTest.fail((String)("Quick test file \"" + filename + "\" wasn't found"));
        }
        File file = new File(url.getFile());
        return new FileContentReader(file);
    }
}

