/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.testing.category.NonBuildTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Suite;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public class OmittedTestClassFinderUnitTest {
    @Test
    public void checkTestClassesReferencedInTestSuites() {
        Reflections reflections = new Reflections("org.alfresco", new Scanner[]{Scanners.MethodsAnnotated, Scanners.TypesAnnotated, Scanners.SubTypes});
        Set<String> testClasses = this.getTestClassesOnPath(reflections);
        Set<String> classesReferencedByTestSuites = this.getClassesReferencedByTestSuites(reflections);
        Sets.SetView unreferencedTests = Sets.difference(testClasses, classesReferencedByTestSuites);
        Set<Class> unreferencedTestClasses = unreferencedTests.stream().map(this::classFromCanonicalName).filter(clazz -> {
            String path = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            return !path.endsWith("/data-model/target/test-classes/") && !path.endsWith("/core/target/test-classes/") && !path.endsWith(".jar");
        }).collect(Collectors.toSet());
        System.out.println("Unreferenced test class count: " + unreferencedTestClasses.size());
        unreferencedTestClasses.forEach(System.out::println);
        TestCase.assertEquals((String)"Found test classes which are not referenced by any test suite.", Collections.emptySet(), unreferencedTestClasses);
    }

    private Set<String> getTestClassesOnPath(Reflections reflections) {
        Set classesWithTestAnnotations = Stream.of(Test.class, Before.class, After.class).map(annotation -> this.findClassesWithMethodAnnotation(reflections, (Class<? extends Annotation>)annotation)).flatMap(Collection::stream).collect(Collectors.toSet());
        Set classesExtendingTestCase = reflections.getSubTypesOf(TestCase.class).stream().map(testClass -> testClass.getCanonicalName()).collect(Collectors.toSet());
        return Sets.union(classesWithTestAnnotations, classesExtendingTestCase).stream().filter(className -> !className.endsWith("Suite")).filter(className -> !Modifier.isAbstract(this.classFromCanonicalName((String)className).getModifiers())).filter(className -> !this.markedAsNonBuildTest(this.classFromCanonicalName((String)className))).collect(Collectors.toSet());
    }

    private boolean markedAsNonBuildTest(Class<?> clazz) {
        Category category = clazz.getAnnotation(Category.class);
        if (category == null) {
            return false;
        }
        return Arrays.stream(category.value()).anyMatch(value -> NonBuildTests.class.isAssignableFrom((Class<?>)value));
    }

    private Set<String> getClassesReferencedByTestSuites(Reflections reflections) {
        HashSet<String> classesReferencedByTestSuites = new HashSet<String>();
        for (Class testSuite : reflections.getTypesAnnotatedWith(Suite.SuiteClasses.class)) {
            Suite.SuiteClasses testSuiteAnnotation = testSuite.getAnnotation(Suite.SuiteClasses.class);
            Arrays.stream(testSuiteAnnotation.value()).map(testClass -> testClass.getCanonicalName()).filter(className -> !className.endsWith("Suite")).forEach(classesReferencedByTestSuites::add);
        }
        return classesReferencedByTestSuites;
    }

    private Set<String> findClassesWithMethodAnnotation(Reflections reflections, Class<? extends Annotation> annotation) {
        return reflections.getMethodsAnnotatedWith(annotation).stream().map(Method::getDeclaringClass).flatMap(c -> Stream.concat(Stream.of(c), reflections.getSubTypesOf(c).stream())).map(Class::getCanonicalName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Class<?> classFromCanonicalName(String name) {
        try {
            return Class.forName(name, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AlfrescoRuntimeException("Couldn't find test class for name.", (Throwable)e);
        }
    }
}

