/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.messaging.camel.configuration;

import jakarta.jms.ConnectionFactory;
import java.security.SecureRandom;
import org.alfresco.encryption.AlfrescoKeyStore;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConnectionFactoryConfiguration {
    @Value(value="${messaging.broker.url}")
    private String brokerUrl = "notset";
    @Value(value="${messaging.broker.ssl}")
    private boolean useSSL = false;
    @Autowired(required=false)
    @Qualifier(value="ssl.keyStore")
    private AlfrescoKeyStore keyStore;
    @Autowired(required=false)
    @Qualifier(value="ssl.trustStore")
    private AlfrescoKeyStore trustStore;
    @Value(value="${messaging.broker.username}")
    private String username;
    @Value(value="${messaging.broker.password}")
    private String password;

    @Bean
    public ConnectionFactory activeMqConnectionFactory() {
        if (this.useSSL) {
            return this.createSecureConnectionFactory();
        }
        return this.createConnectionFactory();
    }

    protected ConnectionFactory createConnectionFactory() {
        return new ActiveMQConnectionFactory(this.username, this.password, this.brokerUrl);
    }

    protected ConnectionFactory createSecureConnectionFactory() {
        ActiveMQSslConnectionFactory factory = new ActiveMQSslConnectionFactory(this.brokerUrl);
        factory.setKeyAndTrustManagers(this.keyStore.createKeyManagers(), this.trustStore.createTrustManagers(), new SecureRandom());
        factory.setUserName(this.username);
        factory.setPassword(this.password);
        return factory;
    }
}

