/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.alfresco.repo.management.DynamicMBeanExportOperations;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.support.RegistrationPolicy;

public class DynamicMBeanExporter
extends MBeanExporter
implements DynamicMBeanExportOperations {
    private static ThreadLocal<MBeanServer> threadServer = new ThreadLocal();

    public DynamicMBeanExporter() {
        MBeanServer server = threadServer.get();
        if (server != null) {
            this.setServer(server);
        }
        this.setRegistrationPolicy(RegistrationPolicy.IGNORE_EXISTING);
        this.setAutodetectMode(0);
    }

    public void setServer(MBeanServer server) {
        threadServer.set(server);
        super.setServer(server);
    }

    @Override
    public void unregisterMBean(ObjectName objectName) {
        this.doUnregister(objectName);
    }

    @Override
    public ObjectName registerMBean(Object managedResource, ObjectName objectName) {
        Object mbean = this.isMBean(managedResource.getClass()) ? managedResource : this.createAndConfigureMBean(managedResource, managedResource.getClass().getName());
        ObjectName actualObjectName = objectName;
        try {
            this.doRegister(mbean, actualObjectName);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        return actualObjectName;
    }
}

