/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import java.net.BindException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.alfresco.repo.management.subsystems.InvalidPropertyValueException;
import org.alfresco.repo.management.subsystems.SubsystemEarlyPropertyChecker;
import org.alfresco.util.PortUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class PortEarlyPropertyChecker
implements SubsystemEarlyPropertyChecker {
    private static final String PORT_CANT_BE_EMPTY_MESSAGE = "system.portcheck.err.empty_port";
    private static final String UNABLE_TO_PARSE_PORT_MESSAGE = "system.portcheck.err.parse_port";
    private static final String PORT_OUT_OF_BOUNDS_MESSAGE = "system.portcheck.err.port_out_of_bounds";
    private static final String PORTS_OUT_OF_BOUNDS_MESSAGE = "system.portcheck.err.ports_out_of_bounds";
    private static final String PORT_IN_USE_MESSAGE = "system.portcheck.err.port_in_use";
    private static final String HOST_PORT_IN_USE_MESSAGE = "system.portcheck.err.host_port_in_use";
    private static final String PORTS_IN_USE_MESSAGE = "system.portcheck.err.ports_in_use";
    private static final String UNKNOWN_OR_WRONG_HOST_MESSAGE = "system.portcheck.err.unknown_or_wrong_host";
    private static final String NETWORKING_ERROR_MESSAGE = "system.portcheck.err.networking_error";
    private static final String PORTS_WITH_NETWORKING_ERRORS_MESSAGE = "system.portcheck.err.ports_with_networking_errors";
    private static final Log logger = LogFactory.getLog(PortEarlyPropertyChecker.class);
    private final String subsystemName;
    private final String requiredPairedPropertyName;
    private final boolean hasMultiplePorts;
    private final boolean shouldCheckForBlockedPort;

    public PortEarlyPropertyChecker(String subsystemName, boolean hasMultiplePorts, boolean shouldCheckForBlockedPort) {
        this(subsystemName, null, hasMultiplePorts, shouldCheckForBlockedPort);
    }

    public PortEarlyPropertyChecker(String subsystemName, String requiredPairedPropertyName, boolean hasMultiplePorts, boolean shouldCheckForBlockedPort) {
        this.subsystemName = subsystemName;
        this.requiredPairedPropertyName = requiredPairedPropertyName;
        this.hasMultiplePorts = hasMultiplePorts;
        this.shouldCheckForBlockedPort = shouldCheckForBlockedPort;
    }

    @Override
    public void checkPropertyValue(String propertyName, String propertyValue, String pairedPropertyValue) throws InvalidPropertyValueException {
        block23: {
            if (propertyValue == null || propertyValue.isEmpty()) {
                this.createLogAndThrowAnInvalidPropertyValueException(PORT_CANT_BE_EMPTY_MESSAGE, new String[]{this.subsystemName});
            }
            String host = pairedPropertyValue;
            try {
                if (!this.hasMultiplePorts) {
                    int portNumber = Integer.parseInt(propertyValue.trim());
                    if (portNumber < 1 || portNumber > 65535) {
                        this.createLogAndThrowAnInvalidPropertyValueException(PORT_OUT_OF_BOUNDS_MESSAGE, new String[]{this.subsystemName, "" + portNumber});
                        break block23;
                    }
                    if (!this.shouldCheckForBlockedPort) break block23;
                    try {
                        this.checkPort(portNumber, host);
                    }
                    catch (IOException ioe) {
                        if (ioe instanceof BindException) {
                            if (host == null || "0.0.0.0".equals(host)) {
                                this.createLogAndThrowAnInvalidPropertyValueException(PORT_IN_USE_MESSAGE, new String[]{this.subsystemName, "" + portNumber});
                            } else {
                                this.createLogAndThrowAnInvalidPropertyValueException(HOST_PORT_IN_USE_MESSAGE, new String[]{this.subsystemName, host, "" + portNumber});
                            }
                            break block23;
                        }
                        if (host != null && ioe instanceof UnknownHostException) {
                            this.createLogAndThrowAnInvalidPropertyValueException(UNKNOWN_OR_WRONG_HOST_MESSAGE, new String[]{this.subsystemName, host});
                            break block23;
                        }
                        this.createLogAndThrowAnInvalidPropertyValueException(NETWORKING_ERROR_MESSAGE, new String[]{this.subsystemName, ioe.getLocalizedMessage()});
                    }
                    break block23;
                }
                String[] ports = propertyValue.trim().split(",");
                String portsInUse = "";
                String portsOutOfBounds = "";
                String portsWithNetworkingErrors = "";
                String[] stringArray = ports;
                int n = ports.length;
                int n2 = 0;
                while (n2 < n) {
                    String portStr = stringArray[n2];
                    int portNumber = Integer.parseInt(portStr.trim());
                    if (portNumber < 1 || portNumber > 65535) {
                        portsOutOfBounds = this.appendToErrorString(portsOutOfBounds, ", ", "" + portNumber);
                    } else if (this.shouldCheckForBlockedPort) {
                        try {
                            this.checkPort(portNumber, host);
                        }
                        catch (IOException ioe) {
                            if (ioe instanceof BindException) {
                                portsInUse = this.appendToErrorString(portsInUse, ", ", "" + portNumber);
                            }
                            portsWithNetworkingErrors = this.appendToErrorString(portsWithNetworkingErrors, " ; ", portNumber + ": " + ioe.getLocalizedMessage());
                        }
                    }
                    ++n2;
                }
                Object completeErrorDisplayMessage = "";
                if (!portsOutOfBounds.equals("")) {
                    String portsOutOfBoundsDisplayMessage = this.resolveMessage(PORTS_OUT_OF_BOUNDS_MESSAGE, new String[]{this.subsystemName, portsOutOfBounds});
                    completeErrorDisplayMessage = (String)completeErrorDisplayMessage + portsOutOfBoundsDisplayMessage;
                }
                if (!portsInUse.equals("")) {
                    String portsInUseDisplayMessage = this.resolveMessage(PORTS_IN_USE_MESSAGE, new String[]{this.subsystemName, portsInUse});
                    completeErrorDisplayMessage = this.appendToErrorString((String)completeErrorDisplayMessage, " | ", portsInUseDisplayMessage);
                }
                if (!portsWithNetworkingErrors.equals("")) {
                    String portsWithNetworkingErrorsDisplayMessage = this.resolveMessage(PORTS_WITH_NETWORKING_ERRORS_MESSAGE, new String[]{this.subsystemName, portsWithNetworkingErrors});
                    completeErrorDisplayMessage = this.appendToErrorString((String)completeErrorDisplayMessage, " | ", portsWithNetworkingErrorsDisplayMessage);
                }
                if (!((String)completeErrorDisplayMessage).equals("")) {
                    if (logger.isErrorEnabled()) {
                        logger.error(completeErrorDisplayMessage);
                    }
                    throw new InvalidPropertyValueException((String)completeErrorDisplayMessage);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.createLogAndThrowAnInvalidPropertyValueException(UNABLE_TO_PARSE_PORT_MESSAGE, new String[]{this.subsystemName, propertyValue});
            }
        }
    }

    protected void checkPort(int portNumber, String host) throws IOException {
        PortUtil.checkPort(portNumber, host);
    }

    private String appendToErrorString(String stringToAppendTo, String separator, String valueToAppend) {
        if (!((String)stringToAppendTo).equals("")) {
            stringToAppendTo = (String)stringToAppendTo + separator;
        }
        stringToAppendTo = (String)stringToAppendTo + valueToAppend;
        return stringToAppendTo;
    }

    private void createLogAndThrowAnInvalidPropertyValueException(String message, String[] messageParams) {
        InvalidPropertyValueException invalidPropertyValueException = new InvalidPropertyValueException(message, messageParams);
        if (logger.isErrorEnabled()) {
            logger.error((Object)invalidPropertyValueException.getLocalizedMessage());
        }
        throw invalidPropertyValueException;
    }

    private String resolveMessage(String messageId, Object[] params) {
        Object message = I18NUtil.getMessage((String)messageId, (Object[])params);
        if (message == null) {
            message = messageId;
            if (params != null) {
                message = (String)message + " - " + Arrays.toString(params);
            }
        }
        return message;
    }

    @Override
    public String getPairedPropertyName() {
        return this.requiredPairedPropertyName;
    }
}

