/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.CompositePasswordEncoderTest;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.repo.security.authentication.UpgradePasswordHashWorker;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PasswordHashingTest {
    UpgradePasswordHashWorker passwordHashWorker;
    CompositePasswordEncoder cpe;

    @Before
    public void setUp() throws Exception {
        this.cpe = new CompositePasswordEncoder();
        this.cpe.setEncoders(CompositePasswordEncoderTest.encodersConfig);
        this.passwordHashWorker = new UpgradePasswordHashWorker();
        this.passwordHashWorker.setCompositePasswordEncoder(this.cpe);
    }

    @Test
    public void testRehashedPassword() throws Exception {
        this.cpe.setPreferredEncoding("md4");
        String salt = GUID.generate();
        String md4Hashed = this.cpe.encode("md4", "HASHED_MY_PASSWORD", null);
        String sha256Hashed = this.cpe.encode("sha256", "HASHED_MY_PASSWORD", (Object)salt);
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_PASSWORD, (Serializable)((Object)"nonsense"));
        Assert.assertFalse((String)"Should be empty", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertTrue((boolean)this.passwordHashWorker.processPasswordHash(properties));
        Assert.assertEquals((Object)CompositePasswordEncoder.MD4, properties.get(ContentModel.PROP_HASH_INDICATOR));
        Assert.assertTrue((String)"Should now contain the password", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_SHA256));
        Assert.assertEquals((Object)"nonsense", properties.get(ContentModel.PROP_PASSWORD_HASH));
        properties.clear();
        properties.put(ContentModel.PROP_PASSWORD, (Serializable)((Object)"PLAIN TEXT PASSWORD"));
        Assert.assertTrue((boolean)this.passwordHashWorker.processPasswordHash(properties));
        Assert.assertEquals((Object)CompositePasswordEncoder.MD4, properties.get(ContentModel.PROP_HASH_INDICATOR));
        Assert.assertTrue((String)"Should now contain the password", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_SHA256));
        Assert.assertEquals((Object)"PLAIN TEXT PASSWORD", properties.get(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertFalse((String)"We copied a plain text password to the new property but the legacy encoding is set to MD4 so the password would NEVER match.", (boolean)PasswordHashingTest.matches("PLAIN TEXT PASSWORD", properties, this.cpe));
        properties.clear();
        properties.put(ContentModel.PROP_PASSWORD, (Serializable)((Object)md4Hashed));
        this.cpe.setPreferredEncoding("bcrypt10");
        Assert.assertTrue((String)"We have the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD));
        Assert.assertFalse((String)"Should be empty", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertTrue((boolean)this.passwordHashWorker.processPasswordHash(properties));
        Assert.assertEquals(Arrays.asList("md4", "bcrypt10"), properties.get(ContentModel.PROP_HASH_INDICATOR));
        Assert.assertTrue((String)"Should now contain the password", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertTrue((boolean)PasswordHashingTest.matches("HASHED_MY_PASSWORD", properties, this.cpe));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_SHA256));
        properties.clear();
        properties.put(ContentModel.PROP_PASSWORD, (Serializable)((Object)"This should be ignored"));
        properties.put(ContentModel.PROP_PASSWORD_SHA256, (Serializable)((Object)sha256Hashed));
        properties.put(ContentModel.PROP_SALT, (Serializable)((Object)salt));
        Assert.assertTrue((String)"We have the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD));
        Assert.assertTrue((String)"We have the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_SHA256));
        Assert.assertFalse((String)"Should be empty", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertTrue((boolean)this.passwordHashWorker.processPasswordHash(properties));
        Assert.assertEquals(Arrays.asList("sha256", "bcrypt10"), properties.get(ContentModel.PROP_HASH_INDICATOR));
        Assert.assertTrue((String)"Should now contain the password", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_HASH));
        Assert.assertTrue((boolean)PasswordHashingTest.matches("HASHED_MY_PASSWORD", properties, this.cpe));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD));
        Assert.assertFalse((String)"Should remove the property", (boolean)properties.containsKey(ContentModel.PROP_PASSWORD_SHA256));
    }

    @Test
    public void testRehashedPasswordBcrypt() throws Exception {
        this.cpe.setPreferredEncoding("md4");
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(ContentModel.PROP_HASH_INDICATOR, (Serializable)((Object)Arrays.asList("md4")));
        properties.put(ContentModel.PROP_PASSWORD_HASH, "long hash");
        Assert.assertFalse((boolean)this.passwordHashWorker.processPasswordHash(properties));
        this.cpe.setPreferredEncoding("bcrypt11");
        Assert.assertTrue((boolean)this.passwordHashWorker.processPasswordHash(properties));
        Assert.assertEquals(Arrays.asList("md4", "bcrypt11"), (Object)RepositoryAuthenticationDao.determinePasswordHash(properties).getFirst());
    }

    @Test
    public void testGetPasswordHash() throws Exception {
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        this.cpe.setPreferredEncoding("bcrypt10");
        try {
            RepositoryAuthenticationDao.determinePasswordHash(properties);
            Assert.fail((String)"Should throw exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertTrue((boolean)are.getMessage().contains("Unable to find a password for user"));
        }
        properties.put(ContentModel.PROP_PASSWORD, "mypassword");
        Pair passwordHashed = RepositoryAuthenticationDao.determinePasswordHash(properties);
        Assert.assertEquals((Object)CompositePasswordEncoder.MD4, (Object)passwordHashed.getFirst());
        Assert.assertEquals((Object)"mypassword", (Object)passwordHashed.getSecond());
        properties.put(ContentModel.PROP_PASSWORD_SHA256, "sha_password");
        passwordHashed = RepositoryAuthenticationDao.determinePasswordHash(properties);
        Assert.assertEquals((Object)CompositePasswordEncoder.SHA256, (Object)passwordHashed.getFirst());
        Assert.assertEquals((Object)"sha_password", (Object)passwordHashed.getSecond());
        properties.put(ContentModel.PROP_HASH_INDICATOR, null);
        passwordHashed = RepositoryAuthenticationDao.determinePasswordHash(properties);
        Assert.assertEquals((Object)CompositePasswordEncoder.SHA256, (Object)passwordHashed.getFirst());
        Assert.assertEquals((Object)"sha_password", (Object)passwordHashed.getSecond());
        properties.put(ContentModel.PROP_HASH_INDICATOR, new ArrayList(0));
        passwordHashed = RepositoryAuthenticationDao.determinePasswordHash(properties);
        Assert.assertEquals((Object)CompositePasswordEncoder.SHA256, (Object)passwordHashed.getFirst());
        Assert.assertEquals((Object)"sha_password", (Object)passwordHashed.getSecond());
        properties.put(ContentModel.PROP_HASH_INDICATOR, (Serializable)((Object)Arrays.asList("myencoding")));
        properties.put(ContentModel.PROP_PASSWORD_HASH, "hashed this time");
        passwordHashed = RepositoryAuthenticationDao.determinePasswordHash(properties);
        Assert.assertEquals(Arrays.asList("myencoding"), (Object)passwordHashed.getFirst());
        Assert.assertEquals((Object)"hashed this time", (Object)passwordHashed.getSecond());
    }

    private static boolean matches(String password, Map<QName, Serializable> properties, CompositePasswordEncoder cpe) {
        return cpe.matchesPassword(password, (String)((Object)properties.get(ContentModel.PROP_PASSWORD_HASH)), (Object)((String)((Object)properties.get(ContentModel.PROP_SALT))), (List)((Object)properties.get(ContentModel.PROP_HASH_INDICATOR)));
    }
}

