/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import jakarta.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.impl.DisabledFeatureException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class SearchServiceTest
extends TestCase {
    private ApplicationContext ctx;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    private UserTransaction tx;
    private SearchService pubSearchService;
    private NodeRef rootNodeRef;
    private NodeRef n1;
    private NodeRef n2;
    private NodeRef n3;
    private NodeRef n4;
    private NodeRef n5;
    private NodeService nodeService;
    private PermissionService pubPermissionService;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.nodeService = (NodeService)this.ctx.getBean("dbNodeService");
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)this.ctx.getBean("authenticationService");
        this.authenticationDAO = (MutableAuthenticationDao)this.ctx.getBean("authenticationDao");
        this.pubSearchService = (SearchService)this.ctx.getBean("SearchService");
        this.pubPermissionService = (PermissionService)this.ctx.getBean("PermissionService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)this.ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        if (!this.authenticationDAO.userExists("andy")) {
            this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        }
        if (!this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        }
        if (!this.authenticationDAO.userExists("administrator")) {
            this.authenticationService.createAuthentication("administrator", "administrator".toCharArray());
        }
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}01"), ContentModel.TYPE_FOLDER).getChildRef();
        this.pubPermissionService.setPermission(this.n1, "andy", "Read", true);
        this.n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}02"), ContentModel.TYPE_FOLDER).getChildRef();
        this.pubPermissionService.setPermission(this.n2, "andy", "Read", true);
        this.n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}03"), ContentModel.TYPE_FOLDER).getChildRef();
        this.pubPermissionService.setPermission(this.n3, "andy", "Read", true);
        this.n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}04"), ContentModel.TYPE_FOLDER).getChildRef();
        this.pubPermissionService.setPermission(this.n4, "andy", "Read", true);
        this.n5 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}05"), ContentModel.TYPE_FOLDER).getChildRef();
        this.pubPermissionService.setPermission(this.n5, "andy", "Read", true);
        this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}06"), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}07"), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}08"), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}09"), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}10"), ContentModel.TYPE_FOLDER).getChildRef();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.tx.rollback();
        super.tearDown();
    }

    public void testHybridDisabledByDefault() {
        try {
            this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
            SearchParameters sp = new SearchParameters();
            sp.setQueryConsistency(QueryConsistency.HYBRID);
            sp.setLanguage("cmis-alfresco");
            sp.setQuery("select * from cmis:document where cmis:name like '%alfresco%'");
            sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            this.pubSearchService.query(sp);
            SearchServiceTest.fail((String)"Hybrid search should be disabled.");
        }
        catch (DisabledFeatureException disabledFeatureException) {}
    }

    public void testAndyCMIS() {
        this.authenticationComponent.setCurrentUser("andy");
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("cmis-alfresco");
        sp.setQuery("select * from cmis:folder");
        sp.addStore(this.rootNodeRef.getStoreRef());
        ResultSet results = this.pubSearchService.query(sp);
        SearchServiceTest.assertEquals((int)results.length(), (int)5);
        SearchServiceTest.assertNotNull((Object)results.getResultSetMetaData());
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getLimitedBy(), (Object)LimitBy.UNLIMITED);
        SearchServiceTest.assertEquals((Object)results.getResultSetMetaData().getPermissionEvaluationMode(), (Object)PermissionEvaluationMode.EAGER);
        results.close();
    }

    public void testSearchWithSort() {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SearchParameters sp = new SearchParameters();
        sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        sp.setLanguage("lucene");
        sp.addSort("@cm:name", true);
        sp.setQuery("TYPE:\"cm:content\"");
        try (ResultSet rs = this.pubSearchService.query(sp);){
            for (ResultSetRow row : rs) {
                SearchServiceTest.assertFalse((row.getValue(ContentModel.PROP_NAME) == null ? 1 : 0) != 0);
            }
        }
        sp = new SearchParameters();
        sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"cm:content\"");
        rs = this.pubSearchService.query(sp);
        try {
            for (ResultSetRow row : rs) {
                SearchServiceTest.assertFalse((row.getValue(ContentModel.PROP_NAME) == null ? 1 : 0) != 0);
            }
        }
        finally {
            rs.close();
        }
    }
}

