/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.sync;

import java.util.Date;
import java.util.HashSet;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.repo.security.sync.ldap.LDAPUserRegistry;
import org.alfresco.service.namespace.NamespaceService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LDAPUserRegistryTest {
    @Mock
    private LDAPInitialDirContextFactory contextFactory;
    @Mock
    private InitialDirContext initialDirContext;
    @Mock
    private NamespaceService namespaceService;
    @Mock
    private SearchResult searchResult;
    @Mock
    private NamingEnumeration<SearchResult> searchResults;
    @Mock
    private Attributes attributes;
    @Mock
    private Attribute groupAttribute;
    @Mock
    private Attribute rangeRestrictedAttribute;
    private static final String GROUP_SEARCH_BASE = "ou=groups,DC=example,DC=foo";
    private static final String USER_SEARCH_BASE = "cn=Users,DC=example,DC=foo";
    private static final String GROUP_QUERY = "groupQuery=(objectclass=groupOfNames)";
    private static final String PERSON_QUERY = "(objectclass=inetOrgPerson)";
    private static final String GROUP_DIFFERENTIAL_QUERY = "(objectclass=groupOfNames)";
    private static final String PERSON_DIFFERENTIAL_QUERY = "(objectclass=inetOrgPerson)";
    private static final String GROUP_ID_ATTRIBUTE_NAME = "cn";
    private static final String USER_ID_ATTRIBUTE_NAME = "uid";
    private static final String GROUP_ATTRIBUTE = "cn: foogroup10";
    private static final String MEMBER_ATTRIBUTE_NAME = "member";
    private static final String MEMBER_ATTRIBUTE_VALUE = "cn=foouser10,cn=Users,dc=example,dc=foo";

    private LDAPUserRegistry createRegistry() throws Exception {
        LDAPUserRegistry registry = new LDAPUserRegistry();
        registry.setLDAPInitialDirContextFactory(this.contextFactory);
        registry.setNamespaceService(this.namespaceService);
        registry.setGroupSearchBase(GROUP_SEARCH_BASE);
        registry.setUserSearchBase(USER_SEARCH_BASE);
        registry.setGroupQuery(GROUP_QUERY);
        registry.setPersonQuery("(objectclass=inetOrgPerson)");
        registry.setGroupDifferentialQuery(GROUP_DIFFERENTIAL_QUERY);
        registry.setPersonDifferentialQuery("(objectclass=inetOrgPerson)");
        registry.setGroupIdAttributeName(GROUP_ID_ATTRIBUTE_NAME);
        registry.setUserIdAttributeName(USER_ID_ATTRIBUTE_NAME);
        registry.setMemberAttribute(MEMBER_ATTRIBUTE_NAME);
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.add("cm");
        Mockito.when((Object)this.namespaceService.getPrefixes("http://www.alfresco.org/model/content/1.0")).thenReturn(prefixes);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Mockito.when((Object)this.contextFactory.getDefaultIntialDirContext()).thenReturn((Object)this.initialDirContext);
        Mockito.when((Object)this.contextFactory.getDefaultIntialDirContext(0)).thenReturn((Object)this.initialDirContext);
        Mockito.when(this.initialDirContext.search((String)ArgumentMatchers.eq((Object)GROUP_SEARCH_BASE), (String)ArgumentMatchers.eq((Object)GROUP_DIFFERENTIAL_QUERY), (SearchControls)ArgumentMatchers.any())).thenReturn(this.searchResults);
        Mockito.when((Object)this.searchResults.hasMore()).thenReturn((Object)true);
        Mockito.when((Object)this.searchResults.next()).thenReturn((Object)this.searchResult);
        Mockito.when((Object)this.searchResult.getAttributes()).thenReturn((Object)this.attributes);
        Mockito.when((Object)this.attributes.get(GROUP_ID_ATTRIBUTE_NAME)).thenReturn((Object)this.groupAttribute);
        Mockito.when((Object)this.groupAttribute.get(0)).thenReturn((Object)GROUP_ATTRIBUTE);
        Mockito.when((Object)this.attributes.get(MEMBER_ATTRIBUTE_NAME)).thenReturn((Object)this.rangeRestrictedAttribute);
        Mockito.when((Object)this.rangeRestrictedAttribute.size()).thenReturn((Object)1);
        Mockito.when((Object)this.rangeRestrictedAttribute.get(0)).thenReturn((Object)MEMBER_ATTRIBUTE_VALUE);
        registry.afterPropertiesSet();
        return registry;
    }

    @Test
    public void testTimeoutDuringSync() throws Exception {
        LDAPUserRegistry userRegistry = this.createRegistry();
        Mockito.when((Object)this.initialDirContext.getAttributes((Name)ArgumentMatchers.eq((Object)LDAPUserRegistry.jndiName((String)MEMBER_ATTRIBUTE_VALUE)), (String[])ArgumentMatchers.any())).thenThrow(new Throwable[]{new NamingException("LDAP response read timed out test.")});
        try {
            userRegistry.getGroups(new Date());
            Assert.fail((String)"The process should fail with an exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertEquals((String)"The error message is not of the right format.", (Object)"synchronization.err.ldap.search", (Object)are.getMsgId());
            Assert.assertTrue((String)"The error message was not caused by timeout.", (boolean)are.getCause().getMessage().contains("LDAP response read timed out"));
        }
    }

    @Test
    public void testTimeoutDuringSyncForServiceUnavailableException() throws Exception {
        LDAPUserRegistry userRegistry = this.createRegistry();
        Mockito.when((Object)this.initialDirContext.getAttributes((Name)ArgumentMatchers.eq((Object)LDAPUserRegistry.jndiName((String)MEMBER_ATTRIBUTE_VALUE)), (String[])ArgumentMatchers.any())).thenThrow(new Throwable[]{new ServiceUnavailableException(" test.")});
        try {
            userRegistry.getGroups(new Date());
            Assert.fail((String)"The process should fail with an exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertEquals((String)"The error message is not of the right format.", (Object)"synchronization.err.ldap.search", (Object)are.getMsgId());
            Assert.assertTrue((String)"The error message was not caused by timeout.", (boolean)are.getCause().getMessage().contains(" test."));
        }
    }

    @Test
    public void testTimeoutDuringSyncForCommunicationException() throws Exception {
        LDAPUserRegistry userRegistry = this.createRegistry();
        Mockito.when((Object)this.initialDirContext.getAttributes((Name)ArgumentMatchers.eq((Object)LDAPUserRegistry.jndiName((String)MEMBER_ATTRIBUTE_VALUE)), (String[])ArgumentMatchers.any())).thenThrow(new Throwable[]{new CommunicationException(" test.")});
        try {
            userRegistry.getGroups(new Date());
            Assert.fail((String)"The process should fail with an exception");
        }
        catch (AlfrescoRuntimeException are) {
            Assert.assertEquals((String)"The error message is not of the right format.", (Object)"synchronization.err.ldap.search", (Object)are.getMsgId());
            Assert.assertTrue((String)"The error message was not caused by timeout.", (boolean)are.getCause().getMessage().contains(" test."));
        }
    }
}

