/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.action.ActionDefinitionImpl;
import org.alfresco.repo.action.ParameterizedItemAbstractBase;
import org.alfresco.repo.action.access.ActionAccessRestriction;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.repo.action.executer.LoggingAwareExecuter;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public abstract class ActionExecuterAbstractBase
extends ParameterizedItemAbstractBase
implements ActionExecuter,
LoggingAwareExecuter {
    private static Log logger = LogFactory.getLog(ActionExecuterAbstractBase.class);
    protected ActionDefinition actionDefinition;
    private LockService lockService;
    private NodeService baseNodeService;
    private DictionaryService dictionaryService;
    private NodeService mlAwareNodeService;
    private boolean trackStatus = false;
    protected boolean publicAction = true;
    protected List<ActionAccessRestriction> actionAccessRestrictions = new ArrayList<ActionAccessRestriction>();
    protected Set<QName> applicableTypes = new HashSet<QName>();
    private String queueName = "";
    private boolean ignoreLock = true;

    public void init() {
        if (this.publicAction) {
            this.runtimeActionService.registerActionExecuter(this);
        }
    }

    public void setMlAwareNodeService(NodeService mlAwareNodeService) {
        this.mlAwareNodeService = mlAwareNodeService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setBaseNodeService(NodeService nodeService) {
        this.baseNodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPublicAction(boolean publicAction) {
        this.publicAction = publicAction;
    }

    public void setActionAccessRestrictions(List<ActionAccessRestriction> actionAccessRestrictions) {
        this.actionAccessRestrictions = actionAccessRestrictions;
    }

    public List<ActionAccessRestriction> getActionAccessRestrictions() {
        return this.actionAccessRestrictions;
    }

    @Override
    public boolean getTrackStatus() {
        return this.trackStatus;
    }

    public void setTrackStatus(boolean trackStatus) {
        this.trackStatus = trackStatus;
    }

    public void setApplicableTypes(String[] applicableTypes) {
        String[] stringArray = applicableTypes;
        int n = applicableTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.applicableTypes.add(QName.createQName((String)type));
            ++n2;
        }
    }

    @Override
    public boolean getIgnoreLock() {
        return this.ignoreLock;
    }

    public void setIgnoreLock(boolean ignoreLock) {
        this.ignoreLock = ignoreLock;
    }

    protected boolean isApplicableType(NodeRef actionedUponNodeRef) {
        if (this.baseNodeService.exists(actionedUponNodeRef)) {
            QName nodeType = this.baseNodeService.getType(actionedUponNodeRef);
            if (this.applicableTypes.contains(nodeType)) {
                return true;
            }
            for (QName type : this.applicableTypes) {
                if (!this.dictionaryService.isSubClass(nodeType, type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ActionDefinition getActionDefinition() {
        if (this.actionDefinition == null) {
            this.actionDefinition = this.createActionDefinition(this.name);
            ((ActionDefinitionImpl)this.actionDefinition).setTitleKey(this.getTitleKey());
            ((ActionDefinitionImpl)this.actionDefinition).setDescriptionKey(this.getDescriptionKey());
            ((ActionDefinitionImpl)this.actionDefinition).setTrackStatus(this.getTrackStatus());
            ((ActionDefinitionImpl)this.actionDefinition).setAdhocPropertiesAllowed(this.getAdhocPropertiesAllowed());
            ((ActionDefinitionImpl)this.actionDefinition).setRuleActionExecutor(this.name);
            ((ActionDefinitionImpl)this.actionDefinition).setLocalizedParameterDefinitions(this.getLocalizedParameterDefinitions());
            ((ActionDefinitionImpl)this.actionDefinition).setApplicableTypes(this.applicableTypes);
        }
        return this.actionDefinition;
    }

    protected ActionDefinition createActionDefinition(String name) {
        return new ActionDefinitionImpl(name);
    }

    @Override
    public void execute(Action action, NodeRef actionedUponNodeRef) {
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new IllegalStateException("Actions invariably access the repository.  Doing so without a transaction is not recommended.");
        }
        this.checkMandatoryProperties(action, this.getActionDefinition());
        boolean nodeIsLockedForThisUser = false;
        if (!this.ignoreLock && actionedUponNodeRef != null && this.mlAwareNodeService.exists(actionedUponNodeRef)) {
            nodeIsLockedForThisUser = this.lockService.isLockedAndReadOnly(actionedUponNodeRef);
        }
        if (!nodeIsLockedForThisUser) {
            this.verifyActionAccessRestrictions(action);
            this.executeImpl(action, actionedUponNodeRef);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Action (" + action.getActionDefinitionName() + ") ignored because actioned upon node (" + String.valueOf(actionedUponNodeRef) + ") is locked."));
        }
    }

    @Override
    public void verifyActionAccessRestrictions(Action action) {
        this.actionAccessRestrictions.forEach(ar -> ar.verifyAccessRestriction(action));
    }

    protected abstract void executeImpl(Action var1, NodeRef var2);

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public boolean onLogException(Log logger, Throwable t, String message) {
        return false;
    }
}

