/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.NodeArchiveServicePolicies;
import org.alfresco.repo.node.archive.ArchivedNodeEntity;
import org.alfresco.repo.node.archive.ArchivedNodesCannedQueryBuilder;
import org.alfresco.repo.node.archive.GetArchivedNodesCannedQuery;
import org.alfresco.repo.node.archive.GetArchivedNodesCannedQueryFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.VmShutdownListener;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeArchiveServiceImpl
implements NodeArchiveService {
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org", (String)"NodeArchive");
    private static final long LOCK_TTL = 60000L;
    private static final String MSG_BUSY = "node.archive.msg.busy";
    private static final String CANNED_QUERY_ARCHIVED_NODES_LIST = "archivedNodesCannedQueryFactory";
    private static Log logger = LogFactory.getLog(NodeArchiveServiceImpl.class);
    protected NodeService nodeService;
    private PermissionService permissionService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private AuthorityService authorityService;
    private NamedObjectRegistry<CannedQueryFactory<ArchivedNodeEntity>> cannedQueryRegistry;
    private TenantService tenantService;
    private boolean userNamesAreCaseSensitive = false;
    private PolicyComponent policyComponent;
    private ClassPolicyDelegate<NodeArchiveServicePolicies.BeforePurgeNodePolicy> beforePurgeNodeDelegate;
    private ClassPolicyDelegate<NodeArchiveServicePolicies.BeforeRestoreArchivedNodePolicy> beforeRestoreArchivedNodeDelegate;
    private ClassPolicyDelegate<NodeArchiveServicePolicies.OnRestoreArchivedNodePolicy> onRestoreArchivedNodeDelegate;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @Override
    public NodeRef getStoreArchiveNode(StoreRef originalStoreRef) {
        return this.nodeService.getStoreArchiveNode(originalStoreRef);
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void init() {
        this.beforePurgeNodeDelegate = this.policyComponent.registerClassPolicy(NodeArchiveServicePolicies.BeforePurgeNodePolicy.class);
        this.beforeRestoreArchivedNodeDelegate = this.policyComponent.registerClassPolicy(NodeArchiveServicePolicies.BeforeRestoreArchivedNodePolicy.class);
        this.onRestoreArchivedNodeDelegate = this.policyComponent.registerClassPolicy(NodeArchiveServicePolicies.OnRestoreArchivedNodePolicy.class);
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<ArchivedNodeEntity>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    @Override
    public NodeRef getArchivedNode(NodeRef originalNodeRef) {
        StoreRef orginalStoreRef = originalNodeRef.getStoreRef();
        NodeRef archiveRootNodeRef = this.nodeService.getStoreArchiveNode(orginalStoreRef);
        NodeRef archivedNodeRef = new NodeRef(archiveRootNodeRef.getStoreRef(), originalNodeRef.getId());
        return archivedNodeRef;
    }

    private List<NodeRef> getArchivedNodes(StoreRef originalStoreRef) {
        final NodeRef archiveParentNodeRef = this.nodeService.getStoreArchiveNode(originalStoreRef);
        AuthenticationUtil.RunAsWork<List<ChildAssociationRef>> runAsWork = new AuthenticationUtil.RunAsWork<List<ChildAssociationRef>>(){

            public List<ChildAssociationRef> doWork() throws Exception {
                String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                if (currentUser == null) {
                    throw new AccessDeniedException("No authenticated user; cannot get archived nodes.");
                }
                return NodeArchiveServiceImpl.this.nodeService.getChildAssocs(archiveParentNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)NodeArchiveService.QNAME_ARCHIVED_ITEM);
            }
        };
        List archivedAssocs = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getSystemUserName());
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(archivedAssocs.size());
        for (ChildAssociationRef childAssociationRef : archivedAssocs) {
            NodeRef nodeRef = childAssociationRef.getChildRef();
            if (this.permissionService.hasPermission(nodeRef, "Delete") != AccessStatus.ALLOWED) continue;
            nodeRefs.add(nodeRef);
        }
        return nodeRefs;
    }

    private BatchProcessWorkProvider<NodeRef> getArchivedNodesWorkProvider(final StoreRef originalStoreRef, final String lockToken) {
        return new BatchProcessWorkProvider<NodeRef>(){
            private VmShutdownListener vmShutdownLister = new VmShutdownListener("getArchivedNodesWorkProvider");
            private List<NodeRef> nodeRefs;
            private boolean done;

            private synchronized List<NodeRef> getNodeRefs() {
                if (this.nodeRefs == null) {
                    this.nodeRefs = NodeArchiveServiceImpl.this.getArchivedNodes(originalStoreRef);
                }
                return this.nodeRefs;
            }

            @Override
            public synchronized int getTotalEstimatedWorkSize() {
                return 0;
            }

            @Override
            public synchronized long getTotalEstimatedWorkSizeLong() {
                return 0L;
            }

            @Override
            public synchronized Collection<NodeRef> getNextWork() {
                if (this.vmShutdownLister.isVmShuttingDown()) {
                    return Collections.emptyList();
                }
                try {
                    NodeArchiveServiceImpl.this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L);
                }
                catch (LockAcquisitionException lockAcquisitionException) {
                    return Collections.emptyList();
                }
                if (this.done) {
                    return Collections.emptyList();
                }
                this.done = true;
                return this.getNodeRefs();
            }
        };
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(final NodeRef archivedNodeRef, final NodeRef destinationNodeRef, final QName assocTypeQName, final QName assocQName) {
        RestoreNodeReport report = new RestoreNodeReport(archivedNodeRef);
        report.setTargetParentNodeRef(destinationNodeRef);
        try {
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> restoreCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    NodeRef restoredNodeRef = null;
                    NodeArchiveServiceImpl.this.invokeBeforeRestoreArchivedNode(archivedNodeRef);
                    try {
                        restoredNodeRef = NodeArchiveServiceImpl.this.nodeService.restoreNode(archivedNodeRef, destinationNodeRef, assocTypeQName, assocQName);
                    }
                    catch (Throwable throwable) {
                        NodeArchiveServiceImpl.this.invokeOnRestoreArchivedNode(restoredNodeRef);
                        throw throwable;
                    }
                    NodeArchiveServiceImpl.this.invokeOnRestoreArchivedNode(restoredNodeRef);
                    return restoredNodeRef;
                }
            };
            NodeRef newNodeRef = txnHelper.doInTransaction(restoreCallback, false, true);
            report.setRestoredNodeRef(newNodeRef);
            report.setStatus(RestoreNodeReport.RestoreStatus.SUCCESS);
        }
        catch (InvalidNodeRefException e) {
            report.setCause(e);
            NodeRef invalidNodeRef = e.getNodeRef();
            if (archivedNodeRef.equals((Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_ARCHIVE_NODE);
            } else if (EqualsHelper.nullSafeEquals((Object)destinationNodeRef, (Object)invalidNodeRef)) {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
            } else if (destinationNodeRef == null) {
                ChildAssociationRef originalParentAssocRef = (ChildAssociationRef)this.nodeService.getProperty(archivedNodeRef, ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
                NodeRef originalParentNodeRef = originalParentAssocRef.getParentRef();
                if (EqualsHelper.nullSafeEquals((Object)originalParentNodeRef, (Object)invalidNodeRef)) {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT);
                } else {
                    report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
                }
            } else {
                report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            }
        }
        catch (DuplicateChildNodeNameException e) {
            report.setCause(e);
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_DUPLICATE_CHILD_NODE_NAME);
            logger.error((Object)e);
        }
        catch (AccessDeniedException e) {
            report.setCause((Throwable)((Object)e));
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION);
        }
        catch (Throwable e) {
            report.setCause(e);
            report.setStatus(RestoreNodeReport.RestoreStatus.FAILURE_OTHER);
            logger.error((Object)"An unhandled exception stopped the restore", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempted node restore: " + String.valueOf(report)));
        }
        return report;
    }

    @Override
    public RestoreNodeReport restoreArchivedNode(NodeRef archivedNodeRef) {
        return this.restoreArchivedNode(archivedNodeRef, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs) {
        return this.restoreArchivedNodes(archivedNodeRefs, null, null, null);
    }

    @Override
    public List<RestoreNodeReport> restoreArchivedNodes(List<NodeRef> archivedNodeRefs, NodeRef destinationNodeRef, QName assocTypeQName, QName assocQName) {
        ArrayList<RestoreNodeReport> results = new ArrayList<RestoreNodeReport>(archivedNodeRefs.size());
        for (NodeRef nodeRef : archivedNodeRefs) {
            RestoreNodeReport result = this.restoreArchivedNode(nodeRef, destinationNodeRef, assocTypeQName, assocQName);
            results.add(result);
        }
        return results;
    }

    protected void invokeBeforeRestoreArchivedNode(NodeRef nodeRef) {
        if (nodeRef == null || this.ignorePolicy(nodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeArchiveServicePolicies.BeforeRestoreArchivedNodePolicy policy = this.beforeRestoreArchivedNodeDelegate.get(nodeRef, qnames);
        policy.beforeRestoreArchivedNode(nodeRef);
    }

    protected void invokeOnRestoreArchivedNode(NodeRef nodeRef) {
        if (nodeRef == null || this.ignorePolicy(nodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeArchiveServicePolicies.OnRestoreArchivedNodePolicy policy = this.onRestoreArchivedNodeDelegate.get(nodeRef, qnames);
        policy.onRestoreArchivedNode(nodeRef);
    }

    @Override
    public void purgeArchivedNode(final NodeRef archivedNodeRef) {
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Exception {
                if (!NodeArchiveServiceImpl.this.nodeService.exists(archivedNodeRef)) {
                    return null;
                }
                NodeArchiveServiceImpl.this.invokeBeforePurgeNode(archivedNodeRef);
                NodeArchiveServiceImpl.this.nodeService.deleteNode(archivedNodeRef);
                return null;
            }
        };
        txnHelper.doInTransaction(deleteCallback, false, true);
    }

    @Override
    public void purgeArchivedNodes(List<NodeRef> archivedNodes) {
        for (NodeRef archivedNodeRef : archivedNodes) {
            this.purgeArchivedNode(archivedNodeRef);
        }
    }

    @Override
    public void purgeAllArchivedNodes(StoreRef originalStoreRef) {
        final String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (user == null) {
            throw new IllegalStateException("Cannot purge as there is no authenticated user.");
        }
        BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> worker = new BatchProcessor.BatchProcessWorkerAdaptor<NodeRef>(){

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.pushAuthentication();
            }

            @Override
            public void process(NodeRef nodeRef) throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)user);
                if (NodeArchiveServiceImpl.this.nodeService.exists(nodeRef)) {
                    NodeArchiveServiceImpl.this.invokeBeforePurgeNode(nodeRef);
                    NodeArchiveServiceImpl.this.nodeService.deleteNode(nodeRef);
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.popAuthentication();
            }
        };
        this.doBulkOperation(user, originalStoreRef, (BatchProcessor.BatchProcessWorker<NodeRef>)worker);
    }

    private void doBulkOperation(String user, StoreRef originalStoreRef, BatchProcessor.BatchProcessWorker<NodeRef> worker) {
        String lockToken = null;
        try {
            try {
                lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
                BatchProcessor<NodeRef> batchProcessor = new BatchProcessor<NodeRef>("ArchiveBulkPurgeOrRestore", this.transactionService.getRetryingTransactionHelper(), this.getArchivedNodesWorkProvider(originalStoreRef, lockToken), 2, 20, null, null, 1000);
                batchProcessor.process(worker, true);
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                throw new AlfrescoRuntimeException(MSG_BUSY);
            }
        }
        catch (Throwable throwable) {
            try {
                if (lockToken != null) {
                    this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                }
            }
            catch (LockAcquisitionException lockAcquisitionException) {}
            throw throwable;
        }
        try {
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
        catch (LockAcquisitionException lockAcquisitionException) {}
    }

    @Override
    public PagingResults<NodeRef> listArchivedNodes(ArchivedNodesCannedQueryBuilder cannedQueryBuilder) {
        ParameterCheck.mandatory((String)"cannedQueryBuilder", (Object)cannedQueryBuilder);
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetArchivedNodesCannedQueryFactory getArchivedNodesCannedQueryFactory = (GetArchivedNodesCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_ARCHIVED_NODES_LIST));
        Pair<NodeRef, QName> archiveNodeRefAssocTypePair = this.getArchiveNodeRefAssocTypePair(cannedQueryBuilder.getArchiveRootNodeRef());
        GetArchivedNodesCannedQuery cq = (GetArchivedNodesCannedQuery)getArchivedNodesCannedQueryFactory.getCannedQuery((NodeRef)archiveNodeRefAssocTypePair.getFirst(), (QName)archiveNodeRefAssocTypePair.getSecond(), cannedQueryBuilder.getFilter(), cannedQueryBuilder.isFilterIgnoreCase(), cannedQueryBuilder.getPagingRequest(), cannedQueryBuilder.getSortOrderAscending());
        final CannedQueryResults results = cq.execute();
        final List page = results.getPageCount() > 0 ? (List)results.getPages().get(0) : Collections.emptyList();
        PagingRequest pagingRequest = cannedQueryBuilder.getPagingRequest();
        final Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
        if (start != null) {
            int skipCount = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            int pageNum = skipCount / maxItems + 1;
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder(300);
                sb.append("listArchivedNodes: ").append(page.size()).append(" items in ").append(System.currentTimeMillis() - start).append("ms ").append("[pageNum=").append(pageNum).append(", skip=").append(skipCount).append(", max=").append(maxItems).append(", hasMorePages=").append(results.hasMoreItems()).append(", totalCount=").append(totalCount).append(", filter=").append(cannedQueryBuilder.getFilter()).append(", sortOrderAscending=").append(cannedQueryBuilder.getSortOrderAscending()).append("]");
                logger.debug((Object)sb.toString());
            }
        }
        return new PagingResults<NodeRef>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<NodeRef> getPage() {
                ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(page.size());
                for (ArchivedNodeEntity entity : page) {
                    nodeRefs.add(entity.getNodeRef());
                }
                return nodeRefs;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalCount;
            }
        };
    }

    @Override
    public boolean hasFullAccess(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        String currentUser = this.getCurrentUser();
        if (this.hasAdminAccess(currentUser)) {
            return true;
        }
        String archivedBy = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ARCHIVED_BY));
        if (!this.userNamesAreCaseSensitive && archivedBy != null) {
            archivedBy = archivedBy.toLowerCase();
        }
        return currentUser.equals(archivedBy);
    }

    protected boolean hasAdminAccess(String userID) {
        return this.authorityService.isAdminAuthority(userID);
    }

    private Pair<NodeRef, QName> getArchiveNodeRefAssocTypePair(final NodeRef archiveStoreRootNodeRef) {
        final String currentUser = this.getCurrentUser();
        if (archiveStoreRootNodeRef == null || !this.nodeService.exists(archiveStoreRootNodeRef)) {
            throw new InvalidNodeRefException("Invalid archive store root node Ref.", archiveStoreRootNodeRef);
        }
        if (this.hasAdminAccess(currentUser)) {
            return new Pair((Object)archiveStoreRootNodeRef, (Object)ContentModel.ASSOC_CHILDREN);
        }
        List list = (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<List<ChildAssociationRef>>(){

            public List<ChildAssociationRef> doWork() throws Exception {
                return NodeArchiveServiceImpl.this.nodeService.getChildrenByName(archiveStoreRootNodeRef, ContentModel.ASSOC_ARCHIVE_USER_LINK, Collections.singletonList(currentUser));
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        if (list == null || list.isEmpty()) {
            return new Pair(null, null);
        }
        NodeRef userArchive = ((ChildAssociationRef)list.get(0)).getChildRef();
        return new Pair((Object)userArchive, (Object)ContentModel.ASSOC_ARCHIVED_LINK);
    }

    private String getCurrentUser() {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        if (currentUser == null) {
            throw new AccessDeniedException("No authenticated user; cannot get archived nodes.");
        }
        if (!this.userNamesAreCaseSensitive && !AuthenticationUtil.getSystemUserName().equals(this.tenantService.getBaseNameUser(currentUser))) {
            currentUser = currentUser.toLowerCase();
        }
        return currentUser;
    }

    protected void invokeBeforePurgeNode(NodeRef nodeRef) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeArchiveServicePolicies.BeforePurgeNodePolicy policy = this.beforePurgeNodeDelegate.get(nodeRef, qnames);
        policy.beforePurgeNode(nodeRef);
    }

    protected Set<QName> getTypeAndAspectQNames(NodeRef nodeRef) {
        Set<QName> qnames = null;
        try {
            Set aspectQNames = this.nodeService.getAspects(nodeRef);
            QName typeQName = this.nodeService.getType(nodeRef);
            qnames = new HashSet<QName>(aspectQNames.size() + 1);
            qnames.addAll(aspectQNames);
            qnames.add(typeQName);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            qnames = Collections.emptySet();
        }
        return qnames;
    }

    private boolean ignorePolicy(NodeRef nodeRef) {
        return false;
    }
}

