/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.SolrAdminHTTPClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class SolrChildApplicationContextFactory
extends ChildApplicationContextFactory {
    private static final Log LOGGER = LogFactory.getLog(SolrChildApplicationContextFactory.class);
    protected static final String ALFRESCO_ACTIVE = "tracker.alfresco.active";
    protected static final String ALFRESCO_LAG = "tracker.alfresco.lag";
    protected static final String ALFRESCO_LAG_DURATION = "tracker.alfresco.lag.duration";
    protected static final String ALFRESCO_LAST_INDEXED_TXN = "tracker.alfresco.last.indexed.txn";
    protected static final String ALFRESCO_APPROX_TXNS_REMAINING = "tracker.alfresco.approx.txns.remaining";
    protected static final String ALFRESCO_APPROX_INDEXING_TIME_REMAINING = "tracker.alfresco.approx.indexing.time.remaining";
    protected static final String ALFRESCO_DISK = "tracker.alfresco.disk";
    protected static final String ALFRESCO_MEMORY = "tracker.alfresco.memory";
    protected static final String ARCHIVE_ACTIVE = "tracker.archive.active";
    protected static final String ARCHIVE_LAG = "tracker.archive.lag";
    protected static final String ARCHIVE_LAG_DURATION = "tracker.archive.lag.duration";
    protected static final String ARCHIVE_LAST_INDEXED_TXN = "tracker.archive.last.indexed.txn";
    protected static final String ARCHIVE_APPROX_TXNS_REMAINING = "tracker.archive.approx.txns.remaining";
    protected static final String ARCHIVE_APPROX_INDEXING_TIME_REMAINING = "tracker.archive.approx.indexing.time.remaining";
    protected static final String ARCHIVE_DISK = "tracker.archive.disk";
    protected static final String ARCHIVE_MEMORY = "tracker.archive.memory";
    private static final String SUMMARY_FIELD_TOTAL_SEARCHER_CACHE_GB = "Total Searcher Cache (GB)";
    private static final String SUMMARY_FIELD_ON_DISK_GB = "On disk (GB)";
    private static final String SUMMARY_FIELD_APPROX_TRANSACTION_INDEXING_TIME_REMAINING = "Approx transaction indexing time remaining";
    private static final String SUMMARY_FIELD_APPROX_TRANSACTIONS_REMAINING = "Approx transactions remaining";
    private static final String SUMMARY_FIELD_ID_FOR_LAST_TX_IN_INDEX = "Id for last TX in index";
    private static final String SUMMARY_FIELD_TX_DURATION = "TX Duration";
    private static final String SUMMARY_FIELD_TX_LAG = "TX Lag";
    private static final String SUMMARY_FIELD_ACTIVE = "Active";
    private SolrAdminHTTPClient adminClient;

    public void setAdminClient(SolrAdminHTTPClient adminClient) {
        this.adminClient = adminClient;
    }

    public SolrAdminHTTPClient getAdminClient() {
        if (this.adminClient == null) {
            ApplicationContext ctx = this.getApplicationContext();
            this.adminClient = (SolrAdminHTTPClient)ctx.getBean("search.solrAdminHTTPCLient");
        }
        return this.adminClient;
    }

    private static boolean isAlfrescoCoreProperty(String name) {
        return name.startsWith("tracker.alfresco.");
    }

    private static boolean isArchiveCoreProperty(String name) {
        return name.startsWith("tracker.archive.");
    }

    @Override
    public boolean isUpdateable(String name) {
        return super.isUpdateable(name) && !name.equals(ALFRESCO_ACTIVE) && !name.equals(ALFRESCO_LAG) && !name.equals(ALFRESCO_LAG_DURATION) && !name.equals(ALFRESCO_LAST_INDEXED_TXN) && !name.equals(ALFRESCO_APPROX_TXNS_REMAINING) && !name.equals(ALFRESCO_APPROX_INDEXING_TIME_REMAINING) && !name.equals(ALFRESCO_DISK) && !name.equals(ALFRESCO_MEMORY) && !name.equals(ARCHIVE_ACTIVE) && !name.equals(ARCHIVE_LAG) && !name.equals(ARCHIVE_LAG_DURATION) && !name.equals(ARCHIVE_APPROX_TXNS_REMAINING) && !name.equals(ARCHIVE_APPROX_INDEXING_TIME_REMAINING) && !name.equals(ARCHIVE_LAST_INDEXED_TXN) && !name.equals(ARCHIVE_DISK) && !name.equals(ARCHIVE_MEMORY);
    }

    private String getPropertyValue(JSONObject core, String name) {
        switch (name) {
            case "tracker.alfresco.active": 
            case "tracker.archive.active": {
                return core.getBoolean(SUMMARY_FIELD_ACTIVE) ? "true" : "false";
            }
            case "tracker.alfresco.lag": 
            case "tracker.archive.lag": {
                return core.getString(SUMMARY_FIELD_TX_LAG);
            }
            case "tracker.alfresco.lag.duration": 
            case "tracker.archive.lag.duration": {
                return core.getString(SUMMARY_FIELD_TX_DURATION);
            }
            case "tracker.alfresco.last.indexed.txn": 
            case "tracker.archive.last.indexed.txn": {
                return core.getNumber(SUMMARY_FIELD_ID_FOR_LAST_TX_IN_INDEX).toString();
            }
            case "tracker.archive.approx.txns.remaining": 
            case "tracker.alfresco.approx.txns.remaining": {
                return core.getNumber(SUMMARY_FIELD_APPROX_TRANSACTIONS_REMAINING).toString();
            }
            case "tracker.archive.approx.indexing.time.remaining": 
            case "tracker.alfresco.approx.indexing.time.remaining": {
                return core.getString(SUMMARY_FIELD_APPROX_TRANSACTION_INDEXING_TIME_REMAINING);
            }
            case "tracker.archive.disk": 
            case "tracker.alfresco.disk": {
                return core.getNumber(SUMMARY_FIELD_ON_DISK_GB).toString();
            }
            case "tracker.alfresco.memory": 
            case "tracker.archive.memory": {
                return core.getNumber(SUMMARY_FIELD_TOTAL_SEARCHER_CACHE_GB).toString();
            }
        }
        return null;
    }

    private JSONObject getSolrSummary() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("action", "SUMMARY");
        args.put("wt", "json");
        JSONObject json = this.getAdminClient().execute(args);
        return json.getJSONObject("Summary");
    }

    @Override
    public String getProperty(String name) {
        if (!this.isUpdateable(name) && ((ChildApplicationContextFactory.ApplicationContextState)this.getState(false)).getApplicationContext(false) != null) {
            try {
                JSONObject summary = this.getSolrSummary();
                if (SolrChildApplicationContextFactory.isAlfrescoCoreProperty(name)) {
                    JSONObject alfresco = null;
                    try {
                        alfresco = summary.getJSONObject("alfresco");
                    }
                    catch (JSONException e) {
                        LOGGER.debug((Object)"Node alfresco not found", (Throwable)e);
                    }
                    if (alfresco != null) {
                        return this.getPropertyValue(alfresco, name);
                    }
                }
                if (SolrChildApplicationContextFactory.isArchiveCoreProperty(name)) {
                    JSONObject archive = null;
                    try {
                        archive = summary.getJSONObject("archive");
                    }
                    catch (JSONException e) {
                        LOGGER.debug((Object)"Node archive not found", (Throwable)e);
                    }
                    if (archive != null) {
                        return this.getPropertyValue(archive, name);
                    }
                }
                return "Unavailable";
            }
            catch (QueryParserException lqe) {
                return "Unavailable: " + lqe.getMessage();
            }
            catch (JSONException e) {
                return "Unavailable: " + e.getMessage();
            }
            catch (IllegalArgumentException iae) {
                return "Unavailable: " + iae.getMessage();
            }
        }
        if (name.equals(ALFRESCO_ACTIVE)) {
            return "";
        }
        if (name.equals(ARCHIVE_ACTIVE)) {
            return "";
        }
        if (name.equals(ALFRESCO_LAG)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_LAG_DURATION)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_LAST_INDEXED_TXN)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_APPROX_TXNS_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_APPROX_INDEXING_TIME_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_DISK)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ALFRESCO_MEMORY)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_LAG)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_LAG_DURATION)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_LAST_INDEXED_TXN)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_APPROX_TXNS_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_APPROX_INDEXING_TIME_REMAINING)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_DISK)) {
            return "Unavailable: solr subsystem not started";
        }
        if (name.equals(ARCHIVE_MEMORY)) {
            return "Unavailable: solr subsystem not started";
        }
        return super.getProperty(name);
    }

    @Override
    public Set<String> getPropertyNames() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(ALFRESCO_ACTIVE);
        result.add(ALFRESCO_LAG);
        result.add(ALFRESCO_LAG_DURATION);
        result.add(ALFRESCO_LAST_INDEXED_TXN);
        result.add(ALFRESCO_APPROX_TXNS_REMAINING);
        result.add(ALFRESCO_APPROX_INDEXING_TIME_REMAINING);
        result.add(ALFRESCO_DISK);
        result.add(ALFRESCO_MEMORY);
        result.add(ARCHIVE_ACTIVE);
        result.add(ARCHIVE_LAG);
        result.add(ARCHIVE_LAG_DURATION);
        result.add(ARCHIVE_LAST_INDEXED_TXN);
        result.add(ARCHIVE_APPROX_TXNS_REMAINING);
        result.add(ARCHIVE_APPROX_INDEXING_TIME_REMAINING);
        result.add(ARCHIVE_DISK);
        result.add(ARCHIVE_MEMORY);
        result.addAll(super.getPropertyNames());
        return result;
    }

    @Override
    public void setProperty(String name, String value) {
        if (!this.isUpdateable(name)) {
            throw new IllegalStateException("Illegal write to property \"" + name + "\"");
        }
        super.setProperty(name, value);
    }

    @Override
    protected void destroy(boolean isPermanent) {
        super.destroy(isPermanent);
        this.doInit();
    }
}

