/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.user.AccessTokenToDecodedTokenUserMapper;
import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.OIDCUserInfo;
import org.alfresco.repo.security.authentication.identityservice.user.TokenUserToOIDCUserMapper;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.lang3.StringUtils;

public class IdentityServiceJITProvisioningHandler {
    private final IdentityServiceFacade identityServiceFacade;
    private final PersonService personService;
    private final TransactionService transactionService;
    private final IdentityServiceConfig identityServiceConfig;
    private UserInfoAttrMapping userInfoAttrMapping;
    private TokenUserToOIDCUserMapper tokenUserToOIDCUserMapper;
    private AccessTokenToDecodedTokenUserMapper tokenToDecodedTokenUserMapper;

    public IdentityServiceJITProvisioningHandler(IdentityServiceFacade identityServiceFacade, PersonService personService, TransactionService transactionService, IdentityServiceConfig identityServiceConfig) {
        this.identityServiceFacade = identityServiceFacade;
        this.personService = personService;
        this.transactionService = transactionService;
        this.identityServiceConfig = identityServiceConfig;
    }

    public Optional<OIDCUserInfo> extractUserInfoAndCreateUserIfNeeded(final String bearerToken) {
        if (this.userInfoAttrMapping == null) {
            this.initMappers(this.identityServiceConfig);
        }
        final Optional<OIDCUserInfo> oidcUserInfo = Optional.ofNullable(bearerToken).filter(Predicate.not(String::isEmpty)).flatMap(token -> this.extractUserInfoResponseFromAccessToken((String)token).filter(decodedTokenUser -> StringUtils.isNotEmpty((CharSequence)decodedTokenUser.username())).or(() -> this.extractUserInfoResponseFromEndpoint((String)token, this.userInfoAttrMapping))).map(this.tokenUserToOIDCUserMapper::toOIDCUser);
        if (this.transactionService.isReadOnly() || oidcUserInfo.isEmpty()) {
            return oidcUserInfo;
        }
        return (Optional)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Optional<OIDCUserInfo>>(){

            public Optional<OIDCUserInfo> doWork() throws Exception {
                return oidcUserInfo.map(oidcUser -> {
                    if (IdentityServiceJITProvisioningHandler.this.userDoesNotExistsAndCanBeCreated((OIDCUserInfo)oidcUser)) {
                        if (!oidcUser.allFieldsNotEmpty()) {
                            oidcUser = IdentityServiceJITProvisioningHandler.this.extractUserInfoResponseFromEndpoint(bearerToken, IdentityServiceJITProvisioningHandler.this.userInfoAttrMapping).map(IdentityServiceJITProvisioningHandler.this.tokenUserToOIDCUserMapper::toOIDCUser).orElse((OIDCUserInfo)oidcUser);
                        }
                        IdentityServiceJITProvisioningHandler.this.createPerson((OIDCUserInfo)oidcUser);
                    }
                    return oidcUser;
                });
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void initMappers(IdentityServiceConfig identityServiceConfig) {
        this.userInfoAttrMapping = this.initUserInfoAttrMapping(identityServiceConfig);
        this.tokenUserToOIDCUserMapper = new TokenUserToOIDCUserMapper(this.personService);
        this.tokenToDecodedTokenUserMapper = new AccessTokenToDecodedTokenUserMapper(this.userInfoAttrMapping);
    }

    private boolean userDoesNotExistsAndCanBeCreated(OIDCUserInfo userInfo) {
        return userInfo.username() != null && this.personService.createMissingPeople() && !this.personService.personExists(userInfo.username());
    }

    private Optional<DecodedTokenUser> extractUserInfoResponseFromAccessToken(String bearerToken) {
        return Optional.ofNullable(bearerToken).map(this.identityServiceFacade::decodeToken).flatMap(this.tokenToDecodedTokenUserMapper::toDecodedTokenUser);
    }

    private Optional<DecodedTokenUser> extractUserInfoResponseFromEndpoint(String bearerToken, UserInfoAttrMapping userInfoAttrMapping) {
        return this.identityServiceFacade.getUserInfo(bearerToken, userInfoAttrMapping).filter(userInfo -> userInfo.username() != null && !userInfo.username().isEmpty());
    }

    private void createPerson(OIDCUserInfo userInfo) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userInfo.username()));
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)userInfo.firstName()));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)userInfo.lastName()));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)userInfo.email()));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_HOME_FOLDER_PROVIDER, null);
        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
        properties.put(ContentModel.PROP_SIZE_QUOTA, Long.valueOf(-1L));
        this.personService.createPerson(properties);
    }

    private UserInfoAttrMapping initUserInfoAttrMapping(IdentityServiceConfig identityServiceConfig) {
        return new UserInfoAttrMapping(this.identityServiceFacade.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName(), identityServiceConfig.getFirstNameAttribute(), identityServiceConfig.getLastNameAttribute(), identityServiceConfig.getEmailAttribute());
    }

    static /* synthetic */ boolean access$0(IdentityServiceJITProvisioningHandler identityServiceJITProvisioningHandler, OIDCUserInfo oIDCUserInfo) {
        return identityServiceJITProvisioningHandler.userDoesNotExistsAndCanBeCreated(oIDCUserInfo);
    }

    static /* synthetic */ UserInfoAttrMapping access$1(IdentityServiceJITProvisioningHandler identityServiceJITProvisioningHandler) {
        return identityServiceJITProvisioningHandler.userInfoAttrMapping;
    }

    static /* synthetic */ Optional access$2(IdentityServiceJITProvisioningHandler identityServiceJITProvisioningHandler, String string, UserInfoAttrMapping userInfoAttrMapping) {
        return identityServiceJITProvisioningHandler.extractUserInfoResponseFromEndpoint(string, userInfoAttrMapping);
    }

    static /* synthetic */ TokenUserToOIDCUserMapper access$3(IdentityServiceJITProvisioningHandler identityServiceJITProvisioningHandler) {
        return identityServiceJITProvisioningHandler.tokenUserToOIDCUserMapper;
    }

    static /* synthetic */ void access$4(IdentityServiceJITProvisioningHandler identityServiceJITProvisioningHandler, OIDCUserInfo oIDCUserInfo) {
        identityServiceJITProvisioningHandler.createPerson(oIDCUserInfo);
    }
}

