/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.alfresco.repo.action.ActionDefinitionImpl;
import org.alfresco.repo.action.BaseParameterizedItemDefinitionImplTest;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.ParameterizedItemDefinitionImpl;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.springframework.extensions.surf.util.I18NUtil;

public class ActionDefinitionImplTest
extends BaseParameterizedItemDefinitionImplTest {
    private static final String RULE_ACTION_EXECUTOR = "ruleActionExector";

    @Override
    protected ParameterizedItemDefinitionImpl create() {
        ActionDefinitionImpl temp;
        HashMap<Locale, List> localizedParams = new HashMap<Locale, List>();
        try {
            temp = new ActionDefinitionImpl("name");
            localizedParams.put(Locale.ROOT, this.duplicateParamDefs);
            temp.setLocalizedParameterDefinitions(localizedParams);
            ActionDefinitionImplTest.fail((String)"Duplicate param names are not allowed.");
        }
        catch (RuleServiceException ruleServiceException) {}
        temp = new ActionDefinitionImpl("name");
        ActionDefinitionImplTest.assertNotNull((Object)temp);
        localizedParams.put(Locale.ROOT, this.paramDefs);
        temp.setLocalizedParameterDefinitions(localizedParams);
        temp.setRuleActionExecutor(RULE_ACTION_EXECUTOR);
        return temp;
    }

    public void testGetRuleActionExecutor() {
        ActionDefinitionImpl temp = (ActionDefinitionImpl)this.create();
        ActionDefinitionImplTest.assertEquals((String)RULE_ACTION_EXECUTOR, (String)temp.getRuleActionExecutor());
    }

    public void testParameterDefinitionLocaleFallback() {
        Locale originalLocale = I18NUtil.getLocale();
        try {
            ActionDefinitionImpl actionDef = new ActionDefinitionImpl("name");
            HashMap<Locale, List<ParameterDefinition>> localizedParams = new HashMap<Locale, List<ParameterDefinition>>();
            localizedParams.put(Locale.ROOT, this.exampleFieldList("English Label"));
            localizedParams.put(Locale.ENGLISH, this.exampleFieldList("English Label"));
            localizedParams.put(Locale.UK, this.exampleFieldList("UK-specific Label"));
            localizedParams.put(Locale.GERMAN, this.exampleFieldList("German Label"));
            actionDef.setLocalizedParameterDefinitions(localizedParams);
            I18NUtil.setLocale(null);
            ActionDefinitionImplTest.assertEquals((String)"English Label", (String)actionDef.getParameterDefintion("example-field").getDisplayLabel());
            I18NUtil.setLocale((Locale)Locale.ENGLISH);
            ActionDefinitionImplTest.assertEquals((String)"English Label", (String)actionDef.getParameterDefintion("example-field").getDisplayLabel());
            I18NUtil.setLocale((Locale)Locale.UK);
            ActionDefinitionImplTest.assertEquals((String)"UK-specific Label", (String)actionDef.getParameterDefintion("example-field").getDisplayLabel());
            I18NUtil.setLocale((Locale)Locale.GERMAN);
            ActionDefinitionImplTest.assertEquals((String)"German Label", (String)actionDef.getParameterDefintion("example-field").getDisplayLabel());
            I18NUtil.setLocale((Locale)Locale.GERMANY);
            ActionDefinitionImplTest.assertEquals((String)"German Label", (String)actionDef.getParameterDefintion("example-field").getDisplayLabel());
        }
        finally {
            I18NUtil.setLocale((Locale)originalLocale);
        }
    }

    private List<ParameterDefinition> exampleFieldList(String label) {
        ArrayList<ParameterDefinition> paramDefs = new ArrayList<ParameterDefinition>();
        paramDefs.add((ParameterDefinition)new ParameterDefinitionImpl("example-field", DataTypeDefinition.TEXT, false, label));
        return paramDefs;
    }
}

