/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail.conditions;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.FailureHandlingOptions;
import org.alfresco.repo.thumbnail.conditions.NodeEligibleForRethumbnailingEvaluator;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.thumbnail.FailedThumbnailInfo;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@Category(value={OwnJVMTestsCategory.class})
@Transactional
public class NodeEligibleForRethumbnailingEvaluatorTest
extends BaseSpringTest {
    private final QName thumbnailDef1 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"thumbDef1");
    private NodeService nodeService;
    private ThumbnailService thumbnailService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private FailureHandlingOptions failureHandlingOptions;
    private NodeRef newUnthumbnailedNodeRef;
    private NodeRef recentlyFailedNodeRef;

    @Before
    public void before() throws Exception {
        Date now = new Date();
        Date twoSecondsAgo = new Date(now.getTime() - 2000L);
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.thumbnailService = (ThumbnailService)this.applicationContext.getBean("thumbnailService");
        this.failureHandlingOptions = (FailureHandlingOptions)this.applicationContext.getBean("standardFailureOptions");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.newUnthumbnailedNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}newUnthumbnailedNodeRef"), ContentModel.TYPE_CONTENT).getChildRef();
        this.recentlyFailedNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}recentlyFailedNodeRef"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.addAspect(this.recentlyFailedNodeRef, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE, null);
        NodeRef thumbDef1FailureNode = this.nodeService.createNode(this.recentlyFailedNodeRef, ContentModel.ASSOC_FAILED_THUMBNAIL, this.thumbnailDef1, ContentModel.TYPE_FAILED_THUMBNAIL).getChildRef();
        this.nodeService.setProperty(thumbDef1FailureNode, ContentModel.PROP_FAILED_THUMBNAIL_TIME, (Serializable)twoSecondsAgo);
        this.nodeService.setProperty(thumbDef1FailureNode, ContentModel.PROP_FAILURE_COUNT, (Serializable)Integer.valueOf(1));
    }

    @After
    public void after() {
        this.nodeService.deleteStore(this.testStoreRef);
    }

    @Test
    public void testNodeWithNoFailedThumbnails() {
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "node-eligible-for-rethumbnailing-evaluator");
        condition.setParameterValue("thumbnail-definition-name", (Serializable)((Object)this.thumbnailDef1.getLocalName()));
        condition.setParameterValue("retry-period", (Serializable)Long.valueOf(0L));
        condition.setParameterValue("retry-count", (Serializable)Integer.valueOf(this.failureHandlingOptions.getRetryCount()));
        condition.setParameterValue("quiet-period", (Serializable)Long.valueOf(0L));
        condition.setParameterValue("quiet-period-retries-enabled", (Serializable)Boolean.valueOf(true));
        NodeEligibleForRethumbnailingEvaluator evaluator = (NodeEligibleForRethumbnailingEvaluator)this.applicationContext.getBean("node-eligible-for-rethumbnailing-evaluator");
        NodeEligibleForRethumbnailingEvaluatorTest.assertTrue((boolean)evaluator.evaluate((ActionCondition)condition, this.newUnthumbnailedNodeRef));
    }

    @Test
    public void testNodeWithFailedThumbnails() {
        NodeEligibleForRethumbnailingEvaluator evaluator = (NodeEligibleForRethumbnailingEvaluator)this.applicationContext.getBean("node-eligible-for-rethumbnailing-evaluator");
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "node-eligible-for-rethumbnailing-evaluator");
        condition.setParameterValue("thumbnail-definition-name", (Serializable)((Object)this.thumbnailDef1.getLocalName()));
        condition.setParameterValue("retry-period", (Serializable)Long.valueOf(this.failureHandlingOptions.getRetryPeriod() * 1000L));
        condition.setParameterValue("retry-count", (Serializable)Integer.valueOf(this.failureHandlingOptions.getRetryCount()));
        condition.setParameterValue("quiet-period", (Serializable)Long.valueOf(this.failureHandlingOptions.getQuietPeriod() * 1000L));
        condition.setParameterValue("quiet-period-retries-enabled", (Serializable)Boolean.valueOf(true));
        NodeEligibleForRethumbnailingEvaluatorTest.assertFalse((boolean)evaluator.evaluate((ActionCondition)condition, this.recentlyFailedNodeRef));
        Map failures = this.thumbnailService.getFailedThumbnails(this.recentlyFailedNodeRef);
        NodeEligibleForRethumbnailingEvaluatorTest.assertFalse((boolean)failures.isEmpty());
        FailedThumbnailInfo failedThumbnailInfo = (FailedThumbnailInfo)failures.get(this.thumbnailDef1.getLocalName());
        long timeBeforeTheLimit = new Date().getTime() - this.failureHandlingOptions.getRetryPeriod() * 1000L - 5000L;
        this.nodeService.setProperty(failedThumbnailInfo.getFailedThumbnailNode(), ContentModel.PROP_FAILED_THUMBNAIL_TIME, (Serializable)Long.valueOf(timeBeforeTheLimit));
        NodeEligibleForRethumbnailingEvaluatorTest.assertTrue((boolean)evaluator.evaluate((ActionCondition)condition, this.recentlyFailedNodeRef));
        this.nodeService.setProperty(failedThumbnailInfo.getFailedThumbnailNode(), ContentModel.PROP_FAILURE_COUNT, (Serializable)Integer.valueOf(this.failureHandlingOptions.getRetryCount()));
        NodeEligibleForRethumbnailingEvaluatorTest.assertFalse((boolean)evaluator.evaluate((ActionCondition)condition, this.recentlyFailedNodeRef));
        long timeBeforeTheLongLimit = new Date().getTime() - this.failureHandlingOptions.getQuietPeriod() * 1000L - 5000L;
        this.nodeService.setProperty(failedThumbnailInfo.getFailedThumbnailNode(), ContentModel.PROP_FAILED_THUMBNAIL_TIME, (Serializable)Long.valueOf(timeBeforeTheLongLimit));
        NodeEligibleForRethumbnailingEvaluatorTest.assertTrue((boolean)evaluator.evaluate((ActionCondition)condition, this.recentlyFailedNodeRef));
        condition.setParameterValue("quiet-period-retries-enabled", (Serializable)Boolean.valueOf(false));
        NodeEligibleForRethumbnailingEvaluatorTest.assertFalse((boolean)evaluator.evaluate((ActionCondition)condition, this.recentlyFailedNodeRef));
    }
}

