/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.filesys.repo.UserQuotaDetails;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.util.StringList;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentQuotaManager
implements QuotaManager,
Runnable {
    private static final Log logger = LogFactory.getLog(ContentQuotaManager.class);
    private static final long UserQuotaCheckInterval = 60000L;
    private static final long UserQuotaExpireInterval = 300000L;
    private DiskInterface m_filesys;
    private ContentUsageService m_usageService;
    private ContentService contentService;
    private Map<String, UserQuotaDetails> m_liveUsage;
    private Object m_liveUsageLock = new Object();
    private Thread m_thread;
    private boolean m_shutdown;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.getContentService());
        PropertyCheck.mandatory((Object)this, (String)"contentUsageService", (Object)this.m_usageService);
    }

    public final ContentUsageService getUsageService() {
        return this.m_usageService;
    }

    public final void setUsageService(ContentUsageService usageService) {
        this.m_usageService = usageService;
    }

    public long getAvailableFreeSpace() {
        long freeSpace = this.contentService.getStoreFreeSpace();
        if (freeSpace == -1L) {
            freeSpace = 0x8000000000L;
        }
        return freeSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUserTotalSpace(SrvSession sess, TreeConnection tree) {
        if (!this.m_usageService.getEnabled()) {
            return -1L;
        }
        UserQuotaDetails userQuota = this.getQuotaDetails(sess, true);
        if (userQuota != null) {
            UserQuotaDetails userQuotaDetails = userQuota;
            synchronized (userQuotaDetails) {
                return userQuota.getUserQuota();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUserFreeSpace(SrvSession sess, TreeConnection tree) {
        if (!this.m_usageService.getEnabled()) {
            return -1L;
        }
        UserQuotaDetails userQuota = this.getQuotaDetails(sess, true);
        if (userQuota != null) {
            UserQuotaDetails userQuotaDetails = userQuota;
            synchronized (userQuotaDetails) {
                return userQuota.getAvailableSpace();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateSpace(SrvSession sess, TreeConnection tree, NetworkFile file, long alloc) throws IOException {
        if (!this.m_usageService.getEnabled()) {
            return alloc;
        }
        UserQuotaDetails userQuota = this.getQuotaDetails(sess, true);
        long allowedAlloc = 0L;
        if (userQuota != null) {
            UserQuotaDetails userQuotaDetails = userQuota;
            synchronized (userQuotaDetails) {
                if (userQuota.hasUserQuota()) {
                    if (alloc > 0L && userQuota.getAvailableSpace() >= alloc) {
                        userQuota.addToCurrentUsage(alloc);
                        allowedAlloc = alloc;
                    }
                } else {
                    userQuota.addToCurrentUsage(alloc);
                    allowedAlloc = alloc;
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to allocate " + alloc + " bytes for sess " + sess.getUniqueId()));
        }
        if (allowedAlloc < alloc) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Allocation failed userQuota=" + String.valueOf(userQuota)));
            }
            throw new DiskFullException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Allocated " + alloc + " bytes, userQuota=" + String.valueOf(userQuota)));
        }
        return allowedAlloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSpace(SrvSession sess, TreeConnection tree, int fid, String path, long alloc) throws IOException {
        if (!this.m_usageService.getEnabled()) {
            return;
        }
        UserQuotaDetails userQuota = this.getQuotaDetails(sess, true);
        if (userQuota != null) {
            UserQuotaDetails userQuotaDetails = userQuota;
            synchronized (userQuotaDetails) {
                userQuota.subtractFromCurrentUsage(alloc);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Released " + alloc + " bytes, userQuota=" + String.valueOf(userQuota)));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to release " + alloc + " bytes for sess " + sess.getUniqueId()));
        }
    }

    public void startManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Start Quota Manager");
        }
        this.m_filesys = disk;
        this.m_liveUsage = new HashMap<String, UserQuotaDetails>();
        this.m_thread = new Thread(this);
        this.m_thread.setDaemon(true);
        this.m_thread.setName("ContentQuotaManagerChecker");
        this.m_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Stop Quota Manager");
        }
        Object object = this.m_liveUsageLock;
        synchronized (object) {
            this.m_liveUsage.clear();
            this.m_shutdown = true;
        }
        this.m_thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserQuotaDetails getQuotaDetails(SrvSession sess, boolean loadDetails) {
        Object object = this.m_liveUsageLock;
        synchronized (object) {
            UserQuotaDetails userQuota;
            block6: {
                userQuota = null;
                String userName = AuthenticationUtil.getFullyAuthenticatedUser();
                if (sess != null && userName != null && (userQuota = this.m_liveUsage.get(userName)) == null && loadDetails) {
                    try {
                        logger.debug((Object)"user is not in cache - load details");
                        userQuota = this.loadUsageDetails(userName);
                    }
                    catch (QuotaManagerException ex) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug((Object)"Unable to load usage details", (Throwable)ex);
                    }
                }
            }
            return userQuota;
        }
    }

    private UserQuotaDetails loadUsageDetails(String userName) throws QuotaManagerException {
        UserQuotaDetails quotaDetails = null;
        try {
            UserQuotaDetails details;
            if (userName == null || userName.length() == 0) {
                logger.debug((Object)"user name is null or empty - throw QuotaManagerException");
                throw new QuotaManagerException("No user name for client");
            }
            long userQuota = this.m_usageService.getUserQuota(userName);
            long userUsage = this.m_usageService.getUserUsage(userName);
            quotaDetails = new UserQuotaDetails(userName, userQuota);
            if (userUsage > 0L) {
                quotaDetails.setCurrentUsage(userUsage);
            }
            if ((details = this.m_liveUsage.get(userName)) != null) {
                quotaDetails = details;
            } else {
                this.m_liveUsage.put(userName, quotaDetails);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added live usage tracking " + String.valueOf(quotaDetails)));
            }
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to load usage for" + userName), (Throwable)ex);
            }
            throw new QuotaManagerException("Failed to load usage for " + userName + ", " + String.valueOf(ex));
        }
        return quotaDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Content quota manager checker thread starting");
        }
        StringList removeNameList = new StringList();
        this.m_shutdown = false;
        while (!this.m_shutdown) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.m_shutdown) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Content quota manager checker thread closing");
                }
                return;
            }
            Object object = this.m_liveUsageLock;
            synchronized (object) {
                block18: {
                    if (this.m_liveUsage != null && this.m_liveUsage.size() > 0) {
                        try {
                            UserQuotaDetails quotaDetails;
                            long checkTime = System.currentTimeMillis() - 300000L;
                            removeNameList.remoteAllStrings();
                            for (String userName : this.m_liveUsage.keySet()) {
                                UserQuotaDetails userQuotaDetails = quotaDetails = this.m_liveUsage.get(userName);
                                synchronized (userQuotaDetails) {
                                    if (quotaDetails.getLastUpdated() < checkTime) {
                                        removeNameList.addString(userName);
                                    }
                                }
                            }
                            while (removeNameList.numberOfStrings() > 0) {
                                String userName;
                                userName = removeNameList.removeStringAt(0);
                                quotaDetails = this.m_liveUsage.remove(userName);
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("Removed inactive usage tracking, " + String.valueOf(quotaDetails)));
                            }
                        }
                        catch (Exception ex) {
                            if (this.m_shutdown) break block18;
                            logger.debug((Object)ex);
                        }
                    }
                }
            }
        }
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }
}

