/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.repo.activities.feed.JobSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedTaskSplit {
    private static Log logger = LogFactory.getLog(FeedTaskSplit.class);

    public Collection<JobSettings> split(int gridSize, JobSettings splitSettings) {
        long minSequence;
        long maxSequence = splitSettings.getMaxSeq();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("split: start - gridSize = " + gridSize + ", maxSequence = " + maxSequence));
        }
        splitSettings.setMinSeq((minSequence = maxSequence - (long)splitSettings.getMaxItemsPerCycle() + 1L) >= 0L ? minSequence : 0L);
        ArrayList<JobSettings> jobs = new ArrayList<JobSettings>(gridSize);
        int maxNodeHash = splitSettings.getJobTaskNode();
        int n = 1;
        while (n <= maxNodeHash) {
            JobSettings jobSettings = splitSettings.clone();
            jobSettings.setJobTaskNode(n);
            jobs.add(jobSettings);
            ++n;
        }
        return jobs;
    }
}

