/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.attributes;

import java.io.Serializable;
import java.util.Arrays;
import org.alfresco.repo.domain.propval.PropertyUniqueConstraintViolation;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.attributes.DuplicateAttributeException;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttributeServiceImpl
implements AttributeService {
    private static final Log logger = LogFactory.getLog(AttributeServiceImpl.class);
    private PropertyValueDAO propertyValueDAO;

    public void setPropertyValueDAO(PropertyValueDAO propertyValueDAO) {
        this.propertyValueDAO = propertyValueDAO;
    }

    private Serializable[] normalizeKeys(Serializable ... keys) {
        if (keys.length < 1 || keys.length > 3) {
            ParameterCheck.mandatory((String)"keys", null);
        }
        return new Serializable[]{keys[0], keys.length > 1 ? keys[1] : null, keys.length > 2 ? keys[2] : null};
    }

    @Override
    public boolean exists(Serializable ... keys) {
        boolean exists;
        Pair<Long, Long> pair = this.propertyValueDAO.getPropertyUniqueContext((keys = this.normalizeKeys(keys))[0], keys[1], keys[2]);
        boolean bl = exists = pair != null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Check attribute exists: \n   Keys:   " + String.valueOf(Arrays.asList(keys)) + "\n   exists: " + exists));
        }
        return exists;
    }

    @Override
    public Serializable getAttribute(Serializable ... keys) {
        keys = this.normalizeKeys(keys);
        Pair<Long, Long> pair = this.propertyValueDAO.getPropertyUniqueContext(keys[0], keys[1], keys[2]);
        Serializable value = null;
        if (pair != null && pair.getSecond() != null) {
            Long valueId = (Long)pair.getSecond();
            value = this.propertyValueDAO.getPropertyById(valueId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got attribute: \n   Keys:   " + String.valueOf(Arrays.asList(keys)) + "\n   Value: " + String.valueOf(value)));
        }
        return value;
    }

    @Override
    public void getAttributes(final AttributeService.AttributeQueryCallback callback, Serializable ... keys) {
        PropertyValueDAO.PropertyUniqueContextCallback propertyUniqueContextCallback = new PropertyValueDAO.PropertyUniqueContextCallback(){
            private boolean more = true;

            @Override
            public void handle(Long id, Long valueId, Serializable[] resultKeyIds) {
                if (!this.more) {
                    return;
                }
                Serializable value = null;
                if (valueId != null) {
                    value = AttributeServiceImpl.this.propertyValueDAO.getPropertyById(valueId);
                }
                Serializable[] resultsKeyValues = new Serializable[resultKeyIds.length];
                int i = 0;
                while (i < resultKeyIds.length) {
                    if (resultKeyIds[i] != null) {
                        Pair<Long, Serializable> keyValuePair = AttributeServiceImpl.this.propertyValueDAO.getPropertyValueById((Long)resultKeyIds[i]);
                        resultsKeyValues[i] = keyValuePair != null ? (Serializable)keyValuePair.getSecond() : null;
                    }
                    ++i;
                }
                this.more = callback.handleAttribute(id, value, resultsKeyValues);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Got attribute: \n   Keys:   " + String.valueOf(Arrays.asList(resultsKeyValues)) + "\n   Value: " + String.valueOf(value)));
                }
            }
        };
        this.propertyValueDAO.getPropertyUniqueContext(propertyUniqueContextCallback, keys);
    }

    @Override
    public void setAttribute(Serializable value, Serializable ... keys) {
        Pair<Long, Long> pair = this.propertyValueDAO.getPropertyUniqueContext((keys = this.normalizeKeys(keys))[0], keys[1], keys[2]);
        if (pair == null) {
            this.propertyValueDAO.createPropertyUniqueContext(keys[0], keys[1], keys[2], value);
        } else {
            this.propertyValueDAO.updatePropertyUniqueContext(keys[0], keys[1], keys[2], value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set attribute Value: \n   Keys:   " + String.valueOf(Arrays.asList(keys)) + "\n   Value: " + String.valueOf(value)));
        }
    }

    @Override
    public void createAttribute(Serializable value, Serializable ... keys) {
        keys = this.normalizeKeys(keys);
        try {
            this.propertyValueDAO.createPropertyUniqueContext(keys[0], keys[1], keys[2], value);
        }
        catch (PropertyUniqueConstraintViolation e) {
            throw new DuplicateAttributeException(keys[0], keys[1], keys[2], (Throwable)((Object)e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created attribute: \n   Keys:   " + String.valueOf(Arrays.asList(keys)) + "\n   Value: " + String.valueOf(value)));
        }
    }

    @Override
    public void updateOrCreateAttribute(Serializable keyBefore1, Serializable keyBefore2, Serializable keyBefore3, Serializable keyAfter1, Serializable keyAfter2, Serializable keyAfter3) {
        Pair<Long, Long> pair = this.propertyValueDAO.getPropertyUniqueContext(keyBefore1, keyBefore2, keyBefore3);
        try {
            if (pair == null) {
                pair = this.propertyValueDAO.createPropertyUniqueContext(keyAfter1, keyAfter2, keyAfter3, null);
            } else {
                Long id = (Long)pair.getFirst();
                this.propertyValueDAO.updatePropertyUniqueContextKeys(id, keyAfter1, keyAfter2, keyAfter3);
            }
        }
        catch (PropertyUniqueConstraintViolation e) {
            throw new DuplicateAttributeException(keyAfter1, keyAfter2, keyAfter3, (Throwable)((Object)e));
        }
        if (logger.isDebugEnabled()) {
            Serializable[] keysBefore = this.normalizeKeys(keyBefore1, keyBefore2, keyBefore3);
            Serializable[] keysAfter = this.normalizeKeys(keyAfter1, keyAfter2, keyAfter3);
            logger.debug((Object)("Updated attribute: \n   Before:   " + String.valueOf(Arrays.asList(keysBefore)) + "\n   After:    " + String.valueOf(Arrays.asList(keysAfter))));
        }
    }

    @Override
    public void removeAttribute(Serializable ... keys) {
        keys = this.normalizeKeys(keys);
        int deleted = this.propertyValueDAO.deletePropertyUniqueContext(keys[0], keys[1], keys[2]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted attribute: \n   Keys:  " + String.valueOf(Arrays.asList(keys)) + "\n   Count: " + deleted));
        }
    }

    @Override
    public void removeAttributes(Serializable ... keys) {
        int deleted = this.propertyValueDAO.deletePropertyUniqueContext(keys);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted attributes: \n   Keys:  " + String.valueOf(Arrays.asList(keys)) + "\n   Count: " + deleted));
        }
    }
}

