/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.alfresco.repo.bulkimport.impl.FileUtils;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ImportableItem {
    protected static final Log logger = LogFactory.getLog(ImportableItem.class);
    private ContentAndMetadata headRevision = new ContentAndMetadata();
    private SortedSet<VersionedContentAndMetadata> versionEntries = null;
    private NodeRef nodeRef;
    private ImportableItem parent;
    private long numChildren = 0L;

    public boolean isValid() {
        return this.headRevision.contentFileExists() || this.headRevision.metadataFileExists() || this.hasVersionEntries();
    }

    public ContentAndMetadata getHeadRevision() {
        return this.headRevision;
    }

    public void setNodeRef(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public void clearParent() {
        --this.numChildren;
        if (this.numChildren <= 0L) {
            this.numChildren = 0L;
            this.parent = null;
        }
    }

    public void setParent(ImportableItem parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        this.parent = parent;
    }

    public ImportableItem getParent() {
        return this.parent;
    }

    public boolean hasVersionEntries() {
        return this.versionEntries != null && this.versionEntries.size() > 0;
    }

    public Set<VersionedContentAndMetadata> getVersionEntries() {
        if (this.versionEntries == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.versionEntries);
    }

    public void addVersionEntry(VersionedContentAndMetadata versionEntry) {
        if (versionEntry != null) {
            if (this.versionEntries == null) {
                this.versionEntries = new TreeSet<VersionedContentAndMetadata>();
            }
            this.versionEntries.add(versionEntry);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("HeadRevision", (Object)this.headRevision).append("Versions", this.versionEntries).toString();
    }

    public class ContentAndMetadata {
        private Path contentFile = null;
        private boolean contentFileExists = false;
        private boolean contentFileIsReadable = false;
        private FileType contentFileType = null;
        private long contentFileSize = -1L;
        private Date contentFileCreated = null;
        private Date contentFileModified = null;
        private Path metadataFile = null;
        private long metadataFileSize = -1L;

        public final Path getContentFile() {
            return this.contentFile;
        }

        public final void setContentFile(Path contentFile) {
            this.contentFile = contentFile;
            if (contentFile != null) {
                this.contentFileExists = Files.exists(contentFile, LinkOption.NOFOLLOW_LINKS);
                if (this.contentFileExists) {
                    try {
                        BasicFileAttributes attrs = Files.readAttributes(contentFile, BasicFileAttributes.class, new LinkOption[0]);
                        this.contentFileIsReadable = Files.isReadable(contentFile);
                        this.contentFileSize = attrs.size();
                        this.contentFileModified = new Date(attrs.lastModifiedTime().toMillis());
                        this.contentFileCreated = new Date(attrs.creationTime().toMillis());
                        this.contentFileType = Files.isRegularFile(contentFile, LinkOption.NOFOLLOW_LINKS) ? FileType.FILE : (Files.isDirectory(contentFile, LinkOption.NOFOLLOW_LINKS) ? FileType.DIRECTORY : FileType.OTHER);
                    }
                    catch (IOException e) {
                        logger.error((Object)("Attributes for file '" + FileUtils.getFileName(contentFile) + "' could not be read."), (Throwable)e);
                    }
                }
            }
        }

        public final boolean contentFileExists() {
            return this.contentFileExists;
        }

        public final boolean isContentFileReadable() {
            return this.contentFileIsReadable;
        }

        public final FileType getContentFileType() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file type if content file doesn't exist.");
            }
            return this.contentFileType;
        }

        public final long getContentFileSize() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file size if content file doesn't exist.");
            }
            return this.contentFileSize;
        }

        public final Date getContentFileCreatedDate() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file creation date if content file doesn't exist.");
            }
            return this.contentFileCreated;
        }

        public final Date getContentFileModifiedDate() {
            if (!this.contentFileExists()) {
                throw new IllegalStateException("Cannot determine content file modification date if content file doesn't exist.");
            }
            return this.contentFileModified;
        }

        public final boolean metadataFileExists() {
            return this.metadataFile != null;
        }

        public final Path getMetadataFile() {
            return this.metadataFile;
        }

        public final void setMetadataFile(Path metadataFile) {
            block3: {
                if (metadataFile != null && Files.exists(metadataFile, new LinkOption[0])) {
                    this.metadataFile = metadataFile;
                    try {
                        this.metadataFileSize = Files.size(metadataFile);
                    }
                    catch (IOException e) {
                        if (!logger.isWarnEnabled()) break block3;
                        logger.warn((Object)("Size for the metadata file '" + FileUtils.getFileName(metadataFile) + "' could not be retrieved."), (Throwable)e);
                    }
                }
            }
        }

        public final long getMetadataFileSize() {
            if (!this.metadataFileExists()) {
                throw new IllegalStateException("Cannot determine metadata file size if metadata file doesn't exist.");
            }
            return this.metadataFileSize;
        }

        public final int weight() {
            return (this.contentFile == null || !this.contentFileExists ? 0 : 1) + (this.metadataFile == null ? 0 : 1);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("contentFile", (Object)(this.contentFileExists ? this.contentFile : null)).append("metadatafile", (Object)this.metadataFile).toString();
        }
    }

    public static enum FileType {
        FILE,
        DIRECTORY,
        OTHER;

    }

    public class VersionedContentAndMetadata
    extends ContentAndMetadata
    implements Comparable<VersionedContentAndMetadata> {
        private int version;

        public VersionedContentAndMetadata(int version) {
            this.version = version;
        }

        public final int getVersion() {
            return this.version;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).append("version", this.version).appendSuper("").toString();
        }

        @Override
        public int compareTo(VersionedContentAndMetadata other) {
            return this.version < other.version ? -1 : (this.version == other.version ? 0 : 1);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionedContentAndMetadata)) {
                return false;
            }
            VersionedContentAndMetadata otherVCAM = (VersionedContentAndMetadata)other;
            return this.version == otherVCAM.version;
        }

        public int hashCode() {
            return this.version;
        }
    }
}

