/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event2.filter.AbstractNodeEventFilter;
import org.alfresco.service.namespace.QName;

public class NodePropertyFilter
extends AbstractNodeEventFilter {
    private static final String FILTERED_PROPERTIES = "sys:*";
    private static final Set<QName> EXCLUDED_TOP_LEVEL_PROPS = Set.of(ContentModel.PROP_NAME, ContentModel.PROP_MODIFIER, ContentModel.PROP_MODIFIED, ContentModel.PROP_CREATOR, ContentModel.PROP_CREATED, ContentModel.PROP_CONTENT);
    private static final Set<QName> ALLOWED_PROPERTIES = Set.of(ContentModel.PROP_CASCADE_TX, ContentModel.PROP_CASCADE_CRC);
    private final List<String> nodePropertiesBlackList = new ArrayList<String>();

    public NodePropertyFilter(String userConfiguredProperties) {
        this.nodePropertiesBlackList.addAll(this.parseFilterList(FILTERED_PROPERTIES));
        this.nodePropertiesBlackList.addAll(this.parseFilterList(userConfiguredProperties));
    }

    @Override
    public Set<QName> getExcludedTypes() {
        HashSet<QName> result = new HashSet<QName>(EXCLUDED_TOP_LEVEL_PROPS);
        this.nodePropertiesBlackList.forEach(nodeProperty -> {
            boolean bl = result.addAll(this.expandTypeDef((String)nodeProperty));
        });
        return result;
    }

    @Override
    public boolean isExcluded(QName qName) {
        if (qName != null && ALLOWED_PROPERTIES.contains(qName)) {
            return false;
        }
        return super.isExcluded(qName);
    }
}

