/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.ListBackedPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.CategoryServiceException;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.collections.Function;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractCategoryServiceImpl
implements CategoryService {
    static final String CATEGORY_ROOT_NODE_NOT_FOUND = "Category root node not found";
    static final String NODE_WITH_CATEGORY_ROOT_TYPE_NOT_FOUND = "Node with category_root type not found";
    protected NodeService nodeService;
    protected NodeService publicNodeService;
    protected TenantService tenantService;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected DictionaryService dictionaryService;
    protected IndexerAndSearcher indexerAndSearcher;
    protected int queryFetchSize = 5000;
    HashMap<String, String> prefixLookup = new HashMap();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPublicNodeService(NodeService publicNodeService) {
        this.publicNodeService = publicNodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    @Override
    public Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth) {
        return this.getChildren(categoryRef, mode, depth, false, (Collection<String>)null, this.queryFetchSize);
    }

    public Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth, String filter) {
        return this.getChildren(categoryRef, mode, depth, false, filter, this.queryFetchSize);
    }

    private Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth, boolean sortByName, String filter, int fetchSize) {
        Collection matchingFilter = Optional.ofNullable(filter).map(f -> "*".concat((String)f).concat("*")).map(Set::of).orElse(null);
        return this.getChildren(categoryRef, mode, depth, sortByName, matchingFilter, fetchSize);
    }

    private Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth, boolean sortByName, Collection<String> namesFilter, int fetchSize) {
        if (categoryRef == null) {
            return Collections.emptyList();
        }
        categoryRef = this.tenantService.getBaseName(categoryRef);
        try (ResultSet resultSet = null;){
            StringBuilder luceneQuery = new StringBuilder(64);
            switch (mode) {
                case ALL: {
                    luceneQuery.append("PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("*").append("\" ");
                    break;
                }
                case MEMBERS: {
                    luceneQuery.append("PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("member").append("\" ");
                    break;
                }
                case SUB_CATEGORIES: {
                    luceneQuery.append("+PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("*").append("\" ");
                    luceneQuery.append("+TYPE:\"" + String.valueOf(ContentModel.TYPE_CATEGORY) + "\"");
                }
            }
            if (CollectionUtils.isNotEmpty(namesFilter)) {
                StringJoiner filterJoiner = new StringJoiner(" OR ", " +(", ")");
                namesFilter.forEach(nameFilter -> {
                    StringJoiner stringJoiner2 = filterJoiner.add("@cm\\:name:\"" + nameFilter + "\"");
                });
                luceneQuery.append(filterJoiner);
            }
            SearchService searcher = this.indexerAndSearcher.getSearcher(categoryRef.getStoreRef(), true);
            SearchParameters searchParameters = new SearchParameters();
            resultSet = searcher.query(categoryRef.getStoreRef(), "lucene", luceneQuery.toString(), null);
            searchParameters.setLanguage("lucene");
            if (sortByName) {
                searchParameters.addSort("@" + String.valueOf(ContentModel.PROP_NAME), true);
            }
            searchParameters.setQuery(luceneQuery.toString());
            searchParameters.setLimit(-1);
            searchParameters.setMaxItems(fetchSize);
            searchParameters.setLimitBy(LimitBy.FINAL_SIZE);
            searchParameters.addStore(categoryRef.getStoreRef());
            resultSet = searcher.query(searchParameters);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
    }

    private String buildXPath(Path path) {
        StringBuilder pathBuffer = new StringBuilder(64);
        for (Path.Element element : path) {
            if (!(element instanceof Path.ChildAssocElement)) {
                throw new IndexerException("Confused path: " + String.valueOf(path));
            }
            Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
            if (cae.getRef().getParentRef() == null) continue;
            pathBuffer.append("/");
            pathBuffer.append(this.getPrefix(cae.getRef().getQName().getNamespaceURI()));
            pathBuffer.append(ISO9075.encode((String)cae.getRef().getQName().getLocalName()));
        }
        return pathBuffer.toString();
    }

    protected String getPrefix(String uri) {
        String prefix = this.prefixLookup.get(uri);
        if (prefix == null) {
            Collection prefixes = this.namespacePrefixResolver.getPrefixes(uri);
            Iterator iterator = prefixes.iterator();
            if (iterator.hasNext()) {
                String first;
                prefix = first = (String)iterator.next();
            }
            this.prefixLookup.put(uri, prefix);
        }
        if (prefix == null) {
            return "";
        }
        return prefix + ":";
    }

    private Collection<ChildAssociationRef> resultSetToChildAssocCollection(ResultSet resultSet) {
        LinkedList<ChildAssociationRef> collection = new LinkedList<ChildAssociationRef>();
        if (resultSet != null) {
            for (ResultSetRow row : resultSet) {
                try {
                    ChildAssociationRef car = this.nodeService.getPrimaryParent(row.getNodeRef());
                    collection.add(car);
                }
                catch (InvalidNodeRefException invalidNodeRefException) {}
            }
        }
        return collection;
    }

    @Override
    public Collection<ChildAssociationRef> getCategories(StoreRef storeRef, QName aspectQName, CategoryService.Depth depth) {
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectQName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, depth));
        }
        return assocs;
    }

    protected Set<NodeRef> getClassificationNodes(StoreRef storeRef, QName aspectQName) {
        try {
            return this.getRootCategoryNodeRef(storeRef, aspectQName).stream().collect(Collectors.toSet());
        }
        catch (CategoryServiceException categoryServiceException) {
            return Collections.emptySet();
        }
    }

    @Override
    public Collection<ChildAssociationRef> getClassifications(StoreRef storeRef) {
        try (ResultSet resultSet = null;){
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(storeRef, "lucene", "PATH:\"//cm:categoryRoot/*\"", null);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
    }

    @Override
    public Collection<QName> getClassificationAspects() {
        return this.dictionaryService.getSubAspects(ContentModel.ASPECT_CLASSIFIABLE, true);
    }

    @Override
    public NodeRef createClassification(StoreRef storeRef, QName typeName, String attributeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PagingResults<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, PagingRequest pagingRequest, boolean sortByName) {
        return this.getRootCategories(storeRef, aspectName, pagingRequest, sortByName, null, null);
    }

    @Override
    public PagingResults<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, PagingRequest pagingRequest, boolean sortByName, String filter) {
        Collection alikeNamesFilter = Optional.ofNullable(filter).map(f -> "*".concat((String)f).concat("*")).map(Set::of).orElse(null);
        return this.getRootCategories(storeRef, aspectName, pagingRequest, sortByName, null, alikeNamesFilter);
    }

    @Override
    public PagingResults<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, PagingRequest pagingRequest, boolean sortByName, Collection<String> exactNamesFilter, Collection<String> alikeNamesFilter) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>();
        int skipCount = pagingRequest.getSkipCount();
        int maxItems = pagingRequest.getMaxItems();
        int size = maxItems == Integer.MAX_VALUE ? Integer.MAX_VALUE : skipCount + maxItems;
        int count = 0;
        boolean moreItems = false;
        Function<NodeRef, Collection<ChildAssociationRef>> childNodesSupplier = this.getNodeRefCollectionFunction(sortByName, exactNamesFilter, alikeNamesFilter, skipCount, maxItems);
        block0: for (NodeRef nodeRef : nodeRefs) {
            Collection children = (Collection)childNodesSupplier.apply((Object)nodeRef);
            for (ChildAssociationRef child : children) {
                if (++count <= skipCount) continue;
                if (count > size) {
                    moreItems = true;
                    break block0;
                }
                associations.add(child);
            }
        }
        return new ListBackedPagingResults(associations, moreItems);
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, Collection<String> exactNamesFilter, Collection<String> alikeNamesFilter) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        LinkedList<ChildAssociationRef> associations = new LinkedList<ChildAssociationRef>();
        Function<NodeRef, Collection<ChildAssociationRef>> childNodesSupplier = this.getNodeRefCollectionFunction(false, exactNamesFilter, alikeNamesFilter, 0, 10000);
        for (NodeRef nodeRef : nodeRefs) {
            Collection children = (Collection)childNodesSupplier.apply((Object)nodeRef);
            associations.addAll(children);
        }
        return associations;
    }

    private Function<NodeRef, Collection<ChildAssociationRef>> getNodeRefCollectionFunction(boolean sortByName, Collection<String> exactNamesFilter, Collection<String> alikeNamesFilter, int skipCount, int maxItems) {
        Function childNodesSupplier = nodeRef -> {
            HashSet<ChildAssociationRef> childNodes = new HashSet<ChildAssociationRef>();
            if (CollectionUtils.isEmpty((Collection)exactNamesFilter) && CollectionUtils.isEmpty((Collection)alikeNamesFilter)) {
                childNodes.addAll(this.nodeService.getChildAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_SUBCATEGORIES, RegexQNamePattern.MATCH_ALL));
            } else {
                if (CollectionUtils.isNotEmpty((Collection)exactNamesFilter)) {
                    childNodes.addAll(this.nodeService.getChildrenByName(nodeRef, ContentModel.ASSOC_SUBCATEGORIES, exactNamesFilter));
                }
                if (CollectionUtils.isNotEmpty((Collection)alikeNamesFilter)) {
                    childNodes.addAll(this.getChildren((NodeRef)nodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE, sortByName, alikeNamesFilter, skipCount + maxItems + 1));
                }
            }
            Stream<Object> childNodesStream = childNodes.stream();
            if (sortByName) {
                childNodesStream = childNodesStream.sorted(Comparator.comparing(tag -> tag.getQName().getLocalName()));
            }
            return childNodesStream.collect(Collectors.toList());
        };
        return childNodesSupplier;
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName) {
        return this.getRootCategories(storeRef, aspectName, null);
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, String filter) {
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE, false, filter, this.queryFetchSize));
        }
        return assocs;
    }

    @Override
    public ChildAssociationRef getCategory(NodeRef parent, QName aspectName, String name) {
        String validLocalName;
        String uri = this.nodeService.getPrimaryParent(parent).getQName().getNamespaceURI();
        List assocs = this.nodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_SUBCATEGORIES, (QNamePattern)QName.createQName((String)uri, (String)(validLocalName = QName.createValidLocalName((String)name))), false);
        if (assocs.isEmpty()) {
            return null;
        }
        return (ChildAssociationRef)assocs.iterator().next();
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, String name, boolean create) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        if (nodeRefs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        for (NodeRef nodeRef : nodeRefs) {
            ChildAssociationRef category = this.getCategory(nodeRef, aspectName, name);
            if (category == null) continue;
            assocs.add(category);
        }
        if (create && assocs.isEmpty()) {
            assocs.add(this.createCategoryInternal(nodeRefs.iterator().next(), name));
        }
        return assocs;
    }

    @Override
    public NodeRef createCategory(NodeRef parent, String name) {
        return this.createCategoryInternal(parent, name).getChildRef();
    }

    private ChildAssociationRef createCategoryInternal(NodeRef parent, String name) {
        if (!this.nodeService.exists(parent)) {
            throw new AlfrescoRuntimeException("Missing category?");
        }
        String uri = this.nodeService.getPrimaryParent(parent).getQName().getNamespaceURI();
        String validLocalName = QName.createValidLocalName((String)name);
        ChildAssociationRef newCategory = this.publicNodeService.createNode(parent, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)uri, (String)validLocalName), ContentModel.TYPE_CATEGORY);
        this.publicNodeService.setProperty(newCategory.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)name));
        return newCategory;
    }

    @Override
    public NodeRef createRootCategory(StoreRef storeRef, QName aspectName, String name) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        if (nodeRefs.size() == 0) {
            throw new AlfrescoRuntimeException("Missing classification: " + String.valueOf(aspectName));
        }
        NodeRef parent = nodeRefs.iterator().next();
        return this.createCategory(parent, name);
    }

    @Override
    public void deleteCategory(NodeRef nodeRef) {
        this.publicNodeService.deleteNode(nodeRef);
    }

    @Override
    public void deleteClassification(StoreRef storeRef, QName aspectName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract List<Pair<NodeRef, Integer>> getTopCategories(StoreRef var1, QName var2, int var3);

    protected SearchParameters createSearchTopCategoriesParameters(StoreRef storeRef, QName aspectName, int count) {
        AspectDefinition aspectDefinition = this.dictionaryService.getAspect(aspectName);
        if (aspectDefinition == null) {
            throw new IllegalStateException("Unknown aspect");
        }
        Map aspectProperties = aspectDefinition.getProperties();
        Optional<QName> catProperty = aspectProperties.entrySet().stream().filter(ap -> ContentModel.ASPECT_GEN_CLASSIFIABLE.isMatch(aspectName) || this.isValidCategoryTypeProperty(aspectName, (Map.Entry<QName, PropertyDefinition>)ap)).map(Map.Entry::getKey).findFirst();
        return catProperty.map(cp -> {
            String field = "@" + String.valueOf(cp);
            SearchParameters sp = new SearchParameters();
            sp.addStore(storeRef);
            sp.setQuery(String.valueOf(cp) + ":*");
            sp.setMaxItems(1);
            sp.setSkipCount(0);
            SearchParameters.FieldFacet ff = new SearchParameters.FieldFacet(field);
            ff.setLimitOrNull(count < 0 ? null : Integer.valueOf(count));
            sp.addFieldFacet(ff);
            return sp;
        }).orElseThrow(() -> new IllegalStateException("Aspect does not have category property mirroring the aspect name"));
    }

    private boolean isValidCategoryTypeProperty(QName aspectName, Map.Entry<QName, PropertyDefinition> propertyDef) {
        return propertyDef.getKey().getNamespaceURI().equals(aspectName.getNamespaceURI()) && propertyDef.getKey().getLocalName().equals(aspectName.getLocalName()) && DataTypeDefinition.CATEGORY.equals((Object)propertyDef.getValue().getDataType().getName());
    }

    @Override
    public Optional<NodeRef> getRootCategoryNodeRef(StoreRef storeRef) {
        return this.getRootCategoryNodeRef(storeRef, ContentModel.ASPECT_GEN_CLASSIFIABLE);
    }

    private Optional<NodeRef> getRootCategoryNodeRef(StoreRef storeRef, QName childNodeType) {
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        ChildAssociationRef categoryRoot = (ChildAssociationRef)this.nodeService.getChildAssocs(rootNode, Set.of(ContentModel.TYPE_CATEGORYROOT)).stream().findFirst().orElseThrow(() -> new CategoryServiceException(NODE_WITH_CATEGORY_ROOT_TYPE_NOT_FOUND));
        List categoryRootAssocs = this.nodeService.getChildAssocs(categoryRoot.getChildRef());
        if (CollectionUtils.isEmpty((Collection)categoryRootAssocs)) {
            throw new CategoryServiceException(CATEGORY_ROOT_NODE_NOT_FOUND);
        }
        return categoryRootAssocs.stream().filter(ca -> ca.getQName().equals((Object)childNodeType)).map(ChildAssociationRef::getChildRef).findFirst();
    }
}

