/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Collections;
import java.util.List;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.NumericPathHasher;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.ProtocolHashParser;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.ref.ReferenceParser;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.util.Pair;

public class VirtualHashReferenceParser
extends ProtocolHashParser {
    private String protocolCode;
    private NumericPathHasher numericPathHasher = new NumericPathHasher();

    public VirtualHashReferenceParser(HashStore classpathHashStore) {
        this(classpathHashStore, "2");
    }

    public VirtualHashReferenceParser(HashStore classpathHashStore, String protocolCode) {
        super(classpathHashStore);
        this.protocolCode = protocolCode;
    }

    @Override
    public Reference parse(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        String templatePath;
        if (!this.protocolCode.equals(cursor.currentToken())) {
            throw new ReferenceParseException("Node token \"" + this.protocolCode + "\" expected instead of \"" + cursor.currentToken() + "\"");
        }
        ++cursor.i;
        Resource templateResource = this.parseResource(cursor);
        Resource actualNodeResource = this.parseResource(cursor);
        String pathToken = cursor.nextToken();
        String pathCode = pathToken.substring(0, 1);
        if ("3".equals(pathCode)) {
            String pathHash = pathToken.substring(1);
            templatePath = this.numericPathHasher.lookup((Pair<String, String>)new Pair((Object)pathHash, null));
        } else if ("1".equals(pathCode)) {
            templatePath = "/";
        } else if ("2".equals(pathCode)) {
            String pathNonHashed = pathToken.substring(1);
            templatePath = this.numericPathHasher.lookup((Pair<String, String>)new Pair(null, (Object)pathNonHashed));
        } else if ("4".equals(pathCode)) {
            String pathHash = pathToken.substring(1);
            String pathNonHashed = cursor.nextToken();
            templatePath = this.numericPathHasher.lookup((Pair<String, String>)new Pair((Object)pathHash, (Object)pathNonHashed));
        } else {
            throw new ReferenceParseException("Pnvalid path token code " + pathCode);
        }
        return this.parseVirtualExtension(cursor, templateResource, templatePath, actualNodeResource);
    }

    protected Reference parseVirtualExtension(ReferenceParser.Cursor c, Resource templateResource, String templatePath, Resource actualNodeResource) {
        List<Parameter> extraParameters = Collections.emptyList();
        return ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(Encodings.HASH.encoding, templateResource, templatePath, actualNodeResource, extraParameters);
    }
}

