/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityType;

public class WorkflowAuthorityManager {
    private final AuthorityDAO authorityDAO;

    public WorkflowAuthorityManager(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public String mapAuthorityToName(NodeRef authority) {
        return this.authorityDAO.getAuthorityName(authority);
    }

    public NodeRef mapNameToAuthority(String name) {
        NodeRef authority = null;
        if (name != null) {
            authority = this.authorityDAO.getAuthorityNodeRefOrNull(name);
        }
        return authority;
    }

    public boolean isUser(String authorityName) {
        AuthorityType type = AuthorityType.getAuthorityType((String)authorityName);
        return type == AuthorityType.USER || type == AuthorityType.ADMIN || type == AuthorityType.GUEST;
    }

    public String getAuthorityName(NodeRef authorityRef) {
        return this.authorityDAO.getAuthorityName(authorityRef);
    }
}

