/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.admin.RepoServerMgmtMBean;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionsUsageDataCollector
extends HBBaseDataCollector {
    private static final Log logger = LogFactory.getLog(SessionsUsageDataCollector.class);
    private DescriptorDAO currentRepoDescriptorDAO;
    private RepoServerMgmtMBean repoServerMgmt;

    public SessionsUsageDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        super(collectorId, collectorVersion, cronExpression, hbJobScheduler);
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setRepoServerMgmt(RepoServerMgmtMBean repoServerMgmt) {
        this.repoServerMgmt = repoServerMgmt;
    }

    @Override
    public List<HBData> collectData() {
        HashMap<String, Integer> sessionValues = new HashMap<String, Integer>();
        sessionValues.put("activeTickets", this.repoServerMgmt.getTicketCountNonExpired());
        HBData sessionsData = new HBData(this.currentRepoDescriptorDAO.getDescriptor().getId(), this.getCollectorId(), this.getCollectorVersion(), new Date(), sessionValues);
        return Arrays.asList(sessionsData);
    }
}

