/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.mapper;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.alfresco.repo.event2.mapper.PropertyMapper;
import org.alfresco.repo.event2.mapper.ReplaceSensitivePropertyWithTextMapper;
import org.alfresco.repo.event2.shared.CSVStringToListParser;
import org.alfresco.repo.event2.shared.TypeDefExpander;
import org.alfresco.service.namespace.QName;

public class PropertyMapperFactory {
    private final TypeDefExpander typeDefExpander;

    public PropertyMapperFactory(TypeDefExpander typeDefExpander) {
        this.typeDefExpander = typeDefExpander;
    }

    public PropertyMapper createPropertyMapper(String enabled, String userConfiguredSensitiveProperties, String userConfiguredReplacementText) {
        if ("false".equalsIgnoreCase(enabled)) {
            return PropertyMapper.NO_OP;
        }
        Set<QName> sensitiveProperties = Optional.ofNullable(userConfiguredSensitiveProperties).filter(Predicate.not(String::isEmpty)).map(CSVStringToListParser::parse).map(this.typeDefExpander::expand).orElse(Set.of());
        return new ReplaceSensitivePropertyWithTextMapper(sensitiveProperties, userConfiguredReplacementText);
    }
}

