/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.alfresco.repo.content.ContentStoreCaps;
import org.alfresco.repo.management.subsystems.SubsystemProxyFactory;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.tenant.TenantRoutingContentStore;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public class CryptodocSubsystemProxyFactory
extends SubsystemProxyFactory {
    private static final long serialVersionUID = 1L;

    public CryptodocSubsystemProxyFactory() {
        this.addAdvisor(0, (Advisor)new DefaultPointcutAdvisor((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation mi) throws Throwable {
                Method method = mi.getMethod();
                try {
                    switch (method.getName()) {
                        case "getTenantRoutingContentStore": {
                            return this.getTenantRoutingContentStore(mi);
                        }
                        case "getTenantDeployer": {
                            return this.getTenantDeployer(mi);
                        }
                    }
                    return mi.proceed();
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }

            private TenantDeployer getTenantDeployer(MethodInvocation mi) {
                TenantDeployer ten;
                Object bean = CryptodocSubsystemProxyFactory.this.locateBean(mi);
                if (bean instanceof TenantDeployer) {
                    return (TenantDeployer)bean;
                }
                if (bean instanceof ContentStoreCaps && (ten = ((ContentStoreCaps)bean).getTenantDeployer()) instanceof TenantDeployer) {
                    return ten;
                }
                return null;
            }

            private TenantRoutingContentStore getTenantRoutingContentStore(MethodInvocation mi) {
                TenantDeployer ten;
                Object bean = CryptodocSubsystemProxyFactory.this.locateBean(mi);
                if (bean instanceof TenantRoutingContentStore) {
                    return (TenantRoutingContentStore)bean;
                }
                if (bean instanceof ContentStoreCaps && (ten = ((ContentStoreCaps)bean).getTenantRoutingContentStore()) instanceof TenantRoutingContentStore) {
                    return (TenantRoutingContentStore)ten;
                }
                return null;
            }
        }));
    }
}

