/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryParams;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;

public class GetChildrenCannedQuery
extends org.alfresco.repo.node.getchildren.GetChildrenCannedQuery {
    private HiddenAspect hiddenAspect;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private Set<QName> ignoreAspectQNames;

    public GetChildrenCannedQuery(NodeDAO nodeDAO, QNameDAO qnameDAO, CannedQueryDAO cannedQueryDAO, NodePropertyHelper nodePropertyHelper, TenantService tenantService, NodeService nodeService, MethodSecurityBean<NodeRef> methodSecurity, CannedQueryParameters params, HiddenAspect hiddenAspect, DictionaryService dictionaryService, Set<QName> ignoreAspectQNames) {
        super(nodeDAO, qnameDAO, cannedQueryDAO, nodePropertyHelper, tenantService, nodeService, methodSecurity, params);
        this.hiddenAspect = hiddenAspect;
        this.dictionaryService = dictionaryService;
        this.nodeService = nodeService;
        this.ignoreAspectQNames = ignoreAspectQNames;
    }

    @Override
    protected GetChildrenCannedQuery.UnsortedChildQueryCallback getUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount, GetChildrenCannedQueryParams paramBean) {
        Set<QName> inclusiveAspects = paramBean.getInclusiveAspects();
        Set<QName> exclusiveAspects = paramBean.getExclusiveAspects();
        FileFolderUnsortedChildQueryCallback callback = new FileFolderUnsortedChildQueryCallback(rawResult, requestedCount, inclusiveAspects, exclusiveAspects);
        return callback;
    }

    @Override
    protected GetChildrenCannedQuery.FilterSortChildQueryCallback getFilterSortChildQuery(List<GetChildrenCannedQuery.FilterSortNode> children, List<FilterProp> filterProps, GetChildrenCannedQueryParams paramBean) {
        FileFolderFilterSortChildQueryCallback callback = new FileFolderFilterSortChildQueryCallback(children, filterProps);
        return callback;
    }

    protected boolean includeImpl(boolean ret, NodeRef nodeRef) {
        try {
            if (!this.nodeService.exists(nodeRef)) {
                return ret;
            }
            FileFilterMode.Client client = FileFilterMode.getClient();
            boolean notHidden = this.hiddenAspect.getVisibility(client, nodeRef) != HiddenAspect.Visibility.NotVisible;
            boolean notIgnore = true;
            if (this.ignoreAspectQNames != null) {
                if (this.ignoreAspectQNames.size() > 1) {
                    Set nodeAspects = this.nodeService.getAspects(nodeRef);
                    notIgnore = !nodeAspects.removeAll(this.ignoreAspectQNames);
                } else if (this.ignoreAspectQNames.size() == 1 && this.nodeService.hasAspect(nodeRef, this.ignoreAspectQNames.iterator().next())) {
                    notIgnore = false;
                }
            }
            return ret && notHidden && notIgnore;
        }
        catch (AccessDeniedException accessDeniedException) {
            return ret;
        }
    }

    private class FileFolderFilterSortChildQueryCallback
    extends GetChildrenCannedQuery.DefaultFilterSortChildQueryCallback {
        private Map<QName, Boolean> isTypeFolderMap;

        public FileFolderFilterSortChildQueryCallback(List<GetChildrenCannedQuery.FilterSortNode> children, List<FilterProp> filterProps) {
            super(GetChildrenCannedQuery.this, children, filterProps);
            this.isTypeFolderMap = new HashMap<QName, Boolean>(10);
        }

        @Override
        protected boolean include(GetChildrenCannedQuery.FilterSortNode node) {
            boolean ret = super.include(node);
            return ret && GetChildrenCannedQuery.this.includeImpl(ret, node.getNodeRef());
        }

        @Override
        public boolean handle(GetChildrenCannedQuery.FilterSortNode node) {
            super.handle(node);
            Map<QName, Serializable> propVals = node.getPropVals();
            QName nodeTypeQName = (QName)propVals.get(org.alfresco.repo.node.getchildren.GetChildrenCannedQuery.SORT_QNAME_NODE_TYPE);
            if (nodeTypeQName != null) {
                Boolean isFolder = this.isTypeFolderMap.get(nodeTypeQName);
                if (isFolder == null) {
                    isFolder = GetChildrenCannedQuery.this.dictionaryService.isSubClass(nodeTypeQName, ContentModel.TYPE_FOLDER);
                    this.isTypeFolderMap.put(nodeTypeQName, isFolder);
                }
                propVals.put(org.alfresco.repo.node.getchildren.GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER, isFolder);
            }
            return true;
        }
    }

    private class FileFolderUnsortedChildQueryCallback
    extends GetChildrenCannedQuery.DefaultUnsortedChildQueryCallback {
        public FileFolderUnsortedChildQueryCallback(List<NodeRef> rawResult, int requestedCount, Set<QName> inclusiveAspects, Set<QName> exclusiveAspects) {
            super(GetChildrenCannedQuery.this, rawResult, requestedCount, inclusiveAspects, exclusiveAspects);
        }

        @Override
        protected boolean include(NodeRef nodeRef) {
            boolean ret = super.include(nodeRef);
            return ret && GetChildrenCannedQuery.this.includeImpl(ret, nodeRef);
        }
    }
}

