/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.oauth2;

import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.remotecredentials.OAuth2CredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.RemoteCredentialsModel;
import org.alfresco.service.cmr.oauth2.OAuth2CredentialsStoreService;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.OAuth2CredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.RemoteCredentialsService;
import org.alfresco.service.cmr.remoteticket.NoSuchSystemException;

public class OAuth2CredentialsStoreServiceImpl
implements OAuth2CredentialsStoreService {
    private RemoteCredentialsService remoteCredentialsService;

    public void setRemoteCredentialsService(RemoteCredentialsService remoteCredentialsService) {
        this.remoteCredentialsService = remoteCredentialsService;
    }

    @Override
    public OAuth2CredentialsInfo storePersonalOAuth2Credentials(String remoteSystemId, String accessToken, String refreshToken, Date expiresAt, Date issuedAt) throws NoSuchSystemException {
        OAuth2CredentialsInfo credentials = this.buildPersonalOAuth2CredentialsInfo(remoteSystemId, accessToken, refreshToken, expiresAt, issuedAt);
        if (credentials.getNodeRef() != null) {
            return (OAuth2CredentialsInfo)this.remoteCredentialsService.updateCredentials(credentials);
        }
        return (OAuth2CredentialsInfo)this.remoteCredentialsService.createPersonCredentials(remoteSystemId, credentials);
    }

    @Override
    public OAuth2CredentialsInfo storeSharedOAuth2Credentials(String remoteSystemId, String accessToken, String refreshToken, Date expiresAt, Date issuedAt) throws NoSuchSystemException {
        OAuth2CredentialsInfo credentials = this.buildSharedOAuth2CredentialsInfo(remoteSystemId, accessToken, refreshToken, expiresAt, issuedAt);
        return (OAuth2CredentialsInfo)this.remoteCredentialsService.createSharedCredentials(remoteSystemId, credentials);
    }

    @Override
    public OAuth2CredentialsInfo updateSharedOAuth2Credentials(OAuth2CredentialsInfo exisitingCredentials, String remoteSystemId, String accessToken, String refreshToken, Date expiresAt, Date issuedAt) throws NoSuchSystemException {
        List<OAuth2CredentialsInfo> shared = this.listSharedOAuth2Credentials(remoteSystemId);
        for (OAuth2CredentialsInfo credential : shared) {
            if (!credential.getNodeRef().equals((Object)exisitingCredentials.getNodeRef())) continue;
            OAuth2CredentialsInfoImpl credentials = new OAuth2CredentialsInfoImpl(exisitingCredentials.getNodeRef(), exisitingCredentials.getRemoteSystemName(), exisitingCredentials.getRemoteSystemContainerNodeRef());
            credentials.setOauthAccessToken(accessToken);
            credentials.setOauthRefreshToken(refreshToken);
            credentials.setOauthTokenExpiresAt(expiresAt);
            if (issuedAt != null) {
                credentials.setOauthTokenIssuedAt(issuedAt);
            } else {
                credentials.setOauthTokenIssuedAt(new Date());
            }
            return (OAuth2CredentialsInfo)this.remoteCredentialsService.updateCredentials(credentials);
        }
        throw new AlfrescoRuntimeException("Cannot update Credentials which haven't been persisted yet!");
    }

    private OAuth2CredentialsInfo buildPersonalOAuth2CredentialsInfo(String remoteSystemId, String accessToken, String refreshToken, Date expiresAt, Date issuedAt) {
        OAuth2CredentialsInfoImpl credentials = new OAuth2CredentialsInfoImpl();
        OAuth2CredentialsInfoImpl existing = (OAuth2CredentialsInfoImpl)this.getPersonalOAuth2Credentials(remoteSystemId);
        if (existing != null) {
            credentials = existing;
        }
        credentials.setOauthAccessToken(accessToken);
        credentials.setOauthRefreshToken(refreshToken);
        credentials.setOauthTokenExpiresAt(expiresAt);
        if (issuedAt != null) {
            credentials.setOauthTokenIssuedAt(issuedAt);
        } else {
            credentials.setOauthTokenIssuedAt(new Date());
        }
        return credentials;
    }

    private OAuth2CredentialsInfo buildSharedOAuth2CredentialsInfo(String remoteSystemId, String accessToken, String refreshToken, Date expiresAt, Date issuedAt) {
        OAuth2CredentialsInfoImpl credentials = new OAuth2CredentialsInfoImpl();
        credentials.setOauthAccessToken(accessToken);
        credentials.setOauthRefreshToken(refreshToken);
        credentials.setOauthTokenExpiresAt(expiresAt);
        if (issuedAt != null) {
            credentials.setOauthTokenIssuedAt(issuedAt);
        } else {
            credentials.setOauthTokenIssuedAt(new Date());
        }
        return credentials;
    }

    @Override
    public OAuth2CredentialsInfo getPersonalOAuth2Credentials(String remoteSystemId) throws NoSuchSystemException {
        return (OAuth2CredentialsInfo)this.remoteCredentialsService.getPersonCredentials(remoteSystemId);
    }

    @Override
    public List<OAuth2CredentialsInfo> listSharedOAuth2Credentials(String remoteSystemId) throws NoSuchSystemException {
        PagingRequest paging = new PagingRequest(Integer.MAX_VALUE);
        PagingResults<? extends BaseCredentialsInfo> pagingResults = this.remoteCredentialsService.listSharedCredentials(remoteSystemId, RemoteCredentialsModel.TYPE_OAUTH2_CREDENTIALS, paging);
        return pagingResults.getPage();
    }

    @Override
    public boolean deletePersonalOAuth2Credentials(String remoteSystemId) throws NoSuchSystemException {
        OAuth2CredentialsInfo credentials = this.getPersonalOAuth2Credentials(remoteSystemId);
        if (credentials == null) {
            return false;
        }
        this.remoteCredentialsService.deleteCredentials(credentials);
        return true;
    }

    @Override
    public boolean deleteSharedOAuth2Credentials(String remoteSystemId, OAuth2CredentialsInfo credentials) throws NoSuchSystemException {
        List<OAuth2CredentialsInfo> shared = this.listSharedOAuth2Credentials(remoteSystemId);
        if (shared.isEmpty()) {
            return false;
        }
        for (OAuth2CredentialsInfo credential : shared) {
            if (credential.getNodeRef().equals((Object)credentials.getNodeRef())) {
                this.remoteCredentialsService.deleteCredentials(credential);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public OAuth2CredentialsInfo updateCredentialsAuthenticationSucceeded(boolean succeeded, OAuth2CredentialsInfo credentials) {
        return (OAuth2CredentialsInfo)this.remoteCredentialsService.updateCredentialsAuthenticationSucceeded(succeeded, credentials);
    }
}

