/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy.annotation;

import java.lang.reflect.Method;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.policy.annotation.BehaviourRegistry;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class AnnotatedBehaviourPostProcessor
implements BeanPostProcessor {
    private static Log logger = LogFactory.getLog(AnnotatedBehaviourPostProcessor.class);
    private PolicyComponent policyComponent;
    private NamespaceService namespaceService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        this.registerBehaviours(bean, beanName);
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    private void registerBehaviours(Object bean, String beanName) {
        if (bean.getClass().isAnnotationPresent(BehaviourBean.class)) {
            Method[] methods;
            BehaviourBean behaviourBean = bean.getClass().getAnnotation(BehaviourBean.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Annotated behaviour post processing for " + beanName));
            }
            Method[] methodArray = methods = bean.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(org.alfresco.repo.policy.annotation.Behaviour.class)) {
                    this.registerBehaviour(behaviourBean, bean, beanName, method);
                }
                ++n2;
            }
        }
    }

    private void registerBehaviour(BehaviourBean behaviourBean, Object bean, String beanName, Method method) {
        org.alfresco.repo.policy.annotation.Behaviour behaviour = method.getAnnotation(org.alfresco.repo.policy.annotation.Behaviour.class);
        QName policy = this.resolvePolicy(behaviour.policy(), method);
        QName type = this.resolveType(behaviourBean, behaviour);
        ParameterCheck.mandatory((String)"policy", (Object)policy);
        if (!behaviour.isService()) {
            ParameterCheck.mandatory((String)"type", (Object)type);
        }
        if (logger.isDebugEnabled()) {
            if (!behaviour.isService()) {
                logger.debug((Object)("   ... binding " + String.valueOf((Object)behaviour.kind()) + " behaviour for " + beanName + "." + method.getName() + " for policy " + policy.toString() + " and type " + type.toString()));
            } else {
                logger.debug((Object)("   ... binding " + String.valueOf((Object)behaviour.kind()) + " service behaviour for " + beanName + "." + method.getName() + " for policy " + policy.toString()));
            }
        }
        JavaBehaviour javaBehaviour = new JavaBehaviour(bean, method.getName(), behaviour.notificationFrequency());
        if (bean instanceof BehaviourRegistry && !behaviour.name().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("   ... adding behaviour to registry with name " + behaviour.name()));
            }
            ((BehaviourRegistry)bean).registerBehaviour(behaviour.name(), javaBehaviour);
        }
        if (BehaviourKind.CLASS.equals((Object)behaviour.kind())) {
            if (!behaviour.isService()) {
                this.policyComponent.bindClassBehaviour(policy, type, (Behaviour)javaBehaviour);
            } else {
                this.policyComponent.bindClassBehaviour(policy, bean, (Behaviour)javaBehaviour);
            }
        } else if (BehaviourKind.ASSOCIATION.equals((Object)behaviour.kind())) {
            if (!behaviour.isService()) {
                this.policyComponent.bindAssociationBehaviour(policy, type, this.toQName(behaviour.assocType()), javaBehaviour);
            } else {
                this.policyComponent.bindAssociationBehaviour(policy, bean, (Behaviour)javaBehaviour);
            }
        }
    }

    private QName resolvePolicy(String policyName, Method method) {
        QName policy = null;
        policy = policyName.isEmpty() ? QName.createQName((String)"http://www.alfresco.org", (String)method.getName()) : this.toQName(policyName);
        return policy;
    }

    private QName resolveType(BehaviourBean behaviourBean, org.alfresco.repo.policy.annotation.Behaviour behaviour) {
        QName type = null;
        if (!behaviour.isService()) {
            type = behaviour.type().isEmpty() ? this.toQName(behaviourBean.defaultType()) : this.toQName(behaviour.type());
        }
        return type;
    }

    private QName toQName(String name) {
        return QName.createQName((String)name, (NamespacePrefixResolver)this.namespaceService);
    }
}

