/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowDefinition;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowInstance;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowTask;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.mozilla.javascript.Scriptable;

public class WorkflowManager
extends BaseScopableProcessorExtension {
    private int maxGroupReviewers = 0;
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setMaxGroupReviewers(int maxGroupReviewers) {
        this.maxGroupReviewers = maxGroupReviewers;
    }

    public int getMaxGroupReviewers() {
        return this.maxGroupReviewers;
    }

    public JscriptWorkflowDefinition getDefinition(String id) {
        WorkflowDefinition definition = this.services.getWorkflowService().getDefinitionById(id);
        return definition == null ? null : new JscriptWorkflowDefinition(definition, this.services, this.getScope());
    }

    public JscriptWorkflowDefinition getDefinitionByName(String name) {
        WorkflowDefinition cmrWorkflowDefinition = this.services.getWorkflowService().getDefinitionByName(name);
        return cmrWorkflowDefinition == null ? null : new JscriptWorkflowDefinition(cmrWorkflowDefinition, this.services, this.getScope());
    }

    public Scriptable getAssignedTasks() {
        return this.getAssignedTasksByState(WorkflowTaskState.IN_PROGRESS);
    }

    public Scriptable getCompletedTasks() {
        return this.getAssignedTasksByState(WorkflowTaskState.COMPLETED);
    }

    public JscriptWorkflowInstance getInstance(String workflowInstanceID) {
        WorkflowInstance instance = this.services.getWorkflowService().getWorkflowById(workflowInstanceID);
        return instance == null ? null : new JscriptWorkflowInstance(instance, this.services, this.getScope());
    }

    public Scriptable getPooledTasks(String authority) {
        List<WorkflowTask> cmrPooledTasks = this.services.getWorkflowService().getPooledTasks(authority);
        ArrayList<JscriptWorkflowTask> pooledTasks = new ArrayList<JscriptWorkflowTask>();
        for (WorkflowTask cmrPooledTask : cmrPooledTasks) {
            pooledTasks.add(new JscriptWorkflowTask(cmrPooledTask, this.services, this.getScope()));
        }
        ValueConverter converter = new ValueConverter();
        return (Scriptable)converter.convertValueForScript(this.services, this.getScope(), null, pooledTasks);
    }

    public JscriptWorkflowTask getTask(String id) {
        WorkflowTask task = this.services.getWorkflowService().getTaskById(id);
        return task == null ? null : new JscriptWorkflowTask(task, this.services, this.getScope());
    }

    public JscriptWorkflowTask getTaskById(String id) {
        return this.getTask(id);
    }

    public Scriptable getLatestDefinitions() {
        List<WorkflowDefinition> cmrDefinitions = this.services.getWorkflowService().getDefinitions();
        ArrayList<JscriptWorkflowDefinition> workflowDefs = new ArrayList<JscriptWorkflowDefinition>();
        for (WorkflowDefinition cmrDefinition : cmrDefinitions) {
            workflowDefs.add(new JscriptWorkflowDefinition(cmrDefinition, this.services, this.getScope()));
        }
        return (Scriptable)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, workflowDefs);
    }

    public Scriptable getAllDefinitions() {
        List<WorkflowDefinition> cmrDefinitions = this.services.getWorkflowService().getAllDefinitions();
        ArrayList<JscriptWorkflowDefinition> workflowDefs = new ArrayList<JscriptWorkflowDefinition>();
        for (WorkflowDefinition cmrDefinition : cmrDefinitions) {
            workflowDefs.add(new JscriptWorkflowDefinition(cmrDefinition, this.services, this.getScope()));
        }
        return (Scriptable)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, workflowDefs);
    }

    public ScriptNode createPackage() {
        NodeRef node = this.services.getWorkflowService().createPackage(null);
        return new ScriptNode(node, this.services, this.getScope());
    }

    private Scriptable getAssignedTasksByState(WorkflowTaskState state) {
        WorkflowService workflowService = this.services.getWorkflowService();
        String currentUser = this.services.getAuthenticationService().getCurrentUserName();
        List<WorkflowTask> cmrAssignedTasks = workflowService.getAssignedTasks(currentUser, state);
        ArrayList<JscriptWorkflowTask> assignedTasks = new ArrayList<JscriptWorkflowTask>();
        for (WorkflowTask cmrTask : cmrAssignedTasks) {
            assignedTasks.add(new JscriptWorkflowTask(cmrTask, this.services, this.getScope()));
        }
        return (Scriptable)new ValueConverter().convertValueForScript(this.services, this.getScope(), null, assignedTasks);
    }
}

