/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.LockedException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationContextImpl
implements AuthenticationContext {
    private final Log logger = LogFactory.getLog(this.getClass());
    private TenantService tenantService;
    private PersonService personService;
    private AuthenticationService authenticationService;
    private Boolean allowImmutableEnabledUpdate;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAllowImmutableEnabledUpdate(Boolean allowImmutableEnabledUpdate) {
        this.allowImmutableEnabledUpdate = allowImmutableEnabledUpdate;
    }

    @Override
    public Authentication setUserDetails(UserDetails ud) {
        String userId = ud.getUsername();
        try {
            if (this.isDisabled(userId, ud)) {
                throw new DisabledException("User is disabled");
            }
            if (!ud.isAccountNonExpired()) {
                throw new AccountExpiredException("User account has expired");
            }
            if (!ud.isAccountNonLocked()) {
                throw new LockedException("User account is locked");
            }
            if (!ud.isCredentialsNonExpired()) {
                throw new CredentialsExpiredException("User credentials have expired");
            }
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)ud, (Object)"", ud.getAuthorities());
            auth.setDetails((Object)ud);
            auth.setAuthenticated(true);
            Authentication authentication = this.setCurrentAuthentication((Authentication)auth);
            return authentication;
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(ae.getMessage());
                sb.append(" [");
                sb.append(AuthenticationUtil.maskUsername((String)userId));
                sb.append("] - cannot set details for user");
                this.logger.warn((Object)sb.toString());
            }
            throw new AuthenticationException(ae.getMessage(), (Throwable)ae);
        }
        finally {
            AuthenticationUtil.logNDC((String)ud.getUsername());
        }
    }

    private boolean isDisabled(String userId, UserDetails ud) {
        boolean isDisabled;
        block3: {
            isDisabled = !ud.isEnabled();
            boolean isSystemUser = this.isSystemUserName(userId);
            if (this.allowImmutableEnabledUpdate.booleanValue() && !isSystemUser) {
                try {
                    boolean isImmutable = this.isImmutableAuthority(userId);
                    boolean isPersonEnabled = this.personService.isEnabled(userId);
                    isDisabled = isDisabled || isImmutable && !isPersonEnabled;
                }
                catch (Exception exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn((Object)("Failed to determine if person is enabled: " + userId + ", using user details status: " + isDisabled));
                }
            }
        }
        return isDisabled;
    }

    private boolean isImmutableAuthority(final String authorityName) {
        return (Boolean)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                MutableAuthenticationService mutableAuthenticationService = (MutableAuthenticationService)AuthenticationContextImpl.this.authenticationService;
                return !mutableAuthenticationService.isAuthenticationMutable(authorityName);
            }
        });
    }

    @Override
    public Authentication setSystemUserAsCurrentUser() {
        return this.setSystemUserAsCurrentUser("");
    }

    @Override
    public Authentication setSystemUserAsCurrentUser(String tenantDomain) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM")};
        return this.setUserDetails((UserDetails)new User(this.getSystemUserName(tenantDomain), "", true, true, true, true, gas));
    }

    @Override
    public String getSystemUserName() {
        return "System";
    }

    @Override
    public String getSystemUserName(String tenantDomain) {
        return this.tenantService.getDomainUser(this.getSystemUserName(), tenantDomain);
    }

    @Override
    public boolean isSystemUserName(String userName) {
        return this.getSystemUserName().equals(this.tenantService.getBaseNameUser(userName));
    }

    @Override
    public boolean isCurrentUserTheSystemUser() {
        return this.isSystemUserName(this.getCurrentUserName());
    }

    @Override
    public String getGuestUserName(String tenantDomain) {
        return this.tenantService.getDomainUser(this.getGuestUserName(), tenantDomain);
    }

    @Override
    public String getGuestUserName() {
        return AuthenticationUtil.getGuestUserName();
    }

    @Override
    public boolean isGuestUserName(String userName) {
        return AuthenticationUtil.getGuestUserName().equalsIgnoreCase(this.tenantService.getBaseNameUser(userName));
    }

    @Override
    public Authentication setCurrentAuthentication(Authentication authentication) {
        return AuthenticationUtil.setFullAuthentication((Authentication)authentication);
    }

    @Override
    public Authentication getCurrentAuthentication() throws AuthenticationException {
        return AuthenticationUtil.getFullAuthentication();
    }

    @Override
    public String getCurrentUserName() throws AuthenticationException {
        return AuthenticationUtil.getFullyAuthenticatedUser();
    }

    @Override
    public void clearCurrentSecurityContext() {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Override
    public String getUserDomain(String userName) {
        return this.tenantService.getUserDomain(userName);
    }
}

