/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class AddFailedThumbnailActionExecuter
extends ActionExecuterAbstractBase {
    private static Log log = LogFactory.getLog(AddFailedThumbnailActionExecuter.class);
    public static final String NAME = "add-failed-thumbnail";
    public static final String PARAM_THUMBNAIL_DEFINITION_NAME = "thumbnail-definition-name";
    public static final String PARAM_FAILURE_DATETIME = "failure-datetime";
    private NodeService nodeService;
    ThumbnailService thumbnailService;
    private BehaviourFilter behaviourFilter;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    public void executeImpl(final Action ruleAction, final NodeRef actionedUponNodeRef) {
        AuthenticationUtil.pushAuthentication();
        try {
            AuthenticationUtil.RunAsWork<Void> runAsWork = new AuthenticationUtil.RunAsWork<Void>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Void doWork() throws Exception {
                    List failedChildren;
                    NodeRef childNode;
                    boolean nodeExists = AddFailedThumbnailActionExecuter.this.nodeService.exists(actionedUponNodeRef);
                    if (!nodeExists) return null;
                    Map<String, Serializable> paramValues = ruleAction.getParameterValues();
                    String thumbDefName = (String)((Object)paramValues.get(AddFailedThumbnailActionExecuter.PARAM_THUMBNAIL_DEFINITION_NAME));
                    Date failureDateTime = (Date)paramValues.get(AddFailedThumbnailActionExecuter.PARAM_FAILURE_DATETIME);
                    QName thumbDefQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)thumbDefName);
                    NodeRef existingThumbnail = AddFailedThumbnailActionExecuter.this.thumbnailService.getThumbnailByName(actionedUponNodeRef, ContentModel.PROP_CONTENT_PROPERTY_NAME, thumbDefName);
                    if (log.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Adding ").append(ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE).append(" to ").append(actionedUponNodeRef);
                        log.debug((Object)msg.toString());
                        msg = new StringBuilder();
                        msg.append("  failed thumbnail definition is ").append(thumbDefName);
                        log.debug((Object)msg.toString());
                        msg = new StringBuilder();
                        msg.append("  failed datetime is ").append(failureDateTime);
                        log.debug((Object)msg.toString());
                        msg = new StringBuilder();
                        msg.append("  existing thumbnail is ").append(existingThumbnail);
                        log.debug((Object)msg.toString());
                    }
                    if (!AddFailedThumbnailActionExecuter.this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE)) {
                        AddFailedThumbnailActionExecuter.this.behaviourFilter.disableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
                        try {
                            AddFailedThumbnailActionExecuter.this.nodeService.addAspect(actionedUponNodeRef, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE, null);
                        }
                        finally {
                            AddFailedThumbnailActionExecuter.this.behaviourFilter.enableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
                        }
                    }
                    NodeRef nodeRef = childNode = (failedChildren = AddFailedThumbnailActionExecuter.this.nodeService.getChildAssocs(actionedUponNodeRef, (QNamePattern)ContentModel.ASSOC_FAILED_THUMBNAIL, (QNamePattern)thumbDefQName)).isEmpty() ? null : ((ChildAssociationRef)failedChildren.get(0)).getChildRef();
                    if (childNode == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("childNode is null " + String.valueOf(actionedUponNodeRef)));
                        }
                        HashMap<QName, Comparable<Date>> props = new HashMap<QName, Comparable<Date>>();
                        props.put(ContentModel.PROP_FAILED_THUMBNAIL_TIME, failureDateTime);
                        props.put(ContentModel.PROP_FAILURE_COUNT, Integer.valueOf(1));
                        AddFailedThumbnailActionExecuter.this.behaviourFilter.disableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
                        try {
                            NodeRef thumbnailNodeRef = AddFailedThumbnailActionExecuter.this.nodeService.createNode(actionedUponNodeRef, ContentModel.ASSOC_FAILED_THUMBNAIL, thumbDefQName, ContentModel.TYPE_FAILED_THUMBNAIL, props).getChildRef();
                            if (!log.isDebugEnabled()) return null;
                            log.debug((Object)("Create failed thumbnail " + String.valueOf(thumbnailNodeRef) + " (" + String.valueOf(thumbDefQName) + ") for " + String.valueOf(actionedUponNodeRef) + ", props " + String.valueOf(props)));
                            return null;
                        }
                        finally {
                            AddFailedThumbnailActionExecuter.this.behaviourFilter.enableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Already a failed thumbnail " + String.valueOf(thumbDefQName) + " for " + String.valueOf(actionedUponNodeRef)));
                        }
                        AddFailedThumbnailActionExecuter.this.nodeService.setProperty(childNode, ContentModel.PROP_FAILED_THUMBNAIL_TIME, (Serializable)failureDateTime);
                        int currentFailureCount = (Integer)AddFailedThumbnailActionExecuter.this.nodeService.getProperty(childNode, ContentModel.PROP_FAILURE_COUNT);
                        AddFailedThumbnailActionExecuter.this.nodeService.setProperty(childNode, ContentModel.PROP_FAILURE_COUNT, (Serializable)Integer.valueOf(currentFailureCount + 1));
                    }
                    return null;
                }
            };
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)runAsWork);
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_THUMBNAIL_DEFINITION_NAME, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_THUMBNAIL_DEFINITION_NAME), false));
        paramList.add(new ParameterDefinitionImpl(PARAM_FAILURE_DATETIME, DataTypeDefinition.DATETIME, true, this.getParamDisplayLabel(PARAM_FAILURE_DATETIME), false));
    }
}

