/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.replication.ReplicationDefinitionImpl;
import org.alfresco.repo.replication.ReplicationDefinitionPersister;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class ReplicationDefinitionPersisterImpl
implements ReplicationDefinitionPersister {
    private static final StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    protected static final NodeRef REPLICATION_ACTION_ROOT_NODE_REF = new NodeRef(SPACES_STORE, "replication_actions_space");
    protected static final Set<QName> ACTION_TYPES = new HashSet<QName>(Arrays.asList(ActionModel.TYPE_ACTION));
    private NodeService nodeService;
    private RuntimeActionService runtimeActionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    @Override
    public List<ReplicationDefinition> loadReplicationDefinitions() {
        this.checkReplicationActionRootNodeExists();
        List childAssocs = this.nodeService.getChildAssocs(REPLICATION_ACTION_ROOT_NODE_REF, ACTION_TYPES);
        ArrayList<ReplicationDefinition> replicationActions = new ArrayList<ReplicationDefinition>(childAssocs.size());
        for (ChildAssociationRef actionAssoc : childAssocs) {
            Action nextAction = this.runtimeActionService.createAction(actionAssoc.getChildRef());
            replicationActions.add(new ReplicationDefinitionImpl(nextAction));
        }
        return replicationActions;
    }

    @Override
    public List<ReplicationDefinition> loadReplicationDefinitions(String targetName) {
        if (targetName == null) {
            throw new NullPointerException("Unexpected null target");
        }
        List<ReplicationDefinition> allReplicationDefinitions = this.loadReplicationDefinitions();
        ArrayList<ReplicationDefinition> filteredReplicationDefinitions = new ArrayList<ReplicationDefinition>();
        for (ReplicationDefinition replicationAction : allReplicationDefinitions) {
            if (!targetName.equals(replicationAction.getTargetName())) continue;
            filteredReplicationDefinitions.add(replicationAction);
        }
        return filteredReplicationDefinitions;
    }

    @Override
    public ReplicationDefinition loadReplicationDefinition(String replicationDefinitionName) {
        return this.loadReplicationDefinition(ReplicationDefinitionPersisterImpl.buildReplicationQName(replicationDefinitionName));
    }

    public ReplicationDefinition loadReplicationDefinition(QName replicationDefinitionName) {
        NodeRef actionNode = this.findActionNode(replicationDefinitionName);
        if (actionNode != null) {
            Action action = this.runtimeActionService.createAction(actionNode);
            return new ReplicationDefinitionImpl(action);
        }
        return null;
    }

    @Override
    public void renameReplicationDefinition(String oldReplicationName, String newReplicationName) {
        this.renameReplicationDefinition(ReplicationDefinitionPersisterImpl.buildReplicationQName(oldReplicationName), ReplicationDefinitionPersisterImpl.buildReplicationQName(newReplicationName));
    }

    public void renameReplicationDefinition(QName oldReplicationName, QName newReplicationName) {
        NodeRef actionNode = this.findActionNode(oldReplicationName);
        if (actionNode == null) {
            return;
        }
        if (this.findActionNode(newReplicationName) != null) {
            throw new ReplicationServiceException("Can't rename to '" + String.valueOf(newReplicationName) + "' as a definition with that name already exists");
        }
        this.nodeService.moveNode(actionNode, REPLICATION_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, newReplicationName);
        ReplicationDefinition rd = this.loadReplicationDefinition(newReplicationName);
        rd.setParameterValue("replicationActionName", (Serializable)newReplicationName);
        this.saveReplicationDefinition(rd);
    }

    @Override
    public void saveReplicationDefinition(ReplicationDefinition replicationAction) {
        NodeRef actionNodeRef = this.findOrCreateActionNode(replicationAction);
        this.runtimeActionService.saveActionImpl(actionNodeRef, replicationAction);
    }

    @Override
    public void deleteReplicationDefinition(ReplicationDefinition replicationAction) {
        QName actionName = replicationAction.getReplicationQName();
        NodeRef actionNode = this.findActionNode(actionName);
        if (actionNode != null) {
            this.nodeService.deleteNode(actionNode);
        }
    }

    private NodeRef findActionNode(QName replicationDefinitionName) {
        this.checkReplicationActionRootNodeExists();
        List childAssocs = this.nodeService.getChildAssocs(REPLICATION_ACTION_ROOT_NODE_REF, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)replicationDefinitionName);
        if (childAssocs.isEmpty()) {
            return null;
        }
        if (childAssocs.size() > 1) {
            throw new ReplicationServiceException("Multiple replication definitions with the name: " + String.valueOf(replicationDefinitionName) + " exist!");
        }
        return ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
    }

    private NodeRef findOrCreateActionNode(ReplicationDefinition replicationAction) {
        QName actionName = replicationAction.getReplicationQName();
        NodeRef actionNode = this.findActionNode(actionName);
        if (actionNode == null) {
            actionNode = this.runtimeActionService.createActionNodeRef(replicationAction, REPLICATION_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, actionName);
        }
        return actionNode;
    }

    private void checkReplicationActionRootNodeExists() {
        if (!this.nodeService.exists(REPLICATION_ACTION_ROOT_NODE_REF)) {
            throw new ReplicationServiceException("Unable to find replication action root node.");
        }
    }

    private static QName buildReplicationQName(String name) {
        return QName.createQName(null, (String)name);
    }
}

