/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.util.GregorianCalendar;
import org.alfresco.repo.content.filestore.FileContentUrlProvider;
import org.alfresco.util.GUID;

class TimeBasedFileContentUrlProvider
implements FileContentUrlProvider {
    protected int bucketsPerMinute = 0;

    TimeBasedFileContentUrlProvider() {
    }

    public void setBucketsPerMinute(int bucketsPerMinute) {
        this.bucketsPerMinute = bucketsPerMinute;
    }

    @Override
    public String createNewFileStoreUrl() {
        return TimeBasedFileContentUrlProvider.createNewFileStoreUrl(this.bucketsPerMinute);
    }

    public static String createTimeBasedPath(int bucketsPerMinute) {
        GregorianCalendar calendar = new GregorianCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        StringBuilder sb = new StringBuilder(20);
        sb.append(year).append('/').append(month).append('/').append(day).append('/').append(hour).append('/').append(minute).append('/');
        if (bucketsPerMinute != 0) {
            long seconds = System.currentTimeMillis() % 60000L;
            int actualBucket = (int)seconds / (60000 / bucketsPerMinute);
            sb.append(actualBucket).append('/');
        }
        return sb.toString();
    }

    public static String createNewFileStoreUrl(int minuteBucketCount) {
        StringBuilder sb = new StringBuilder(20);
        sb.append("store");
        sb.append("://");
        sb.append(TimeBasedFileContentUrlProvider.createTimeBasedPath(minuteBucketCount));
        sb.append(GUID.generate()).append(".bin");
        return sb.toString();
    }
}

