/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.transfer.ChildAssociatedNodeFinder;
import org.alfresco.repo.transfer.StandardNodeCrawlerImpl;
import org.alfresco.repo.transfer.TransferTestUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.service.cmr.transfer.TransferTarget;

public class TransferTreeActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "transfer-this-tree";
    private TransferService transferService;
    private ServiceRegistry serviceRegistry;

    public void setTransferService(TransferService transferService) {
        this.transferService = transferService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        TransferTarget target = TransferTestUtil.getTestTarget(this.transferService);
        StandardNodeCrawlerImpl crawler = new StandardNodeCrawlerImpl(this.serviceRegistry);
        crawler.setNodeFinders(new ChildAssociatedNodeFinder(ContentModel.ASSOC_CONTAINS));
        Set<NodeRef> nodes = crawler.crawl(actionedUponNodeRef);
        TransferDefinition td = new TransferDefinition();
        td.setNodes(nodes);
        this.transferService.transfer(target.getName(), td);
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

