/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import org.alfresco.repo.content.filestore.FileContentStoreTest;
import org.alfresco.repo.content.filestore.FileContentUrlProvider;
import org.alfresco.repo.content.filestore.TimeBasedFileContentUrlProvider;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class, NeverRunsTests.class})
public class BucketAwareFileContentStoreTest
extends FileContentStoreTest {
    private static final int BUCKETS_PER_MINUTE = 20;
    private static final int ITERATIONS = 5;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        TimeBasedFileContentUrlProvider fileContentUrlProvider = new TimeBasedFileContentUrlProvider();
        fileContentUrlProvider.setBucketsPerMinute(20);
        this.store.setFileContentUrlProvider((FileContentUrlProvider)fileContentUrlProvider);
    }

    @Test
    public void testBucketCreation() throws Exception {
        int createdBuckets;
        File firstFile = this.store.createNewFile();
        int i = 0;
        while (i < 5) {
            this.store.createNewFile();
            Thread.sleep(3000L);
            ++i;
        }
        File lastFile = this.store.createNewFile();
        File firstFileMinute = firstFile.getParentFile().getParentFile();
        File lastFileMinute = lastFile.getParentFile().getParentFile();
        int firstFileMinuteBuckets = firstFileMinute.list().length;
        if (!firstFileMinute.equals(lastFileMinute)) {
            int lastFileMinutesBuckets = lastFileMinute.list().length;
            createdBuckets = firstFileMinuteBuckets + lastFileMinutesBuckets;
        } else {
            createdBuckets = firstFileMinuteBuckets;
        }
        Assert.assertTrue((String)"Unexpected number of buckets created", (createdBuckets == 6 ? 1 : 0) != 0);
    }
}

